/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.infrastructure.emf;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.stp.core.infrastructure.assertion.Assert;
import org.eclipse.stp.core.infrastructure.emf.IResourceDescriptor;

public class EclipseResourceDescriptor
implements IResourceDescriptor {
    private final IPath defaultPath;
    private IPath localPath;
    private boolean loadAsReadOnly;
    private String scheme = "platform:/resource";

    public EclipseResourceDescriptor(IPath theDefaultPath, IPath workspaceRelativeLocalPath) {
        Assert.isNotNull(theDefaultPath);
        Assert.isLegal(theDefaultPath.segmentCount() > 0);
        this.localPath = workspaceRelativeLocalPath;
        this.defaultPath = theDefaultPath;
    }

    public String toString() {
        return "ResourceDescriptor[localPath=\"" + this.localPath + "\", defaultPath=\"" + this.defaultPath + "\"].";
    }

    public EclipseResourceDescriptor(IFile aFile) {
        Assert.isNotNull(aFile);
        this.localPath = aFile.getFullPath();
        this.defaultPath = aFile.getProjectRelativePath();
    }

    public EclipseResourceDescriptor(IFile aFile, String aRequestProtocol) {
        Assert.isNotNull(aFile);
        this.localPath = aFile.getFullPath();
        this.defaultPath = aFile.getProjectRelativePath();
        this.scheme = aRequestProtocol;
    }

    public boolean isLoadAsReadOnly() {
        return this.loadAsReadOnly;
    }

    public void setLoadAsReadOnly(boolean toLoadAsReadOnly) {
        this.loadAsReadOnly = toLoadAsReadOnly;
    }

    public IPath getLocalPath() {
        if (this.localPath == null) {
            return this.getDefaultPath();
        }
        return this.localPath;
    }

    public IPath getDefaultPath() {
        return this.defaultPath;
    }

    public boolean matches(IFile file) {
        return this.getLocalPath().equals((Object)file.getFullPath());
    }

    public boolean equals(Object obj) {
        if (obj instanceof IResourceDescriptor) {
            IResourceDescriptor other = (IResourceDescriptor)obj;
            if (this.getRequestProtocol() == null) {
                return other.getRequestProtocol() == null && this.getLocalPath().equals((Object)other.getLocalPath());
            }
            if (this.getRequestProtocol().equals(other.getRequestProtocol())) {
                return this.getLocalPath().equals((Object)other.getLocalPath());
            }
        }
        return false;
    }

    public int hashCode() {
        return this.getLocalPath().hashCode();
    }

    public String getRequestProtocol() {
        return this.scheme;
    }
}

