/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IDeploySession;
import org.eclipse.stp.soas.deploy.core.IPackageOutputDescriptor;

public abstract class DeploySessionBase
implements IDeploySession {
    private IConnectionProfile mProfile;

    public DeploySessionBase(IConnectionProfile profile) {
        this.mProfile = profile;
    }

    public IConnectionProfile getConnectionProfile() {
        return this.mProfile;
    }

    public IStatus[] preDeployCheck(IPackageOutputDescriptor descriptor) {
        IConnection connection = this.getConnectionProfile().createConnection("org.eclipse.datatools.connectivity.connectionFactory.pingFactory");
        try {
            if (connection == null || connection.getRawConnection() == null) {
                Status status = new Status(4, DeployCorePlugin.getDefault().getBundle().getSymbolicName(), -1, DeployCorePlugin.getDefault().getResourceString("DeployCheck.ERROR.CannotConnectToServer", new Object[]{descriptor.getLogicalName(), this.getConnectionProfile().getName()}), null);
                IStatus[] iStatusArray = new IStatus[]{status};
                return iStatusArray;
            }
            IStatus[] iStatusArray = new IStatus[]{};
            return iStatusArray;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public abstract void deploy(IPackageOutputDescriptor var1) throws Exception;

    public abstract void undeploy(IPackageOutputDescriptor var1) throws Exception;

    public abstract IStatus[] preUndeployCheck(IPackageOutputDescriptor var1);
}

