/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.dialogs;

import java.net.URL;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.ConnectionProfileTreeViewer;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.DialogPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;

public class ConnectionProfileSelectionDialogPage
extends DialogPage {
    public static final String TITLE = DeployCorePlugin.getDefault().getResourceString("ConnectionProfileSelectionDialogPage.title.selectConnectionProfile");
    public static final String ICON_PATH = "icons/blank_wizard_graphic.gif";
    public static final ImageDescriptor ICON_DESC;
    public static final String LABEL_SELECT_PACKAGES;
    public static final int MIN_TREE_HEIGHT;
    private ConnectionProfileTreeViewer mCPViewer;
    private IConnectionProfile mSelectedCP;
    private IPackage mPackage;
    private Collection mExistingProfiles;

    static {
        URL url = null;
        try {
            url = DeployCorePlugin.getDefault().getBundle().getEntry(ICON_PATH);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        ICON_DESC = url == null ? ImageDescriptor.getMissingImageDescriptor() : ImageDescriptor.createFromURL((URL)url);
        LABEL_SELECT_PACKAGES = DeployCorePlugin.getDefault().getResourceString("ConnectionProfileSelectionDialogPage.LABLE.selectConnectionProfile");
        MIN_TREE_HEIGHT = 15;
    }

    public ConnectionProfileSelectionDialogPage() {
        this(TITLE, ICON_DESC);
    }

    public ConnectionProfileSelectionDialogPage(String title, ImageDescriptor image) {
        super(title, image);
        this.setNeedsApplyButton(false);
    }

    public void init(Root root, IPackage pkg) {
        this.mExistingProfiles = new TreeSet(new ProfileComparator());
        this.mExistingProfiles.addAll(root.getServer());
        this.mPackage = pkg;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        content.setLayout((Layout)new GridLayout(1, false));
        content.setLayoutData((Object)new GridData(1808));
        Label label = new Label(content, 0);
        label.setText(LABEL_SELECT_PACKAGES);
        GridData data = new GridData();
        label.setLayoutData((Object)data);
        Tree tree = new Tree(content, 772);
        this.mCPViewer = new ConnectionProfileTreeViewer(tree);
        this.mCPViewer.getViewer().setAutoExpandLevel(3);
        data = new GridData(1808);
        data.heightHint = tree.getItemHeight() * MIN_TREE_HEIGHT;
        tree.setLayoutData((Object)data);
        this.mCPViewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConnectionProfileSelectionDialogPage.this.handleCPSelectionChanged();
            }
        });
        this.mCPViewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ConnectionProfileSelectionDialogPage.this.handleCPDoubleClick();
            }
        });
        this.mCPViewer.getViewer().addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                boolean retVal = element instanceof IConnectionProfile ? !ConnectionProfileSelectionDialogPage.this.mExistingProfiles.contains(element) : element instanceof ICategory;
                return retVal;
            }
        });
        if (this.mPackage != null) {
            this.mCPViewer.getViewer().addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    boolean retVal = element instanceof IConnectionProfile ? DeploymentExtensionManager.getInstance().getDeployDriver(ConnectionProfileSelectionDialogPage.this.mPackage, ((IConnectionProfile)element).getProviderId()) != null : true;
                    return retVal;
                }
            });
        }
        this.initControls();
        this.setControl((Control)content);
    }

    public boolean performOk() {
        boolean retVal;
        IStructuredSelection selection = (IStructuredSelection)this.mCPViewer.getViewer().getSelection();
        if (selection.isEmpty()) {
            this.mSelectedCP = null;
            retVal = false;
        } else {
            this.mSelectedCP = (IConnectionProfile)selection.getFirstElement();
            retVal = true;
        }
        return retVal;
    }

    public IConnectionProfile getSelection() {
        return this.mSelectedCP;
    }

    private void initControls() {
        this.mCPViewer.getViewer().setInput((Object)ProfileManager.getInstance());
        this.updateControls();
        this.validate();
        this.setErrorMessage(null);
    }

    private void updateControls() {
    }

    private void validate() {
        IStructuredSelection selection = (IStructuredSelection)this.mCPViewer.getViewer().getSelection();
        if (selection.isEmpty() || !(selection.getFirstElement() instanceof IConnectionProfile)) {
            this.setErrorMessage(DeployCorePlugin.getDefault().getResourceString("ConnectionProfileSelectionDialogPage.error.selectConnectionProfile"));
            this.setIsValid(false);
        } else {
            this.setErrorMessage(null);
            this.setIsValid(true);
        }
    }

    private void handleCPDoubleClick() {
        this.updateControls();
        this.validate();
        if (this.isValid()) {
            this.getContainer().closeOK();
        }
    }

    private void handleCPSelectionChanged() {
        this.updateControls();
        this.validate();
    }

    private static class ProfileComparator
    implements Comparator {
        private ProfileComparator() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = o1 instanceof IConnectionProfile ? ((IConnectionProfile)o1).getName() : (o1 instanceof DeployServer ? ((DeployServer)o1).getProfileName() : (String)o1);
            String s2 = o2 instanceof IConnectionProfile ? ((IConnectionProfile)o2).getName() : (o2 instanceof DeployServer ? ((DeployServer)o2).getProfileName() : (String)o2);
            return s1.compareTo(s2);
        }
    }
}

