/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.export;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.common.ui.util.WindowUtil;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.DiagramUIRenderPlugin;
import org.eclipse.gmf.runtime.diagram.ui.render.internal.l10n.DiagramUIRenderMessages;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.dialogs.WizardExportResourcesPage;

public class ImageExportWizard
extends Wizard
implements IExportWizard {
    private ExportImagePage imagePage;

    public boolean performFinish() {
        List exporting = this.imagePage.getSelectedResources();
        if (exporting.isEmpty()) {
            this.imagePage.setErrorMessage("No resources are selected");
            return false;
        }
        for (Object toExport : exporting) {
            if (toExport == null || !(toExport instanceof IFile)) {
                return false;
            }
            if (((IFile)toExport).getFileExtension().equals("bpmn_diagram")) continue;
            this.imagePage.setErrorMessage("A file with an invalid extension is selected. Deselect it and try again.");
            return false;
        }
        if (exporting.size() > 1) {
            this.imagePage.setErrorMessage("Please select one diagram only");
            return false;
        }
        Object selected = this.imagePage.getSelectedResources().get(0);
        IRunnableWithProgress runnable = this.createRunnable((IFile)selected, this.imagePage.getDestinationPath(), this.imagePage.getImageFormat());
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            progressMonitorDialog.run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            Log.warning((Plugin)DiagramUIRenderPlugin.getInstance(), (int)9, (String)e.getTargetException().getMessage(), (Throwable)e.getTargetException());
            if (e.getTargetException() instanceof OutOfMemoryError) {
                this.openErrorDialog(DiagramUIRenderMessages.CopyToImageAction_outOfMemoryMessage);
            } else if (e.getTargetException() instanceof SWTError) {
                this.openErrorDialog(DiagramUIRenderMessages.CopyToImageAction_outOfMemoryMessage);
            } else {
                this.openErrorDialog(e.getTargetException().getMessage());
            }
            return true;
        }
        catch (InterruptedException e) {
            Log.warning((Plugin)DiagramUIRenderPlugin.getInstance(), (int)9, (String)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private void openErrorDialog(String message) {
        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)DiagramUIRenderMessages.CopyToImageAction_copyToImageErrorDialogTitle, (String)NLS.bind((String)DiagramUIRenderMessages.CopyToImageAction_copyToImageErrorDialogMessage, (Object)message));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle("BPMN to Image Export Wizard");
        this.imagePage = new ExportImagePage(selection);
        this.addPage((IWizardPage)this.imagePage);
    }

    private IRunnableWithProgress createRunnable(final IFile diagram, final IPath destination, final ImageFileFormat format) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain((ResourceSet)resourceSet);
                Resource res = resourceSet.getResource(URI.createPlatformResourceURI((String)diagram.getFullPath().toString(), (boolean)true), true);
                Diagram tempD = null;
                for (Object resElt : res.getContents()) {
                    if (!(resElt instanceof Diagram)) continue;
                    tempD = (Diagram)resElt;
                }
                if (tempD == null) {
                    return;
                }
                Diagram diagram2 = tempD;
                try {
                    new CopyToImageUtil().copyToImage(diagram2, destination, format, (IProgressMonitor)new NullProgressMonitor(), BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                }
                catch (CoreException e) {
                    BpmnDiagramEditorPlugin.getInstance().getLog().log((IStatus)new Status(4, "org.eclipse.stp.bpmn.diagram", 4, e.getMessage(), (Throwable)e));
                }
            }
        };
    }

    private class ExportImagePage
    extends WizardExportResourcesPage {
        private Text folderText;
        private boolean folderValid;
        private String folder;
        private boolean fileNameValid;
        private Text fileNameText;
        private String fileName;
        private Combo imageFormatCombo;
        private ImageFileFormat imageFormat;

        public ExportImagePage(IStructuredSelection sel) {
            super("Select the diagram to export", sel);
            this.folder = "";
            this.fileNameValid = false;
            this.fileName = "image";
            this.imageFormat = ImageFileFormat.JPG;
            this.setTitle("Export a BPMN diagram as an image");
            this.setDescription("Choose a file and a format to export the diagram as an image");
        }

        private Composite createComposite(Composite parent, int columns) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = columns;
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            gridLayout.makeColumnsEqualWidth = false;
            GridData data = new GridData(768);
            composite.setLayoutData((Object)data);
            composite.setLayout((Layout)gridLayout);
            return composite;
        }

        protected void createDestinationGroup(Composite parent) {
            Composite composite = this.createComposite(parent, 3);
            Label folderLabel = new Label(composite, 0);
            folderLabel.setText("Export folder");
            this.folderText = new Text(composite, 2048);
            this.folderText.setText(this.folder == null ? "" : this.folder);
            this.folderText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExportImagePage.this.validateFolderText();
                }
            });
            GridData gridData = new GridData(768);
            gridData.widthHint = 250;
            this.folderText.setLayoutData((Object)gridData);
            Button button = new Button(composite, 8);
            button.setText("Browse");
            button.setLayoutData((Object)WindowUtil.makeButtonData((Button)button));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    ExportImagePage.this.handleBrowseButtonPressed();
                }
            });
            Label fileNameLabel = new Label(composite, 0);
            fileNameLabel.setText("Image file name");
            this.fileNameText = new Text(composite, 2048);
            this.fileNameText.setText(String.valueOf(this.fileName) + "." + this.imageFormat.getName().toLowerCase());
            this.fileNameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ExportImagePage.this.validateFileNameText();
                }
            });
            gridData = new GridData(768);
            gridData.widthHint = 250;
            this.fileNameText.setLayoutData((Object)gridData);
        }

        public void handleEvent(Event event) {
        }

        protected List getTypesToExport() {
            LinkedList<String> types = new LinkedList<String>();
            types.add("bpmn_diagram");
            return types;
        }

        public List getSelectedResources() {
            return super.getSelectedResources();
        }

        protected void createOptionsGroupButtons(Group optionsGroup) {
            Composite composite = this.createComposite((Composite)optionsGroup, 2);
            Label label = new Label(composite, 0);
            label.setText("Image format");
            this.imageFormatCombo = new Combo(composite, 12);
            this.imageFormatCombo.setItems(this.getImageFormatItems());
            this.imageFormatCombo.setText(this.imageFormat.getName());
            this.imageFormatCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExportImagePage.this.imageFormat = ImageFileFormat.resolveImageFormat((int)ExportImagePage.this.imageFormatCombo.getSelectionIndex());
                    ExportImagePage.this.fileNameText.setText(String.valueOf(ExportImagePage.this.fileName) + "." + ExportImagePage.this.imageFormat.getName().toLowerCase());
                    ExportImagePage.this.validateFileNameText();
                }
            });
            GridData gridData = new GridData(768);
            gridData.widthHint = 250;
            this.imageFormatCombo.setLayoutData((Object)gridData);
        }

        private String[] getImageFormatItems() {
            String[] items = new String[ImageFileFormat.VALUES.length];
            int i = 0;
            while (i < ImageFileFormat.VALUES.length) {
                items[i] = ImageFileFormat.VALUES[i].getName();
                ++i;
            }
            return items;
        }

        private void handleBrowseButtonPressed() {
            String selectedDirectory;
            File path;
            DirectoryDialog dialog = new DirectoryDialog(Display.getCurrent().getActiveShell());
            dialog.setMessage("Export image");
            dialog.setText("Choose a folder to hold the exported image");
            String dirName = this.folderText.getText();
            if (!dirName.equals("") && (path = new File(dirName)).exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
            if ((selectedDirectory = dialog.open()) != null) {
                this.folderText.setText(selectedDirectory);
            }
        }

        private void validateFolderText() {
            if (this.folderText.getText().equals("")) {
                this.setMessage(null);
                this.folderValid = false;
                return;
            }
            Path path = new Path("");
            if (!path.isValidPath(this.folderText.getText())) {
                this.setErrorMessage("The folder is invalid");
                this.folderValid = false;
                return;
            }
            File file = new File(this.folderText.getText());
            if (!file.exists()) {
                this.setErrorMessage("The folder does not exist.");
                this.folderValid = false;
                return;
            }
            this.folderValid = true;
            this.folder = this.folderText.getText();
            if (this.fileNameValid) {
                this.setMessage(null);
            } else {
                this.validateFileNameText();
            }
        }

        private void validateFileNameText() {
            IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(this.fileNameText.getText(), 1);
            if (!nameStatus.isOK()) {
                this.setErrorMessage(nameStatus.getMessage());
                this.fileNameValid = false;
                return;
            }
            this.fileNameValid = true;
            IPath filePath = new Path(this.fileNameText.getText()).removeFileExtension();
            this.fileName = filePath.toString();
            if (this.folderValid) {
                this.setMessage(null);
            } else {
                this.validateFolderText();
            }
        }

        public IPath getDestinationPath() {
            Path path = new Path(this.folder);
            String fnWithExtension = String.valueOf(this.fileName) + "." + this.imageFormat.getName().toLowerCase();
            return path.append(fnWithExtension);
        }

        public ImageFileFormat getImageFormat() {
            return this.imageFormat;
        }
    }
}

