/*******************************************************************************

* Copyright (c) 2006 IONA Technologies PLC

* All rights reserved. This program and the accompanying materials

* are made available under the terms of the Eclipse Public License v1.0

* which accompanies this distribution, and is available at

* http://www.eclipse.org/legal/epl-v10.html

* 

* Contributors:

*     IONA Technologies PLC - initial API and implementation

*******************************************************************************/
package org.eclipse.stp.sc.xmlvalidator.classbuilder;

import java.util.List;

import org.eclipse.stp.sc.xmlvalidator.classbuilder.inst.JInstruction;

public class JCodeStep {

     public JInstruction opCode;
     public Object opData;
     public List<?> paramList = null;

     public JCodeStep(JInstruction code){
    	 this(code, null);
     }
     
     
     public JCodeStep(JInstruction code, Object data) {
    	 opCode = code;
         opData = data;
     }
 

     public void accept(JVisitor v) throws Exception {
         v.visitCodeStep(this);
     }
     
     public String toString() {
    	 StringBuffer sb = new StringBuffer();
    	 sb.append("        code:" + opCode + " data:" + opData);
    	 return sb.toString();
     }
}
