/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.runtimeintegrator;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.runtimeintegrator.ExtGeneratorTool;
import org.eclipse.stp.sc.common.runtimeintegrator.ExtRtIntegrator;
import org.eclipse.stp.sc.common.runtimeintegrator.IGeneratorTool;
import org.eclipse.stp.sc.common.runtimeintegrator.IParameterPage;
import org.eclipse.stp.sc.common.runtimeintegrator.IRuntimeKitProcessorTemplate;
import org.eclipse.stp.sc.common.runtimeintegrator.RtIntegratorFactory;
import org.eclipse.stp.sc.common.utils.ExtensionRegUtils;

public abstract class RtIntegratorMgr {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(RtIntegratorMgr.class);
    public static final String EXT_POINT_RUNTIMEINTEGRATOR = "org.eclipse.stp.sc.common.runtimeIntegrator";
    public static final QualifiedName PROPERTY_KEY_RUNTIME_INTEGRATOR_UID = new QualifiedName("stp.sc", "runtimeintegrator_id");
    protected Hashtable<String, ExtRtIntegrator> runtimeIntTable = new Hashtable();

    public RtIntegratorMgr() {
        this.loadRuntimeIntegrators();
    }

    public ExtRtIntegrator[] getRuntimeIntegrators(String serverType) {
        ArrayList<ExtRtIntegrator> integrators = new ArrayList<ExtRtIntegrator>();
        for (ExtRtIntegrator runtimeInt : this.runtimeIntTable.values()) {
            if (!runtimeInt.getTargetServerType().equals(serverType)) continue;
            integrators.add(runtimeInt);
        }
        return integrators.toArray(new ExtRtIntegrator[0]);
    }

    private void loadRuntimeIntegrators() {
        IExtension[] extensions;
        IExtensionPoint integratorPoint = ExtensionRegUtils.getExtensionPoint(EXT_POINT_RUNTIMEINTEGRATOR);
        IExtension[] iExtensionArray = extensions = integratorPoint.getExtensions();
        int n = 0;
        int n2 = iExtensionArray.length;
        while (n < n2) {
            IExtension ext = iExtensionArray[n];
            try {
                ExtRtIntegrator runtime = RtIntegratorFactory.createRuntimeIntegrator(ext);
                this.runtimeIntTable.put(runtime.getId(), runtime);
                LOG.debug((Object)("loaded runtime integrator:" + runtime.toString()));
            }
            catch (CoreException e) {
                LOG.error((Object)e);
                e.printStackTrace();
            }
            ++n;
        }
    }

    public IGeneratorTool getGeneratorTool(String toolID) throws CoreException {
        for (ExtRtIntegrator integrator : this.runtimeIntTable.values()) {
            for (ExtGeneratorTool tool : integrator.getTools()) {
                if (!tool.getToolType().equals(toolID)) continue;
                return tool.getToolClass();
            }
        }
        return null;
    }

    public IGeneratorTool getGeneratorTool(String runtimeIntegratorID, String toolType) throws CoreException {
        ExtRtIntegrator runtimeInt = this.runtimeIntTable.get(runtimeIntegratorID);
        for (ExtGeneratorTool tool : runtimeInt.getTools()) {
            if (!tool.getToolType().equals(toolType)) continue;
            return tool.getToolClass();
        }
        return null;
    }

    public IRuntimeKitProcessorTemplate getKitProcessorTemplate(String runtimeIntegratorID) throws CoreException {
        return this.runtimeIntTable.get(runtimeIntegratorID).getKitTemplate();
    }

    public IParameterPage getParameterPage(String runtimeExtID, String toolType) throws CoreException {
        ExtRtIntegrator runtimeInt = this.runtimeIntTable.get(runtimeExtID);
        for (ExtGeneratorTool tool : runtimeInt.getTools()) {
            if (!tool.getToolType().equals(toolType)) continue;
            return tool.getParameterPage();
        }
        return null;
    }

    public IParameterPage getParameterPage(IProject project, String toolType) throws CoreException {
        String runtimeId = this.getRuntimeIntegratorID(project);
        return this.getParameterPage(runtimeId, toolType);
    }

    public abstract String getDefaultRuntimeIntegratorID();

    public String getRuntimeIntegratorID(IProject project) throws CoreException {
        String projectRuntimeID = this.getRuntimeIDProjectProperty(project);
        if (projectRuntimeID != null) {
            return projectRuntimeID;
        }
        return this.getDefaultRuntimeIntegratorID();
    }

    protected String getRuntimeIDProjectProperty(IProject project) throws CoreException {
        return project.getPersistentProperty(PROPERTY_KEY_RUNTIME_INTEGRATOR_UID);
    }
}

