/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.properties;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.ScJaxWsPlugin;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.properties.ScJaxWsPropertyConstants;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IRuntimeKitProcessor;
import org.eclipse.stp.sc.jaxws.runtimeprovider.RuntimeProviderManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;

public class ScJaxWsPropertyPage
extends PropertyPage {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScJaxWsPropertyPage.class);
    private DirectoryFieldEditor editor = null;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        this.addRuntimeProviderInfo(composite);
        return composite;
    }

    private void addRuntimeProviderInfo(Composite comp) {
        String edLabel = ScJaxWsResources.getString("Project.Runtime.Property.Name");
        this.editor = new DirectoryFieldEditor("", edLabel, comp);
        String installDir = null;
        try {
            installDir = ((IResource)this.getElement()).getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_RUNTIME_ROOT);
        }
        catch (CoreException coreException) {
            LOG.debug((Object)"Error setting initial value to installation field");
        }
        this.editor.setStringValue(installDir != null ? installDir : "");
    }

    protected void performDefaults() {
        IRuntimeKitProcessor rtProcessor = RuntimeProviderManager.getInstance().getRuntimeKitProcessor((IProject)this.getElement());
        IPath kitPath = rtProcessor.getInstallationDirectory();
        this.editor.setStringValue(kitPath.toOSString());
    }

    public boolean performOk() {
        String oldValue = null;
        IRuntimeKitProcessor rtp = null;
        IJavaProject jProject = null;
        try {
            oldValue = ((IResource)this.getElement()).getPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_RUNTIME_ROOT);
            if (oldValue != null) {
                rtp = ScJaxWsPlugin.getRuntimeProviderManager().getRuntimeKitProcessor((IProject)this.getElement());
                jProject = JavaCore.create((IProject)((IProject)this.getElement()));
                rtp.clearJavaProjectBuildPath(jProject);
            }
            ((IResource)this.getElement()).setPersistentProperty(ScJaxWsPropertyConstants.PROPERTY_KEY_RUNTIME_ROOT, this.editor.getStringValue());
        }
        catch (CoreException coreException) {
            return false;
        }
        try {
            rtp.completeJavaProjectBuildPath(jProject);
        }
        catch (JavaModelException e) {
            LOG.debug((Object)"Failed to update project build path", (Throwable)e);
        }
        catch (CoreException e) {
            LOG.debug((Object)"Failed to update project build path", (Throwable)e);
        }
        return true;
    }
}

