/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.core.saf.ui.contribution;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.stp.core.internal.saf.ui.Activator;
import org.eclipse.stp.core.internal.saf.ui.Messages;
import org.eclipse.stp.core.saf.ui.contribution.ISOAPropertiesContribution;
import org.eclipse.stp.core.saf.ui.contribution.ISOAPropertiesEntry;

public class SOAPropertiesEntry
implements ISOAPropertiesEntry {
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAMESPACE_URI = "namespaceURI";
    private static final String ATTR_TYPE_NAME = "typeName";
    private static final String ATTR_CLASS = "class";
    private IConfigurationElement _element;
    private String _id;
    private String _namespaceURI;
    private String _typeName;
    private String _className;
    private ISOAPropertiesContribution _contributor;
    private String _contributorPluginID = null;

    public SOAPropertiesEntry(IConfigurationElement element) throws IllegalArgumentException {
        this._element = element;
        String value = element.getAttribute(ATTR_ID);
        if (value == null || value.length() == 0) {
            String error = Activator.internalReportConfigurationError(Messages.Missing_id, new String[]{this.getContributorPluginID()});
            throw new IllegalArgumentException(error);
        }
        this._id = value;
        value = element.getAttribute(ATTR_NAMESPACE_URI);
        if (value == null || value.length() == 0) {
            String error = Activator.internalReportConfigurationError(Messages.Missing_attribute, new String[]{this.getId(), ATTR_NAMESPACE_URI});
            throw new IllegalArgumentException(error);
        }
        this._namespaceURI = value;
        value = element.getAttribute(ATTR_TYPE_NAME);
        if (value == null || value.length() == 0) {
            String error = Activator.internalReportConfigurationError(Messages.Missing_attribute, new String[]{this.getId(), ATTR_TYPE_NAME});
            throw new IllegalArgumentException(error);
        }
        this._typeName = value;
        value = element.getAttribute(ATTR_CLASS);
        if (value == null || value.length() == 0) {
            String error = Activator.internalReportConfigurationError(Messages.Missing_attribute, new String[]{this.getId(), ATTR_CLASS});
            throw new IllegalArgumentException(error);
        }
        this._className = value;
    }

    public ISOAPropertiesContribution getContributor() {
        if (this._contributor == null) {
            this._contributor = this.newContributor();
        }
        return this._contributor;
    }

    public ISOAPropertiesContribution newContributor() {
        ISOAPropertiesContribution contributor = null;
        try {
            contributor = (ISOAPropertiesContribution)this._element.createExecutableExtension(ATTR_CLASS);
        }
        catch (CoreException exc) {
            Activator.internalReportConfigurationError(Messages.Cannot_create_instance, new String[]{this.getId(), this.getTypeName(), exc.getLocalizedMessage()});
        }
        catch (ClassCastException classCastException) {
            Activator.internalReportConfigurationError(Messages.Class_must_implement, new String[]{this.getId(), this.getTypeName()});
        }
        return contributor;
    }

    public String getContributorPluginID() {
        if (this._contributorPluginID == null) {
            IExtension extension = this._element.getDeclaringExtension();
            this._contributorPluginID = extension.getNamespaceIdentifier();
        }
        return this._contributorPluginID;
    }

    public String getId() {
        return this._id;
    }

    public String getTypeName() {
        return this._typeName;
    }

    public String getClassName() {
        return this._className;
    }

    public String getNamespaceURI() {
        return this._namespaceURI;
    }
}

