/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.annotations.ext;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.annotations.ext.IAnnotationInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationSupportProxy {
    private static final String EXT_ATT_SC_ANN_CLASS_ONLY = "classOnly";
    private static final String EXT_ATT_SC_ANN_INTERFACE_ONLY = "interfaceOnly";
    private static final String EXT_ATT_SC_ANN_NATURE = "nature";
    private static final String EXT_ATT_SC_ANN_INIT_CLASS = "initializerClass";
    private static final String EXT_ATT_SC_ANN_CLASS = "annotationClass";
    private static final String EXT_ELT_SC_ANN = "annotation";
    private static Map<String, Class<? extends Annotation>> JAXWS_ANN_DECL;
    private static Map<Class<? extends Annotation>, IAnnotationInitializer> JAXWS_ANN_INIT;
    private static Map<String, String> ANN_NATURES;
    private static Map<String, Boolean> ANN_CLASS_ONLY;
    private static Map<String, Boolean> ANN_INTERFACE_ONLY;
    private static final LoggingProxy LOG;
    public static final String EXT_POINT_SC_ANNOTATION_SUPPORT = "org.eclipse.stp.sc.common.AnnotationSupport";

    static {
        LOG = LoggingProxy.getlogger(AnnotationSupportProxy.class);
    }

    private AnnotationSupportProxy() {
    }

    public static void loadAnnotationSupportExtensions() {
        String extPointId = EXT_POINT_SC_ANNOTATION_SUPPORT;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extElts = reg.getConfigurationElementsFor(extPointId);
        JAXWS_ANN_DECL = new HashMap<String, Class<? extends Annotation>>(extElts.length);
        JAXWS_ANN_INIT = new HashMap<Class<? extends Annotation>, IAnnotationInitializer>(extElts.length);
        ANN_NATURES = new HashMap<String, String>();
        ANN_CLASS_ONLY = new HashMap<String, Boolean>();
        ANN_INTERFACE_ONLY = new HashMap<String, Boolean>();
        int extIndex = 0;
        while (extIndex < extElts.length) {
            if (extElts[extIndex].getName().equals(EXT_ELT_SC_ANN)) {
                String natureID;
                StringBuffer msg;
                StringBuffer msg2;
                String annotationClassName = extElts[extIndex].getAttribute(EXT_ATT_SC_ANN_CLASS);
                LOG.debug((Object)("Load Annoation support:" + annotationClassName));
                Class<?> annotationClass = null;
                try {
                    Class<?> tmpUntypedClass;
                    annotationClass = tmpUntypedClass = Class.forName(annotationClassName);
                    annotationClass.asSubclass(Annotation.class);
                    JAXWS_ANN_DECL.put(annotationClass.getSimpleName(), annotationClass);
                    LOG.debug((Object)("annotation added: " + annotationClassName));
                }
                catch (ClassNotFoundException e) {
                    msg2 = new StringBuffer("Invalid ").append(EXT_POINT_SC_ANNOTATION_SUPPORT).append(" extension definition: '").append(annotationClassName).append("' is not a valid class name");
                    LOG.error((Object)msg2.toString(), (Throwable)e);
                }
                catch (ClassCastException e) {
                    msg2 = new StringBuffer("Invalid ").append(EXT_POINT_SC_ANNOTATION_SUPPORT).append(" extension definition: the class '").append(annotationClassName).append("' is not a <Annotation> class");
                    LOG.debug((Object)msg2.toString(), (Throwable)e);
                }
                String intializerClassName = extElts[extIndex].getAttribute(EXT_ATT_SC_ANN_INIT_CLASS);
                try {
                    if (annotationClass != null && intializerClassName != null) {
                        IAnnotationInitializer initializerObj = (IAnnotationInitializer)extElts[extIndex].createExecutableExtension(EXT_ATT_SC_ANN_INIT_CLASS);
                        JAXWS_ANN_INIT.put(annotationClass, initializerObj);
                        LOG.debug((Object)("annotation initializer added: " + initializerObj.getClass().getCanonicalName()));
                    }
                }
                catch (CoreException e) {
                    msg = new StringBuffer("Invalid ").append(EXT_POINT_SC_ANNOTATION_SUPPORT).append(" extension definition: '").append(intializerClassName).append("' is not a valid class name");
                    LOG.error((Object)msg.toString(), (Throwable)e);
                }
                catch (ClassCastException e) {
                    msg = new StringBuffer("Invalid ").append(EXT_POINT_SC_ANNOTATION_SUPPORT).append(" extension definition: the class '").append(intializerClassName).append("' is not a <IAnnotationInitializer> class");
                    LOG.debug((Object)msg.toString(), (Throwable)e);
                }
                if ((natureID = extElts[extIndex].getAttribute(EXT_ATT_SC_ANN_NATURE)) != null) {
                    ANN_NATURES.put(annotationClassName, natureID);
                }
                Boolean classOnly = new Boolean(extElts[extIndex].getAttribute(EXT_ATT_SC_ANN_CLASS_ONLY));
                ANN_CLASS_ONLY.put(annotationClassName, classOnly);
                Boolean interfaceOnly = new Boolean(extElts[extIndex].getAttribute(EXT_ATT_SC_ANN_INTERFACE_ONLY));
                ANN_INTERFACE_ONLY.put(annotationClassName, interfaceOnly);
            }
            ++extIndex;
        }
    }

    public static boolean verifyNature(String annClassName, String[] natures) {
        String definedNature = ANN_NATURES.get(annClassName);
        if (definedNature == null) {
            return true;
        }
        String[] stringArray = natures;
        int n = natures.length;
        int n2 = 0;
        while (n2 < n) {
            String nature = stringArray[n2];
            if (nature.equals(definedNature)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isClassOnly(String annotationName) {
        if (JAXWS_ANN_DECL == null || JAXWS_ANN_DECL.size() == 0) {
            AnnotationSupportProxy.loadAnnotationSupportExtensions();
        }
        return ANN_CLASS_ONLY.get(annotationName);
    }

    public static boolean isInterfaceOnly(String annotationName) {
        if (JAXWS_ANN_DECL == null || JAXWS_ANN_DECL.size() == 0) {
            AnnotationSupportProxy.loadAnnotationSupportExtensions();
        }
        return ANN_INTERFACE_ONLY.get(annotationName);
    }

    public static Map<String, Class<? extends Annotation>> getAllAvailableAnnotations() {
        if (JAXWS_ANN_DECL == null || JAXWS_ANN_DECL.size() == 0) {
            AnnotationSupportProxy.loadAnnotationSupportExtensions();
        }
        return JAXWS_ANN_DECL;
    }

    public static Class<? extends Annotation> getAvailableAnnotation(String annClassSimpleName) {
        return AnnotationSupportProxy.getAllAvailableAnnotations().get(annClassSimpleName);
    }

    public static Class<? extends Annotation> getAvailableAnnotation(Class annClass) {
        return AnnotationSupportProxy.getAllAvailableAnnotations().get(annClass.getSimpleName());
    }

    public static Map<Class<? extends Annotation>, IAnnotationInitializer> getAllAvailableInitializers() {
        if (JAXWS_ANN_INIT == null || JAXWS_ANN_INIT.size() == 0) {
            AnnotationSupportProxy.loadAnnotationSupportExtensions();
        }
        return JAXWS_ANN_INIT;
    }

    public static IAnnotationInitializer getAvailableAnnotationInitializer(String annClassSimpleName) {
        Class<? extends Annotation> annClass = AnnotationSupportProxy.getAllAvailableAnnotations().get(annClassSimpleName);
        return annClass == null ? null : AnnotationSupportProxy.getAllAvailableInitializers().get(annClass);
    }

    public static IAnnotationInitializer getAvailableAnnotationInitializer(Class annClass) {
        return AnnotationSupportProxy.getAllAvailableInitializers().get(annClass);
    }

    public static List<MemberValuePair> getDefaultAttributes(Class<? extends Annotation> annotationClass, CompilationUnit astRoot, IMember jdtMember, SingleVariableDeclaration jdtMemberParam) {
        IAnnotationInitializer init = AnnotationSupportProxy.getAvailableAnnotationInitializer(annotationClass);
        if (init != null) {
            return init.getDefaultAttributes(annotationClass, astRoot, jdtMember, jdtMemberParam);
        }
        return null;
    }
}

