/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.builders;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.stp.common.logging.LoggingProxy;

public abstract class ScJavaBuilder
extends IncrementalProjectBuilder {
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScJavaBuilder.class);

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        LOG.debug((Object)("fullBuild for project:" + this.getProject().getName()));
        this.getProject().accept((IResourceVisitor)new ScBuildVisitor());
        this.getProject().refreshLocal(2, monitor);
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        LOG.debug((Object)("incrementalBuild for project:" + this.getProject().getName()));
        delta.accept((IResourceDeltaVisitor)new ScBuildDeltaVisitor());
        this.getProject().refreshLocal(2, monitor);
    }

    protected abstract void clean(IProgressMonitor var1) throws CoreException;

    protected void startupOnInitialize() {
    }

    private void visitResourceFile(IResource res) throws CoreException {
        if (!(res instanceof IFile)) {
            return;
        }
        IFile file = (IFile)res;
        if (file == null || file.getFileExtension() == null) {
            return;
        }
        if (!file.getFileExtension().equals("java")) {
            return;
        }
        if (this.checkAnnotation(file)) {
            this.buildOneJavaFile(file);
        }
    }

    protected abstract void removeResourceFile(IResource var1) throws CoreException;

    protected abstract void buildOneJavaFile(IFile var1) throws CoreException;

    protected abstract boolean checkAnnotation(IFile var1);

    class ScBuildDeltaVisitor
    implements IResourceDeltaVisitor {
        ScBuildDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    ScJavaBuilder.this.visitResourceFile(res);
                    break;
                }
                case 2: {
                    LOG.debug((Object)("DeltaVistor, removed resource:" + res.getFullPath()));
                    try {
                        ScJavaBuilder.this.removeResourceFile(res);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"builder error", (Throwable)e);
                    }
                    break;
                }
            }
            return true;
        }
    }

    class ScBuildVisitor
    implements IResourceVisitor {
        ScBuildVisitor() {
        }

        public boolean visit(IResource res) throws CoreException {
            ScJavaBuilder.this.visitResourceFile(res);
            return true;
        }
    }
}

