/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.builders;

import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.tests.ScProjectBaseTest;
import org.eclipse.stp.sc.jaxws.workspace.JaxWsWorkspaceManager;

public class ScJavaBuilderTest
extends ScProjectBaseTest {
    public static final String PROJECT_NAME = "JavaBuilderTestProject";
    private static final LoggingProxy LOG = LoggingProxy.getlogger(ScJavaBuilderTest.class);
    protected String[] projectFiles = new String[]{"/src/demo/GreeterRPCLit.java", "/bin/demo/GreeterRPCLit.class"};
    protected String[] resourceFiles = new String[]{"/resources/GreeterRPCLit.java_resource", "/resources/GreeterRPCLit.class_resource2"};

    protected String getProjectName() {
        return PROJECT_NAME;
    }

    protected String[] getProjectFiles() {
        return this.projectFiles;
    }

    protected String[] getResourceFiles() {
        return this.resourceFiles;
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBuilder() throws Exception {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean foundWsdlBuilder = false;
        LOG.info((Object)("builder count:" + commands.length));
        int i = 0;
        while (i < commands.length) {
            LOG.info((Object)("builder name:" + commands[i].getBuilderName()));
            if (commands[i].getBuilderName().equals("org.eclipse.stp.sc.jaxws.builders.javatowsdlbuilder")) {
                foundWsdlBuilder = true;
            }
            ++i;
        }
        ScJavaBuilderTest.assertTrue((String)"Celtix project should have javatowsdl builder", (boolean)foundWsdlBuilder);
    }

    public void testClean() throws Exception {
        this.project.refreshLocal(0, null);
        this.project.build(15, null);
        IFile wsdl = this.project.getFile("/wsdl/demo/GreeterRPCLit.wsdl");
        ScJavaBuilderTest.assertFalse((String)"wsdl file should removed", (boolean)wsdl.exists());
    }

    public void testFullBuild() throws Exception {
        this.project.build(15, null);
        this.project.build(6, null);
        IFile wsdl = this.project.getFile("/wsdl/GreeterRPCLit.wsdl");
        ScJavaBuilderTest.assertTrue((String)"wsdl file should been built.", (boolean)wsdl.exists());
    }

    public void testIncrementalBuild() throws Exception {
        this.project.build(10, null);
        IFile wsdl = this.project.getFile("/wsdl/GreeterRPCLit.wsdl");
        ScJavaBuilderTest.assertTrue((String)"wsdl file should been built.", (boolean)wsdl.exists());
        String wsClass = wsdl.getPersistentProperty(JaxWsWorkspaceManager.INTERFACE_PROPERTY);
        ScJavaBuilderTest.assertEquals((String)wsClass, (String)"demo.GreeterRPCLit");
    }
}

