/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxwsri.generators;

import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sc.common.utils.WorkbenchUtils;
import org.eclipse.stp.sc.jaxwsri.test.utils.TestUtilities;

public class JAXWSRIJavaToWsdlGeneratorTest
extends TestCase {
    private IProject testProject = null;
    private static final String TEST_PROJECT_NAME = "test.jaxwsri";
    private static final String HELLO_SERVICE_FILE = "src/com/iona/Hello.java";
    private static final String HELLO_SERVICE_IMPL_FILE = "src/com/iona/HelloImpl.java";
    private static final String RESOURCE_HELLO_SERVICE_FILE = "/resources/Hello.java_resource";
    private static final String RESOURCE_HELLO_SERVICE_IMPL_FILE = "/resources/HelloImpl.java_resource";

    protected void setUp() throws Exception {
        this.testProject = TestUtilities.createTestJaxwsriProject(TEST_PROJECT_NAME);
        TestUtilities.setupJavaProject(this.testProject);
        TestUtilities.setupTestRuntimeInfo(this.testProject);
        TestUtilities.addFileResourceToTestProject(this.testProject, HELLO_SERVICE_FILE, ((Object)((Object)this)).getClass(), RESOURCE_HELLO_SERVICE_FILE);
        TestUtilities.addFileResourceToTestProject(this.testProject, HELLO_SERVICE_IMPL_FILE, ((Object)((Object)this)).getClass(), RESOURCE_HELLO_SERVICE_IMPL_FILE);
    }

    public void testJava2Wsdl() throws Exception {
        JAXWSRIJavaToWsdlGeneratorTest.assertTrue((String)"the project should exist", (boolean)this.testProject.exists());
        JAXWSRIJavaToWsdlGeneratorTest.assertTrue((String)"should have java2wsdl builder", (boolean)TestUtilities.hasBuilder(this.testProject, "org.eclipse.stp.sc.jaxws.builders.javatowsdlbuilder"));
        WorkbenchUtils.setWorkspaceAutoBuild((boolean)false);
        this.testProject.build(10, null);
        IFile wsdlFile = this.testProject.getFile("wsdl/HelloService.wsdl");
        JAXWSRIJavaToWsdlGeneratorTest.assertTrue((String)"should generate wsdl file", (wsdlFile != null && wsdlFile.exists() ? 1 : 0) != 0);
    }

    protected void tearDown() throws Exception {
        if (this.testProject.exists()) {
            this.testProject.delete(true, null);
        }
    }
}

