/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.xmlvalidator.rule.parser.model;

import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleAssert;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleDef;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleError;
import org.eclipse.stp.sc.xmlvalidator.rule.model.VRuleInstance;
import org.eclipse.stp.sc.xmlvalidator.rule.parser.RuleXmlParser;
import org.eclipse.stp.sc.xmlvalidator.utils.XMLUtils;
import org.w3c.dom.Document;

public class VRuleInstanceTest
extends TestCase {
    VRuleInstance testRule;
    Hashtable<String, VRuleDef> ruleSet;
    String test_rule_id_soap = "jaxws_rule_soapbind";
    String test_rule_id_sei = "jaxws_rule_sei_attribute";
    String test_rule_path = "/src/resources/JAX_WS_VRules.xml";
    String test_valid_xml_path = "/src/resources/JAXWS_Ann_HelloWorld.xml";
    String test_invalid_xml_path = "/src/resources/JAXWS_Ann_HelloWorld_Errors.xml";
    Document testDom;
    Document testWrongDom;

    protected void setUp() throws Exception {
        super.setUp();
        RuleXmlParser parser = new RuleXmlParser();
        this.ruleSet = new Hashtable();
        URL baseURL = Platform.getBundle((String)"org.eclipse.stp.sc.xmlvalidator.test").getEntry("/");
        URL fileURL = new URL(baseURL, this.test_rule_path);
        InputStream is = fileURL.openStream();
        parser.loadRuleFile(is, this.ruleSet);
        is.close();
        fileURL = new URL(baseURL, this.test_valid_xml_path);
        is = fileURL.openStream();
        this.testDom = XMLUtils.loadXmlDocument((InputStream)is);
        is.close();
        fileURL = new URL(baseURL, this.test_invalid_xml_path);
        is = fileURL.openStream();
        this.testWrongDom = XMLUtils.loadXmlDocument((InputStream)is);
        is.close();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private void createRuleInstance(String ruleID) {
        VRuleDef def = this.ruleSet.get(ruleID);
        this.testRule = new VRuleInstance(def);
    }

    public void testCreateRuleInstance() throws Exception {
        this.createRuleInstance(this.test_rule_id_soap);
        VRuleInstanceTest.assertTrue((String)"rule has one assert", (this.testRule.getRuleDef().getAssertList().size() == 1 ? 1 : 0) != 0);
        VRuleAssert ra = (VRuleAssert)this.testRule.getRuleDef().getAssertList().get(0);
        VRuleInstanceTest.assertNotNull((String)"rule assert is not null", (Object)ra);
        VRuleInstanceTest.assertNotNull((String)"should have compiled xpath expression.", (Object)ra.getXpathExp());
    }

    public void testValidDom() throws Exception {
        this.createRuleInstance(this.test_rule_id_soap);
        boolean ret = this.testRule.validate(this.testDom);
        VRuleInstanceTest.assertTrue((String)"the input is valid soap binding.", (boolean)ret);
    }

    public void testInValidDom() throws Exception {
        this.createRuleInstance(this.test_rule_id_soap);
        boolean ret = this.testRule.validate(this.testWrongDom);
        VRuleInstanceTest.assertFalse((String)"the input is invalid soap binding.", (boolean)ret);
        VRuleInstanceTest.assertFalse((String)"should have one error", (this.testRule.getErrors().size() == 0 ? 1 : 0) != 0);
        String errorMsg = ((VRuleAssert)this.testRule.getRuleDef().getAssertList().get(0)).getErrorMsg();
        System.out.println("error msg:" + errorMsg);
        VRuleInstanceTest.assertTrue((String)"the error message should be the expmsg defined in rule", (boolean)((VRuleError)this.testRule.getErrors().get(0)).getErrorMsg().equals(errorMsg));
    }

    public void testMultipleErrors() throws Exception {
        this.createRuleInstance(this.test_rule_id_sei);
        boolean ret = this.testRule.validate(this.testWrongDom);
        VRuleInstanceTest.assertFalse((String)"the input is invalid webservice ann.", (boolean)ret);
        VRuleInstanceTest.assertTrue((String)"should have three error", (this.testRule.getErrors().size() == 3 ? 1 : 0) != 0);
        for (VRuleError error : this.testRule.getErrors()) {
            System.out.println("error line number:" + error.getLineNumber());
            System.out.println("reported error msg:" + error.getErrorMsg());
        }
    }

    public void testLineNumber() throws Exception {
        this.createRuleInstance(this.test_rule_id_sei);
        this.testRule.validate(this.testWrongDom);
        VRuleInstanceTest.assertNotNull((Object)this.testRule.getErrors());
        VRuleError error = (VRuleError)this.testRule.getErrors().get(0);
        VRuleInstanceTest.assertEquals((int)error.getLineNumber(), (int)5);
    }
}

