/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.core.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.ILogicalPackage;
import org.eclipse.stp.soas.deploy.core.IPackageConstructorExtension;
import org.eclipse.stp.soas.deploy.core.ui.actions.CreatePackageFileAction;
import org.eclipse.stp.soas.deploy.core.ui.actions.PackageConstructorDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class CreatePackageFileActionDelegate
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate {
    protected IStructuredSelection _selection = null;
    private Shell _shell;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (targetPart != null) {
            this._shell = targetPart.getSite().getShell();
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(Event event) {
        this.run((IAction)null);
    }

    public void run(IAction action) {
        ILogicalPackage thePackage = null;
        if (this._selection == null) {
            return;
        }
        if (this._selection.getFirstElement() instanceof ILogicalPackage) {
            thePackage = (ILogicalPackage)this._selection.getFirstElement();
        } else if (this._selection.getFirstElement() instanceof IFile) {
            thePackage = DeploymentExtensionManager.getInstance().getLogicalPackage((IFile)this._selection.getFirstElement());
        } else {
            return;
        }
        ArrayList<IPackageConstructorExtension> constructors = new ArrayList<IPackageConstructorExtension>();
        List definedConstructors = DeploymentExtensionManager.getInstance().getPackageConstructors();
        for (IPackageConstructorExtension ipce : definedConstructors) {
            if (!ipce.supportsPackage(thePackage)) continue;
            constructors.add(ipce);
        }
        if (constructors.size() == 0) {
            MessageDialog.openInformation((Shell)this._shell, (String)DeployCorePlugin.getDefault().getResourceString("CreatePackageFileAction.NoConstructors.TITLE"), (String)DeployCorePlugin.getDefault().getResourceString("CreatePackageFileAction.NoConstructors.MESSAGE"));
            return;
        }
        IPackageConstructorExtension packageConstructor = null;
        if (constructors.size() == 1) {
            packageConstructor = (IPackageConstructorExtension)constructors.get(0);
        } else {
            PackageConstructorDialog dialog = new PackageConstructorDialog(this._shell, thePackage);
            if (dialog.open() == 0 && dialog.getSelectedPackageConstructor() != null) {
                packageConstructor = dialog.getSelectedPackageConstructor();
            }
        }
        if (packageConstructor != null) {
            new CreatePackageFileAction(new String(), thePackage, packageConstructor, null).run();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this._selection = (IStructuredSelection)selection;
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

