/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.clipboard;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardSupportUtil;
import org.eclipse.gmf.runtime.emf.clipboard.core.CopyOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.OverrideCopyOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.OverridePasteChildOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteAction;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteChildOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.PasteOption;
import org.eclipse.gmf.runtime.emf.core.clipboard.AbstractClipboardSupport;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Identifiable;
import org.eclipse.stp.bpmn.Lane;
import org.eclipse.stp.bpmn.MessageVertex;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.clipboard.BpmnConnectorViewPasteOperation;
import org.eclipse.stp.bpmn.clipboard.BpmnPositionalGeneralViewPasteOperation;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;

public class BpmnClipboardSupport
extends AbstractClipboardSupport {
    public void destroy(EObject eObject) {
        DestroyElementCommand.destroy((EObject)eObject);
    }

    public PasteAction getPasteCollisionAction(EClass eClass) {
        return PasteAction.ADD;
    }

    public boolean hasPasteOption(EObject contextEObject, EStructuralFeature eStructuralFeature, PasteOption pasteOption) {
        if (pasteOption.equals(PasteOption.NORMAL)) {
            return true;
        }
        if (pasteOption.equals(PasteOption.PARENT)) {
            return false;
        }
        if (pasteOption.equals(PasteOption.DISTANT)) {
            if (eStructuralFeature == null) {
                return false;
            }
            return NotationPackage.eINSTANCE.getView_Element().equals(eStructuralFeature);
        }
        return false;
    }

    public boolean isCopyAlways(EObject context, EReference eReference, Object value) {
        if (eReference.isTransient() || eReference.isDerived()) {
            return false;
        }
        if (eReference.equals(NotationPackage.eINSTANCE.getView_Element())) {
            return true;
        }
        if (context instanceof Identifiable) {
            return eReference.isContainment();
        }
        return eReference.isContainment();
    }

    public boolean shouldOverrideChildPasteOperation(EObject parentElement, EObject childEObject) {
        return childEObject.eClass().getEPackage() == NotationPackage.eINSTANCE;
    }

    public boolean shouldOverrideCopyOperation(Collection eObjects, Map hintMap) {
        return true;
    }

    private boolean shouldAllowPaste(PasteChildOperation overriddenChildPasteOperation) {
        EObject eObject = overriddenChildPasteOperation.getEObject();
        EObject parentEObject = overriddenChildPasteOperation.getParentEObject();
        if (eObject instanceof View && parentEObject instanceof Node) {
            Node parentNode = (Node)parentEObject;
            EObject semanticChildElement = ((View)eObject).getElement();
            if (semanticChildElement instanceof Pool) {
                return false;
            }
            if (semanticChildElement instanceof Activity && ((Activity)semanticChildElement).getEventHandlerFor() != null && parentNode.getElement() instanceof SubProcess) {
                return false;
            }
            if (eObject instanceof MessagingEdge) {
                return false;
            }
            if (eObject instanceof SequenceEdge) {
                if (!overriddenChildPasteOperation.getAllPastedElementSet().contains(((SequenceEdge)eObject).getSource())) {
                    return false;
                }
                if (!overriddenChildPasteOperation.getAllPastedElementSet().contains(((SequenceEdge)eObject).getTarget())) {
                    return false;
                }
            }
            EObject semanticParent = parentNode.getElement();
            if (semanticChildElement instanceof Lane && !(semanticParent instanceof Pool)) {
                return false;
            }
            return semanticParent instanceof Pool || semanticParent instanceof SubProcess;
        }
        if (parentEObject instanceof Diagram && eObject instanceof View) {
            EObject semanticChildElement = ((View)eObject).getElement();
            if (semanticChildElement == null) {
                return true;
            }
            if (semanticChildElement.eIsProxy() && (semanticChildElement = ClipboardSupportUtil.resolve((EObject)semanticChildElement, (Map)overriddenChildPasteOperation.getParentPasteProcess().getLoadedIDToEObjectMapCopy())).eIsProxy()) {
                semanticChildElement = EcoreUtil.resolve((EObject)semanticChildElement, (Resource)this.getResource(parentEObject));
            }
            if (!(semanticChildElement instanceof Pool)) {
                return false;
            }
            EPackage semanticChildEpackage = semanticChildElement.eClass().getEPackage();
            EPackage diagramRootContainerEpackage = EcoreUtil.getRootContainer((EObject)parentEObject).eClass().getEPackage();
            EPackage sematicDiagramRootContainerEpackage = null;
            EObject sematicDiagramElement = ((View)parentEObject).getElement();
            if (sematicDiagramElement != null) {
                sematicDiagramRootContainerEpackage = EcoreUtil.getRootContainer((EObject)sematicDiagramElement).eClass().getEPackage();
            }
            if (diagramRootContainerEpackage != NotationPackage.eINSTANCE && semanticChildEpackage != diagramRootContainerEpackage) {
                return false;
            }
            return sematicDiagramRootContainerEpackage == null || sematicDiagramRootContainerEpackage == NotationPackage.eINSTANCE || semanticChildEpackage == sematicDiagramRootContainerEpackage;
        }
        return false;
    }

    public OverridePasteChildOperation getOverrideChildPasteOperation(PasteChildOperation overriddenChildPasteOperation) {
        if (this.shouldAllowPaste(overriddenChildPasteOperation)) {
            EObject eObject = overriddenChildPasteOperation.getEObject();
            if (eObject instanceof Node) {
                Node node = (Node)eObject;
                EObject element = node.getElement();
                if (element != null) {
                    return new BpmnPositionalGeneralViewPasteOperation(overriddenChildPasteOperation, true);
                }
                return new BpmnPositionalGeneralViewPasteOperation(overriddenChildPasteOperation, false);
            }
            if (eObject instanceof Edge) {
                return new BpmnConnectorViewPasteOperation(overriddenChildPasteOperation);
            }
        }
        return null;
    }

    public OverrideCopyOperation getOverrideCopyOperation(CopyOperation overriddenCopyOperation) {
        if (overriddenCopyOperation instanceof BpmnOverrideCopyOperation) {
            return (OverrideCopyOperation)overriddenCopyOperation;
        }
        return new BpmnOverrideCopyOperation(overriddenCopyOperation);
    }

    public Collection getExcludedCopyObjects(Set eObjects) {
        HashSet toRemove = new HashSet();
        for (Object elt : eObjects) {
            Object e = elt;
            if (e instanceof View) {
                e = ((View)e).getElement();
            }
            if (e instanceof MessagingEdge) {
                toRemove.add(elt);
            }
            if (e instanceof SequenceEdge) {
                if (!eObjects.contains(((SequenceEdge)e).getSource())) {
                    toRemove.add(elt);
                }
                if (!eObjects.contains(((SequenceEdge)e).getTarget())) {
                    toRemove.add(elt);
                }
            }
            if (e instanceof Association) {
                if (!eObjects.contains(((Association)e).getSource())) {
                    toRemove.add(elt);
                }
                if (!eObjects.contains(((Association)e).getTarget())) {
                    toRemove.add(elt);
                }
            }
            if (e instanceof Artifact) {
                for (Association association : ((Artifact)e).getAssociations()) {
                    if (!(association instanceof Association)) continue;
                    if (!eObjects.contains(association.getSource())) {
                        toRemove.add(association);
                    }
                    if (eObjects.contains(association.getTarget())) continue;
                    toRemove.add(association);
                }
            }
            if (!(e instanceof Activity) || ((Activity)e).getEventHandlerFor() == null) continue;
            toRemove.add(elt);
            toRemove.add(e);
            toRemove.addAll(((Activity)e).getOrderedMessages());
            toRemove.addAll(((Activity)e).getOutgoingEdges());
            toRemove.addAll(((Activity)e).getIncomingEdges());
        }
        return toRemove;
    }

    public XMLResource getResource(EObject eObject) {
        EObject element;
        XMLResource eResource = (XMLResource)eObject.eResource();
        if (eResource == null && eObject instanceof View && (element = ((View)eObject).getElement()) != null) {
            return (XMLResource)element.eResource();
        }
        return eResource;
    }

    public boolean shouldSaveContainmentFeature(EObject eObj) {
        if (EcorePackage.eINSTANCE.getEClassifiers().contains((Object)eObj.eClass())) {
            return false;
        }
        try {
            eObj.eResource().getURIFragment(eObj);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void performPostPasteProcessing(Set pastedEObjects) {
        if (pastedEObjects.isEmpty()) {
            return;
        }
        CompoundCommand command = new CompoundCommand(BpmnDiagramMessages.BpmnClipboardSupport_PostPaste);
        TransactionalEditingDomain domain = (TransactionalEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor(pastedEObjects.iterator().next());
        for (Object o : pastedEObjects) {
            EObject elt = null;
            if (o instanceof View) {
                elt = ((View)o).getElement();
            } else if (o instanceof EObject) {
                elt = (EObject)o;
            }
            if (elt instanceof Vertex) {
                boolean disconnect;
                boolean delete;
                SequenceEdge se;
                final Vertex vertex = (Vertex)elt;
                for (Object edge : vertex.getOutgoingEdges()) {
                    se = (SequenceEdge)edge;
                    delete = false;
                    disconnect = false;
                    if (!vertex.equals(se.getSource())) {
                        disconnect = true;
                    }
                    if (se.getTarget() == null) {
                        delete = true;
                    }
                    if (delete) {
                        command.append(DeleteCommand.create((EditingDomain)domain, (Object)se));
                        continue;
                    }
                    if (!disconnect) continue;
                    command.append((Command)new RecordingCommand(domain, BpmnDiagramMessages.BpmnClipboardSupport_SequenceEdgeDisconnect){

                        protected void doExecute() {
                            Vertex source = se.getSource();
                            ArrayList vertices = new ArrayList(vertex.getOutgoingEdges());
                            vertices.remove(se);
                            vertex.eSet((EStructuralFeature)BpmnPackage.eINSTANCE.getVertex_OutgoingEdges(), vertices);
                            if (!source.getOutgoingEdges().contains((Object)se)) {
                                se.eSet((EStructuralFeature)BpmnPackage.eINSTANCE.getSequenceEdge_Source(), (Object)source);
                            }
                        }
                    });
                }
                command.execute();
                command = new CompoundCommand(BpmnDiagramMessages.BpmnClipboardSupport_PostPaste);
                for (Object edge : vertex.getIncomingEdges()) {
                    se = (SequenceEdge)edge;
                    delete = false;
                    disconnect = false;
                    if (!vertex.equals(se.getTarget())) {
                        disconnect = true;
                    }
                    if (se.getSource() == null) {
                        delete = true;
                    }
                    if (delete) {
                        command.append(DeleteCommand.create((EditingDomain)domain, (Object)se));
                        continue;
                    }
                    if (!disconnect) continue;
                    command.append((Command)new RecordingCommand(domain, BpmnDiagramMessages.BpmnClipboardSupport_SequenceEdgeDisconnect){

                        protected void doExecute() {
                            Vertex target = se.getTarget();
                            ArrayList vertices = new ArrayList(vertex.getIncomingEdges());
                            vertices.remove(se);
                            vertex.eSet((EStructuralFeature)BpmnPackage.eINSTANCE.getVertex_IncomingEdges(), vertices);
                            if (!target.getIncomingEdges().contains((Object)se)) {
                                se.eSet((EStructuralFeature)BpmnPackage.eINSTANCE.getSequenceEdge_Target(), (Object)target);
                            }
                        }
                    });
                }
                command.execute();
                command = new CompoundCommand(BpmnDiagramMessages.BpmnClipboardSupport_unresolvedAssociations);
                for (Association association : vertex.getAssociations()) {
                    boolean delete2 = false;
                    if (association.getSource() == null) {
                        delete2 = true;
                    }
                    if (!delete2) continue;
                    command.append(DeleteCommand.create((EditingDomain)domain, (Object)association));
                }
                command.execute();
                command = new CompoundCommand(BpmnDiagramMessages.BpmnClipboardSupport_PostPaste);
            }
            this.processMessagingEdges(domain, elt);
        }
    }

    private void processMessagingEdges(TransactionalEditingDomain domain, EObject elt) {
        CompoundCommand command = new CompoundCommand(BpmnDiagramMessages.BpmnClipboardSupport_PostPaste);
        if (elt instanceof Activity) {
            MessagingEdge me;
            final Activity act = (Activity)elt;
            for (Object edge : act.getOutgoingMessages()) {
                if (!(edge instanceof MessagingEdge)) continue;
                me = (MessagingEdge)edge;
                if (me.getTarget() == null) {
                    command.append(DeleteCommand.create((EditingDomain)domain, (Object)me));
                    continue;
                }
                if (act.equals(me.getSource())) continue;
                command.append((Command)new RecordingCommand(domain, BpmnDiagramMessages.BpmnClipboardSupport_MessagingEdgeDisconnect){

                    protected void doExecute() {
                        MessageVertex source = me.getSource();
                        ArrayList messages = new ArrayList(act.getOutgoingMessages());
                        messages.remove(me);
                        act.eSet((EStructuralFeature)BpmnPackage.eINSTANCE.getMessageVertex_OutgoingMessages(), messages);
                        if (!source.getOutgoingMessages().contains((Object)me)) {
                            me.eSet((EStructuralFeature)BpmnPackage.eINSTANCE.getMessagingEdge_Source(), (Object)source);
                        }
                    }
                });
            }
            command.execute();
            command = new CompoundCommand(BpmnDiagramMessages.BpmnClipboardSupport_PostPaste);
            for (Object edge : act.getIncomingMessages()) {
                if (!(edge instanceof MessagingEdge)) continue;
                me = (MessagingEdge)edge;
                if (me.getSource() == null) {
                    command.append(DeleteCommand.create((EditingDomain)domain, (Object)me));
                    continue;
                }
                if (act.equals(me.getTarget())) continue;
                command.append((Command)new RecordingCommand(domain, BpmnDiagramMessages.BpmnClipboardSupport_MessagingEdgeDisconnect){

                    protected void doExecute() {
                        MessageVertex target = me.getTarget();
                        ArrayList messages = new ArrayList(act.getIncomingMessages());
                        messages.remove(me);
                        act.eSet((EStructuralFeature)BpmnPackage.eINSTANCE.getMessageVertex_IncomingMessages(), messages);
                        if (!target.getIncomingMessages().contains((Object)target)) {
                            me.eSet((EStructuralFeature)BpmnPackage.eINSTANCE.getMessagingEdge_Target(), (Object)target);
                        }
                    }
                });
            }
            command.execute();
            command = new CompoundCommand(BpmnDiagramMessages.BpmnClipboardSupport_PostPaste);
        }
        if (elt instanceof Graph) {
            for (Object vertex : ((Graph)elt).getVertices()) {
                this.processMessagingEdges(domain, (EObject)vertex);
            }
        }
    }

    public String getName(EObject eObject) {
        return EMFCoreUtil.getProxyID((EObject)eObject);
    }

    public void setName(EObject eObject, String name) {
    }

    static Diagram getContainingDiagram(View view) {
        View current = view;
        while (current != null) {
            if (current instanceof Diagram) {
                return (Diagram)current;
            }
            current = current.eContainer();
        }
        return null;
    }

    static EObject getSemanticPasteTarget(View view) {
        View parent = (View)view.eContainer();
        return parent.getElement();
    }

    private class BpmnOverrideCopyOperation
    extends OverrideCopyOperation {
        public BpmnOverrideCopyOperation(CopyOperation overriddenCopyOperation) {
            super(overriddenCopyOperation);
            HashSet<View> edges = new HashSet<View>();
            for (Object obj : this.getEObjects()) {
                if (!(obj instanceof Node)) continue;
                for (Object e : ((Node)obj).getSourceEdges()) {
                    if (!this.isValidEdge((Edge)e)) continue;
                    edges.add((View)e);
                }
                for (Object e : ((Node)obj).getTargetEdges()) {
                    if (!this.isValidEdge((Edge)e)) continue;
                    edges.add((View)e);
                }
                TreeIterator iterator = ((Node)obj).eAllContents();
                while (iterator.hasNext()) {
                    EObject next = (EObject)iterator.next();
                    if (!(next instanceof Node)) continue;
                    for (Object e : ((Node)next).getSourceEdges()) {
                        if (!this.isValidEdge((Edge)e)) continue;
                        edges.add((View)e);
                    }
                    for (Object e : ((Node)next).getTargetEdges()) {
                        if (!this.isValidEdge((Edge)e)) continue;
                        edges.add((View)e);
                    }
                }
            }
            edges.addAll(this.getEObjects());
            this.getEObjects().clear();
            this.getEObjects().addAll(edges);
        }

        public String copy() throws Exception {
            return super.doCopy();
        }

        private boolean isValidEdge(Edge edge) {
            return !String.valueOf(3002).equals(edge.getType());
        }
    }
}

