/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.LineSeg;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.BpmnPackage;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SequenceFlowConditionType;
import org.eclipse.stp.bpmn.Vertex;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.policies.SequenceEdgeItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.figures.BpmnShapesDefaultSizes;
import org.eclipse.stp.bpmn.figures.ConnectionLayerExEx;
import org.eclipse.stp.bpmn.figures.ConnectionUtils;
import org.eclipse.stp.bpmn.figures.SequenceEdgePolylineTargetDecoration;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;
import org.eclipse.stp.bpmn.figures.router.EdgeRectilinearRouter;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.ConnectionEndPointEditPolicyEx;
import org.eclipse.stp.bpmn.policies.OpenFileEditPolicy;

public class SequenceEdgeEditPart
extends ConnectionNodeEditPart {
    public static final int VISUAL_ID = 3001;
    private ConnectionRouter rectilinearRouter = null;

    public SequenceEdgeEditPart(View view) {
        super(view);
    }

    protected void refreshVisuals() {
        this.refreshSourceAnchor();
        this.refreshTargetAnchor();
        super.refreshVisuals();
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new SequenceEdgeItemSemanticEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
        this.installEditPolicy("OpenPolicy", (EditPolicy)new OpenFileEditPolicy());
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndPointEditPolicyEx());
    }

    protected Connection createConnectionFigure() {
        return new EdgeFigure();
    }

    protected void installRouter() {
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        RoutingStyle style = (RoutingStyle)((View)this.getModel()).getStyle(NotationPackage.Literals.ROUTING_STYLE);
        if (style != null && cLayer instanceof ConnectionLayerExEx) {
            ConnectionLayerExEx cLayerEx = (ConnectionLayerExEx)cLayer;
            if (Routing.RECTILINEAR_LITERAL == style.getRouting()) {
                if (this.rectilinearRouter == null) {
                    Vertex source = null;
                    if (this.resolveSemanticElement() instanceof SequenceEdge) {
                        SequenceEdge edge = (SequenceEdge)this.resolveSemanticElement();
                        source = edge.getSource();
                    }
                    this.rectilinearRouter = source instanceof Activity && ((Activity)source).getEventHandlerFor() != null ? cLayerEx.getBpmnSequenceEdgeForBorderedShapesRectilinearRouter() : new EdgeRectilinearRouter(this);
                }
                this.getConnectionFigure().setConnectionRouter(this.rectilinearRouter);
                ((EdgeFigure)this.getFigure()).routerIsRectilinear = true;
                this.refreshRouterChange();
                return;
            }
        }
        ((EdgeFigure)this.getFigure()).routerIsRectilinear = false;
        super.installRouter();
    }

    private boolean shouldShowConditionalDecoration() {
        EObject object = this.resolveSemanticElement();
        if (object instanceof SequenceEdge) {
            ActivityType type;
            if (((SequenceEdge)object).isIsDefault()) {
                return false;
            }
            Vertex src = ((SequenceEdge)object).getSource();
            if (src != null && src instanceof Activity && ActivityType.VALUES_GATEWAYS.contains(type = ((Activity)src).getActivityType())) {
                return false;
            }
            if (((SequenceEdge)object).getConditionType() != SequenceFlowConditionType.NONE_LITERAL) {
                return true;
            }
        }
        return false;
    }

    protected RotatableDecoration createSourceDecoration() {
        return null;
    }

    protected void handleNotificationEvent(Notification notification) {
        if (notification.getEventType() == 1 && BpmnPackage.eINSTANCE.getSequenceEdge_IsDefault().equals(notification.getFeature())) {
            ((EdgeFigure)this.getFigure()).isDefault = notification.getNewBooleanValue();
            this.getFigure().repaint();
        }
        super.handleNotificationEvent(notification);
    }

    protected ConnectionAnchor getSourceConnectionAnchor() {
        ConnectionAnchor ca = super.getSourceConnectionAnchor();
        this.updateConnectionAnchor(ca, true);
        return ca;
    }

    protected ConnectionAnchor getTargetConnectionAnchor() {
        ConnectionAnchor ca = super.getTargetConnectionAnchor();
        this.updateConnectionAnchor(ca, false);
        return ca;
    }

    private void updateConnectionAnchor(ConnectionAnchor ca, boolean isSource) {
        if (ca instanceof IModelAwareAnchor) {
            EList seqs;
            IModelAwareAnchor modelAware = (IModelAwareAnchor)ca;
            if (super.getSource() == null) {
                return;
            }
            EList eList = seqs = isSource ? ((Activity)((GraphicalEditPart)super.getSource()).getPrimaryView().getElement()).getOutgoingEdges() : ((Activity)((GraphicalEditPart)super.getTarget()).getPrimaryView().getElement()).getIncomingEdges();
            if (!(this.getPrimaryView().getElement() instanceof SequenceEdge)) {
                String connectionType = isSource && super.getSource() instanceof Activity2EditPart ? String.valueOf(String.valueOf(3001)) + "-subprocessBorder" : String.valueOf(3001);
                modelAware.setConnectionType(isSource, connectionType, 0, 1);
            } else {
                SequenceEdge seqEdge = (SequenceEdge)this.getPrimaryView().getElement();
                int ind = seqs.indexOf((Object)seqEdge);
                if (!this.isOrderImportant(isSource)) {
                    ind = isSource ? ActivityEditPart.getStartAnchorVisualIndex((Edge)this.getModel()) : ActivityEditPart.getTargetAnchorVisualIndex((Edge)this.getModel());
                }
                int count = seqs.size();
                String connectionType = isSource && super.getSource() instanceof Activity2EditPart ? String.valueOf(String.valueOf(3001)) + "-subprocessBorder" : String.valueOf(3001);
                modelAware.setConnectionType(isSource, connectionType, ind, count);
            }
        }
    }

    private int calculateBestPosition(SequenceEdge seqEdge, boolean isSource) {
        List connections = isSource ? ((IGraphicalEditPart)super.getSource()).getSourceConnections() : ((IGraphicalEditPart)super.getTarget()).getTargetConnections();
        ArrayList<IGraphicalEditPart> seqs = new ArrayList<IGraphicalEditPart>();
        IGraphicalEditPart index = null;
        for (Object con : connections) {
            IGraphicalEditPart part;
            if (!(con instanceof SequenceEdgeEditPart) || (part = (IGraphicalEditPart)(isSource ? ((SequenceEdgeEditPart)((Object)con)).getTarget() : ((SequenceEdgeEditPart)((Object)con)).getSource())) == null) continue;
            seqs.add(part);
            if (con != this) continue;
            index = part;
        }
        Collections.sort(seqs, new Comparator<IGraphicalEditPart>(){

            @Override
            public int compare(IGraphicalEditPart o1, IGraphicalEditPart o2) {
                int y2;
                int y1 = ((Location)((Node)o1.getModel()).getLayoutConstraint()).getY();
                if (y1 < (y2 = ((Location)((Node)o2.getModel()).getLayoutConstraint()).getY())) {
                    return -1;
                }
                if (y1 == y2) {
                    return 0;
                }
                return 1;
            }
        });
        return seqs.indexOf(index);
    }

    public boolean isConditional() {
        ActivityType type;
        Vertex src;
        EObject object = this.getNotationView().getElement();
        return object instanceof SequenceEdge && (src = ((SequenceEdge)object).getSource()) != null && src instanceof Activity && ((type = ((Activity)src).getActivityType()).getValue() == 27 || type.getValue() == 25);
    }

    public int getTargetGatewayConstraint() {
        IGraphicalEditPart target = (IGraphicalEditPart)this.getTarget();
        if (target == null || target.resolveSemanticElement() == null || this.getSource() == null) {
            return 0;
        }
        ArrayList<SequenceEdgeEditPart> targets = new ArrayList<SequenceEdgeEditPart>();
        int index = ((Activity)target.resolveSemanticElement()).getIncomingEdges().indexOf((Object)this.resolveSemanticElement());
        if (!this.isOrderImportant(true)) {
            index = ActivityEditPart.getTargetAnchorVisualIndex((Edge)this.getModel());
        }
        int tgtsize = 0;
        for (Object o : target.getTargetConnections()) {
            if (!(o instanceof SequenceEdgeEditPart)) continue;
            ++tgtsize;
            targets.add((SequenceEdgeEditPart)((Object)o));
        }
        int srcsize = 0;
        for (Object o : target.getSourceConnections()) {
            if (!(o instanceof SequenceEdgeEditPart)) continue;
            ++srcsize;
        }
        boolean constraint = SequenceEdgeEditPart.shouldShowTopDownEdges((Activity)target.resolveSemanticElement());
        boolean bl = constraint = constraint && tgtsize > 1 && srcsize <= 1;
        if (!constraint) {
            return 0;
        }
        if (tgtsize == 2) {
            Bounds targetLoc = BpmnShapesDefaultSizes.getBounds((Node)((Edge)this.getModel()).getTarget());
            Bounds sourceLoc = BpmnShapesDefaultSizes.getBounds((Node)((Edge)this.getModel()).getSource());
            Bounds otherSourceLoc = null;
            for (SequenceEdgeEditPart p : targets) {
                if (p == this) continue;
                otherSourceLoc = BpmnShapesDefaultSizes.getBounds((Node)((Edge)p.getModel()).getSource());
                break;
            }
            int topLimit = targetLoc.getY() + targetLoc.getHeight() + 20;
            int bottomLimit = targetLoc.getY() - 20;
            int sourceMidY = sourceLoc.getY() + sourceLoc.getHeight() / 2;
            int otherSourceMidY = otherSourceLoc.getY() + otherSourceLoc.getHeight() / 2;
            int midY = targetLoc.getY() + targetLoc.getHeight() / 2;
            return this.getGatewayConstraintFor2Connections(bottomLimit, topLimit, midY, sourceMidY, otherSourceMidY, index);
        }
        if (index == 0) {
            return 1;
        }
        if (index == tgtsize - 1) {
            return 2;
        }
        return 0;
    }

    public int getSourceGatewayConstraint() {
        IGraphicalEditPart source = (IGraphicalEditPart)this.getSource();
        if (source == null || source.resolveSemanticElement() == null) {
            return 0;
        }
        int srcsize = 0;
        int index = ((Activity)source.resolveSemanticElement()).getOutgoingEdges().indexOf((Object)this.resolveSemanticElement());
        if (!this.isOrderImportant(true)) {
            index = ActivityEditPart.getStartAnchorVisualIndex((Edge)this.getModel());
        }
        ArrayList<SequenceEdgeEditPart> sources = new ArrayList<SequenceEdgeEditPart>();
        for (Object o : source.getSourceConnections()) {
            if (!(o instanceof SequenceEdgeEditPart)) continue;
            ++srcsize;
            sources.add((SequenceEdgeEditPart)((Object)o));
        }
        int tgtsize = 0;
        for (Object o : source.getTargetConnections()) {
            if (!(o instanceof SequenceEdgeEditPart)) continue;
            ++tgtsize;
        }
        boolean constraint = SequenceEdgeEditPart.shouldShowTopDownEdges((Activity)source.resolveSemanticElement());
        boolean bl = constraint = constraint && srcsize > 1 && tgtsize <= 1;
        if (!constraint) {
            return 0;
        }
        if (srcsize == 2) {
            Bounds targetLoc = BpmnShapesDefaultSizes.getBounds((Node)((Edge)this.getModel()).getTarget());
            Bounds sourceLoc = BpmnShapesDefaultSizes.getBounds((Node)((Edge)this.getModel()).getSource());
            Bounds otherTargetLoc = null;
            for (SequenceEdgeEditPart p : sources) {
                if (p == this) continue;
                otherTargetLoc = BpmnShapesDefaultSizes.getBounds((Node)((Edge)p.getModel()).getTarget());
            }
            int topLimit = sourceLoc.getY() + sourceLoc.getHeight() + 20;
            int bottomLimit = sourceLoc.getY() - 20;
            int midY = sourceLoc.getY() + sourceLoc.getHeight() / 2;
            int targetMidY = targetLoc.getY() + targetLoc.getHeight() / 2;
            int otherTargetMidY = otherTargetLoc.getY() + otherTargetLoc.getHeight() / 2;
            return this.getGatewayConstraintFor2Connections(bottomLimit, topLimit, midY, targetMidY, otherTargetMidY, index);
        }
        if (index == 0) {
            return 1;
        }
        if (index == srcsize - 1) {
            return 2;
        }
        return 0;
    }

    private boolean isOrderImportant(boolean isSource) {
        EditPart part = isSource ? this.getSource() : this.getTarget();
        return ActivityEditPart.isOrderImportant((IGraphicalEditPart)part, isSource);
    }

    private int getGatewayConstraintFor2Connections(int topScreenLimit, int bottomScreenLimit, int gatewayMidY, int thisMidY, int otherMidY, int currentBestIndex) {
        if (currentBestIndex == 0) {
            if (thisMidY < topScreenLimit) {
                return 1;
            }
            if (thisMidY < bottomScreenLimit) {
                if (Math.abs(thisMidY - gatewayMidY) < Math.abs(otherMidY - gatewayMidY)) {
                    return 3;
                }
                return 1;
            }
            return 3;
        }
        if (thisMidY >= bottomScreenLimit) {
            return 2;
        }
        int otherOneresult = this.getGatewayConstraintFor2Connections(topScreenLimit, bottomScreenLimit, gatewayMidY, otherMidY, thisMidY, 0);
        if (otherOneresult == 3) {
            return 2;
        }
        return 3;
    }

    private static boolean shouldShowTopDownEdges(Activity activity) {
        boolean constraint = ActivityType.VALUES_GATEWAYS.contains(activity.getActivityType());
        if (constraint) {
            return true;
        }
        constraint = ActivityType.VALUES_EVENTS.contains(activity.getActivityType()) && activity.getOrderedMessages().isEmpty();
        return constraint;
    }

    public class EdgeFigure
    extends PolylineConnectionEx {
        private boolean isDefault;
        private PointList smoothPoints;
        private boolean routerIsRectilinear = false;

        public EdgeFigure() {
            this.setForegroundColor(ColorConstants.black);
            this.setTargetDecoration((RotatableDecoration)this.createTargetDecoration());
            RotatableDecoration srcDecoration = SequenceEdgeEditPart.this.createSourceDecoration();
            if (srcDecoration != null) {
                this.setSourceDecoration(srcDecoration);
            }
            this.isDefault = SequenceEdgeEditPart.this.getEdge().getElement() instanceof SequenceEdge ? ((SequenceEdge)SequenceEdgeEditPart.this.getEdge().getElement()).isIsDefault() : false;
        }

        private SequenceEdgePolylineTargetDecoration createTargetDecoration() {
            SequenceEdgePolylineTargetDecoration df = new SequenceEdgePolylineTargetDecoration();
            return df;
        }

        public PointList getSmoothPoints() {
            this.smoothPoints = !this.routerIsRectilinear ? super.getSmoothPoints() : ConnectionUtils.getRoundedRectilinearSmoothPoints(true, this.getPoints(), super.getSmoothness());
            return this.smoothPoints;
        }

        public void paintFigure(Graphics graphics) {
            graphics.setAlpha(ActivityPainter.getSequenceEdgeTransparency());
            super.paintFigure(graphics);
        }

        protected void outlineShape(Graphics g) {
            if (SequenceEdgeEditPart.this.getSource() instanceof Activity2EditPart && ((Activity)((Activity2EditPart)SequenceEdgeEditPart.this.getSource()).resolveSemanticElement()).getActivityType().getValue() == 12) {
                g.setLineStyle(6);
                g.setLineDash(new int[]{1, 2});
            }
            super.outlineShape(g);
            int alpha = BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getInt("bpmn.global.shadows.transparency");
            if ((alpha -= 255 - ActivityPainter.getSequenceEdgeTransparency()) > 0) {
                g.pushState();
                g.setAlpha(alpha);
                PointList pl = this.smoothPoints.getCopy();
                pl.translate(4, 6);
                pl.setPoint(pl.getFirstPoint().translate(-2, 0), 0);
                pl.setPoint(pl.getLastPoint().translate(-8, 0), pl.size() - 1);
                g.drawPolyline(pl);
                PointList head = new PointList();
                head.addPoint(pl.getLastPoint().getCopy().translate(4, -2));
                head.addPoint(pl.getLastPoint().getCopy().translate(4, 2));
                head.addPoint(pl.getLastPoint().getCopy().translate(0, 3));
                head.addPoint(pl.getLastPoint().getCopy().translate(0, -3));
                g.setBackgroundColor(ColorConstants.black);
                g.fillPolygon(head);
                g.popState();
            }
            if (this.isDefault && SequenceEdgeEditPart.this.isConditional()) {
                Point res = new Point();
                PointList points = this.smoothPoints;
                int DISTANCE = MapModeUtil.getMapMode((IFigure)this).LPtoDP(40);
                long length = PointListUtilities.getPointsLength((PointList)points);
                long distance = length < (long)(DISTANCE * 2) ? length / 2L : (long)DISTANCE;
                res = PointListUtilities.pointOn((PointList)points, (long)distance, (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (Point)res);
                LineSeg segment = PointListUtilities.getNearestSegment((List)PointListUtilities.getLineSegments((PointList)points), (int)res.x, (int)res.y);
                double[] equation = segment.getEquation();
                double a = equation[0];
                double b = equation[1];
                double k = -a / b;
                double angleRad = Math.atan(k);
                double angleDeg = Math.toDegrees(angleRad);
                double angle1 = Math.toRadians(110.0 - angleDeg);
                double angle2 = angle1 + Math.PI;
                double x1 = (double)res.x + 7.0 * Math.cos(angle1);
                double y1 = (double)res.y - 7.0 * Math.sin(angle1);
                double x2 = (double)res.x + 7.0 * Math.cos(angle2);
                double y2 = (double)res.y - 7.0 * Math.sin(angle2);
                PrecisionPoint p1 = new PrecisionPoint(x1, y1);
                PrecisionPoint p2 = new PrecisionPoint(x2, y2);
                g.drawLine((Point)p1, (Point)p2);
            }
            if (SequenceEdgeEditPart.this.shouldShowConditionalDecoration()) {
                Point p1 = new Point();
                Point p3 = new Point();
                PointList points = this.smoothPoints;
                p1 = PointListUtilities.pointOn((PointList)points, (long)0L, (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (Point)p1);
                p3 = PointListUtilities.pointOn((PointList)points, (long)SequenceEdgeEditPart.this.getMapMode().LPtoDP(16), (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (Point)p3);
                PointList list = new PointList();
                list.addPoint(p1);
                Point kitePoint = new Point();
                kitePoint = PointListUtilities.pointOn((PointList)points, (long)SequenceEdgeEditPart.this.getMapMode().LPtoDP(8), (LineSeg.KeyPoint)LineSeg.KeyPoint.ORIGIN, (Point)kitePoint);
                boolean onY = Math.abs(p1.y - p3.y) < SequenceEdgeEditPart.this.getMapMode().LPtoDP(3);
                int translate = SequenceEdgeEditPart.this.getMapMode().LPtoDP(4);
                Point p2 = kitePoint.getCopy().translate(onY ? 0 : translate, onY ? translate : 0);
                Point p4 = kitePoint.getCopy().translate(onY ? 0 : -translate, onY ? -translate : 0);
                list.addPoint(p2);
                list.addPoint(p3);
                list.addPoint(p4);
                g.setForegroundColor(ColorConstants.white);
                g.fillPolygon(list);
                g.setForegroundColor(ColorConstants.black);
                g.drawPolygon(list);
            }
        }

        public int getTargetGatewayConstraint() {
            return SequenceEdgeEditPart.this.getTargetGatewayConstraint();
        }

        public int getSourceGatewayConstraint() {
            return SequenceEdgeEditPart.this.getSourceGatewayConstraint();
        }
    }
}

