/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.generation.impl;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.Association;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.DataObject;
import org.eclipse.stp.bpmn.Graph;
import org.eclipse.stp.bpmn.Group;
import org.eclipse.stp.bpmn.Lane;
import org.eclipse.stp.bpmn.MessagingEdge;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.SequenceEdge;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.TextAnnotation;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.generation.impl.BPMNProcessGenerator;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BPMNVisual2ProcessGenerator
extends BPMNProcessGenerator {
    private Map<EObject, Rectangle> positions = new HashMap<EObject, Rectangle>();
    private Map<EObject, View> semantic2notationMap = new LinkedHashMap<EObject, View>();
    private List<SequenceEdge> collectedSequenceEdges = new LinkedList<SequenceEdge>();
    private List<MessagingEdge> collectedMessagingEdges = new LinkedList<MessagingEdge>();
    private List<Association> collectedAssociations = new LinkedList<Association>();

    public BPMNVisual2ProcessGenerator() {
    }

    public BPMNVisual2ProcessGenerator(IPath path) {
        super(path);
    }

    public BPMNVisual2ProcessGenerator(Diagram diagram) {
        super(diagram);
    }

    public Activity addActivity(Graph parent, String name, int activityType, int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        Activity act = super.addActivity(parent, name, activityType);
        this.positions.put((EObject)act, rect);
        return act;
    }

    public Lane addLane(Pool pool, String name, int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        Lane lane = super.addLane(pool, name);
        this.positions.put((EObject)lane, rect);
        return lane;
    }

    public Pool addPool(String name, int x, int y, int width, int height) {
        Rectangle rect = new Rectangle(x, y, width, height);
        Pool pool = this.addPool(name);
        this.positions.put((EObject)pool, rect);
        return pool;
    }

    public List<IStatus> generateViews() {
        LinkedList<IStatus> statuses = new LinkedList<IStatus>();
        this.semantic2notationMap.clear();
        statuses.addAll(this.recursiveGenerate((List)this.getSemanticModel().eContents()));
        for (Association association : this.collectedAssociations) {
            this.semantic2notationMap.put((EObject)association, (View)this.generateAssociationView(association, statuses));
        }
        for (MessagingEdge mesEdge : this.collectedMessagingEdges) {
            this.semantic2notationMap.put((EObject)mesEdge, (View)this.generateMessagingEdgeView(mesEdge, statuses));
        }
        for (SequenceEdge seqEdge : this.collectedSequenceEdges) {
            this.semantic2notationMap.put((EObject)seqEdge, (View)this.generateSequenceEdgeView(seqEdge, statuses));
        }
        return statuses;
    }

    private List<IStatus> recursiveGenerate(List elements) {
        LinkedList<IStatus> statuses = new LinkedList<IStatus>();
        for (Object elt : elements) {
            if (elt instanceof Pool) {
                Node pool = this.generatePoolView((Pool)elt, statuses);
                this.semantic2notationMap.put((EObject)elt, (View)pool);
                statuses.addAll(this.recursiveGenerate((List)((Pool)elt).eContents()));
                continue;
            }
            if (elt instanceof SubProcess) {
                Node sp = this.generateActivityView((Activity)((SubProcess)elt), statuses);
                this.semantic2notationMap.put((EObject)elt, (View)sp);
                statuses.addAll(this.recursiveGenerate((List)((SubProcess)elt).eContents()));
                continue;
            }
            if (elt instanceof Activity) {
                this.semantic2notationMap.put((EObject)elt, (View)this.generateActivityView((Activity)elt, statuses));
                continue;
            }
            if (elt instanceof SequenceEdge) {
                this.collectedSequenceEdges.add((SequenceEdge)elt);
                continue;
            }
            if (elt instanceof MessagingEdge) {
                this.collectedMessagingEdges.add((MessagingEdge)elt);
                continue;
            }
            if (elt instanceof Association) {
                this.collectedAssociations.add((Association)elt);
                continue;
            }
            if (elt instanceof Lane) {
                this.semantic2notationMap.put((EObject)elt, (View)this.generateLaneView((Lane)elt, statuses));
                continue;
            }
            if (elt instanceof EAnnotation) continue;
            if (elt instanceof TextAnnotation) {
                this.semantic2notationMap.put((EObject)elt, (View)this.generateTextAnnotationView((TextAnnotation)elt, statuses));
                continue;
            }
            if (elt instanceof DataObject) {
                this.semantic2notationMap.put((EObject)elt, (View)this.generateDataObjectView((DataObject)elt, statuses));
                continue;
            }
            if (elt instanceof Group) {
                this.semantic2notationMap.put((EObject)elt, (View)this.generateGroupView((Group)elt, statuses));
                continue;
            }
            Status unknownElt = new Status(2, "org.eclipse.stp.bpmn.diagram", 2, BpmnDiagramMessages.bind((String)"BPMNVisual2ProcessGenerator_generateViewException", elt), null);
            statuses.add((IStatus)unknownElt);
        }
        return statuses;
    }

    private Node generateActivityView(final Activity activity, final List<IStatus> statuses) {
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(this){

            protected void doExecute() {
                Node parent = null;
                if (activity.getGraph() != null) {
                    for (Object child : ((View)BPMNVisual2ProcessGenerator.this.semantic2notationMap.get(activity.eContainer())).getChildren()) {
                        if (child instanceof Node && String.valueOf(5001).equals(String.valueOf(((Node)child).getType()))) {
                            parent = (Node)child;
                            continue;
                        }
                        if (!(child instanceof Node) || !String.valueOf(5002).equals(String.valueOf(((Node)child).getType()))) continue;
                        parent = (Node)child;
                    }
                } else {
                    for (Object child : ((View)BPMNVisual2ProcessGenerator.this.semantic2notationMap.get(activity.getEventHandlerFor())).getChildren()) {
                        if (!(child instanceof Node) || !String.valueOf(5003).equals(String.valueOf(((Node)child).getType()))) continue;
                        parent = (Node)child;
                    }
                }
                if (parent == null) {
                    throw new IllegalArgumentException(BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BPMNVisual2ProcessGenerator_cannotFindCompartment, (Object)activity.eContainer()));
                }
                Node aNode = null;
                if (activity.getActivityType().getValue() != 1) {
                    String semanticHints2 = BpmnVisualIDRegistry.getType(2001);
                    if (activity.getEventHandlerFor() != null) {
                        semanticHints2 = BpmnVisualIDRegistry.getType(2003);
                    }
                    aNode = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)activity), (View)parent, semanticHints2, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                } else {
                    String semanticHintsForSP = BpmnVisualIDRegistry.getType(2002);
                    aNode = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)activity), (View)parent, semanticHintsForSP, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                }
                if (aNode != null) {
                    BPMNVisual2ProcessGenerator.this.generateLayoutConstraint(aNode);
                    this.setReturnedObject((EObject)aNode);
                } else {
                    statuses.add(new Status(2, "org.eclipse.stp.bpmn.diagram", 2, BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BPMNVisual2ProcessGenerator_activity_cannot_create_view, (Object)activity), null));
                }
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Node)command.getReturnedObject();
    }

    private Node generateTextAnnotationView(final TextAnnotation textAnnotation, final List<IStatus> statuses) {
        final View parent = this.findParentView((Artifact)textAnnotation);
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(this){

            protected void doExecute() {
                String semanticHints = null;
                semanticHints = textAnnotation.getArtifactsContainer() instanceof Graph ? BpmnVisualIDRegistry.getType(2004) : BpmnVisualIDRegistry.getType(1002);
                Node node = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)textAnnotation), parent, semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (node != null) {
                    BPMNVisual2ProcessGenerator.this.generateLayoutConstraint(node);
                    this.setReturnedObject((EObject)node);
                } else {
                    statuses.add(new Status(2, "org.eclipse.stp.bpmn.diagram", 2, BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BPMNVisual2ProcessGenerator_text_ann_cannot_create_view, (Object)textAnnotation), null));
                }
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Node)command.getReturnedObject();
    }

    private View findParentView(Artifact artifact) {
        View tempParent = null;
        if (artifact.getArtifactsContainer() instanceof BpmnDiagram) {
            tempParent = this.semantic2notationMap.get(artifact.getArtifactsContainer());
        } else {
            for (Object child : this.semantic2notationMap.get(artifact.eContainer()).getChildren()) {
                if (child instanceof Node && String.valueOf(5001).equals(String.valueOf(((Node)child).getType()))) {
                    tempParent = (Node)child;
                    continue;
                }
                if (!(child instanceof Node) || !String.valueOf(5002).equals(String.valueOf(((Node)child).getType()))) continue;
                tempParent = (Node)child;
            }
        }
        return tempParent;
    }

    private Node generateDataObjectView(final DataObject dataObject, final List<IStatus> statuses) {
        final View parent = this.findParentView((Artifact)dataObject);
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(this){

            protected void doExecute() {
                String semanticHints = null;
                semanticHints = dataObject.getArtifactsContainer() instanceof Graph ? BpmnVisualIDRegistry.getType(2005) : BpmnVisualIDRegistry.getType(1003);
                Node node = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)dataObject), parent, semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (node != null) {
                    BPMNVisual2ProcessGenerator.this.generateLayoutConstraint(node);
                    this.setReturnedObject((EObject)node);
                } else {
                    statuses.add(new Status(2, "org.eclipse.stp.bpmn.diagram", 2, BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BPMNVisual2ProcessGenerator_data_object_cannot_create_view, (Object)dataObject), null));
                }
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Node)command.getReturnedObject();
    }

    private Node generateGroupView(final Group group, final List<IStatus> statuses) {
        final View parent = this.findParentView((Artifact)group);
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(this){

            protected void doExecute() {
                String semanticHints = null;
                semanticHints = group.getArtifactsContainer() instanceof Graph ? BpmnVisualIDRegistry.getType(2006) : BpmnVisualIDRegistry.getType(1004);
                Node node = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)group), parent, semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (node != null) {
                    BPMNVisual2ProcessGenerator.this.generateLayoutConstraint(node);
                    this.setReturnedObject((EObject)node);
                } else {
                    statuses.add(new Status(2, "org.eclipse.stp.bpmn.diagram", 2, BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BPMNVisual2ProcessGenerator_group_cannot_create_view, (Object)group), null));
                }
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Node)command.getReturnedObject();
    }

    private Node generatePoolView(final Pool pool, final List<IStatus> statuses) {
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(this){

            protected void doExecute() {
                String semanticHints = BpmnVisualIDRegistry.getType(1001);
                Node poolNotationNode = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)pool), (View)BPMNVisual2ProcessGenerator.this.getGraphicalModel(), semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (poolNotationNode != null) {
                    BPMNVisual2ProcessGenerator.this.generateLayoutConstraint(poolNotationNode);
                    this.setReturnedObject((EObject)poolNotationNode);
                } else {
                    statuses.add(new Status(2, "org.eclipse.stp.bpmn.diagram", 2, BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BPMNVisual2ProcessGenerator_pool_cannot_create_view, (Object)pool), null));
                }
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Node)command.getReturnedObject();
    }

    private void generateLayoutConstraint(Node node) {
        if (this.positions.get(node.getElement()) != null) {
            Bounds bounds = NotationFactory.eINSTANCE.createBounds();
            Rectangle rect = this.positions.get(node.getElement());
            bounds.setHeight(rect.height);
            bounds.setWidth(rect.width);
            bounds.setX(rect.x);
            bounds.setY(rect.y);
            node.setLayoutConstraint((LayoutConstraint)bounds);
        }
    }

    private Node generateLaneView(final Lane lane, final List<IStatus> statuses) {
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(this){

            protected void doExecute() {
                Node parent = null;
                for (Object child : ((View)BPMNVisual2ProcessGenerator.this.semantic2notationMap.get(lane.eContainer())).getChildren()) {
                    if (!(child instanceof Node) || !String.valueOf(5001).equals(String.valueOf(((Node)child).getType()))) continue;
                    parent = (Node)child;
                }
                if (parent == null) {
                    throw new IllegalArgumentException(BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BPMNVisual2ProcessGenerator_cannotFindCompartment, (Object)lane.eContainer()));
                }
                String semanticHints = BpmnVisualIDRegistry.getType(2007);
                Node laneNotationNode = ViewService.getInstance().createNode((IAdaptable)new EObjectAdapter((EObject)lane), parent, semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (laneNotationNode != null) {
                    BPMNVisual2ProcessGenerator.this.generateLayoutConstraint(laneNotationNode);
                    this.setReturnedObject((EObject)laneNotationNode);
                } else {
                    statuses.add(new Status(2, "org.eclipse.stp.bpmn.diagram", 2, BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BPMNVisual2ProcessGenerator_lane_cannot_create_view, (Object)lane), null));
                }
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Node)command.getReturnedObject();
    }

    private Edge generateSequenceEdgeView(final SequenceEdge seqEdge, final List<IStatus> statuses) {
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(this){

            protected void doExecute() {
                String semanticHints = BpmnVisualIDRegistry.getType(3001);
                Edge anEdge = (Edge)ViewService.getInstance().createEdge((IAdaptable)new EObjectAdapter((EObject)seqEdge), (View)BPMNVisual2ProcessGenerator.this.getGraphicalModel(), semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (anEdge == null) {
                    statuses.add(new Status(2, "org.eclipse.stp.bpmn.diagram", 2, BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BPMNVisual2ProcessGenerator_sequence_edge_cannot_create_view, (Object)seqEdge), null));
                } else {
                    anEdge.setSource((View)BPMNVisual2ProcessGenerator.this.semantic2notationMap.get(seqEdge.getSource()));
                    anEdge.setTarget((View)BPMNVisual2ProcessGenerator.this.semantic2notationMap.get(seqEdge.getTarget()));
                    this.setReturnedObject((EObject)anEdge);
                }
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Edge)command.getReturnedObject();
    }

    private Edge generateMessagingEdgeView(final MessagingEdge mesEdge, final List<IStatus> statuses) {
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(this){

            protected void doExecute() {
                String semanticHints = BpmnVisualIDRegistry.getType(3002);
                Edge anEdge = (Edge)ViewService.getInstance().createEdge((IAdaptable)new EObjectAdapter((EObject)mesEdge), (View)BPMNVisual2ProcessGenerator.this.getGraphicalModel(), semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (anEdge == null) {
                    statuses.add(new Status(2, "org.eclipse.stp.bpmn.diagram", 2, BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BPMNVisual2ProcessGenerator_messaging_edge_cannot_create_view, (Object)mesEdge), null));
                } else {
                    anEdge.setSource((View)BPMNVisual2ProcessGenerator.this.semantic2notationMap.get(mesEdge.getSource()));
                    anEdge.setTarget((View)BPMNVisual2ProcessGenerator.this.semantic2notationMap.get(mesEdge.getTarget()));
                    this.setReturnedObject((EObject)anEdge);
                }
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Edge)command.getReturnedObject();
    }

    private Edge generateAssociationView(final Association association, final List<IStatus> statuses) {
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(this){

            protected void doExecute() {
                String semanticHints = BpmnVisualIDRegistry.getType(3003);
                Edge anEdge = (Edge)ViewService.getInstance().createEdge((IAdaptable)new EObjectAdapter((EObject)association), (View)BPMNVisual2ProcessGenerator.this.getGraphicalModel(), semanticHints, -1, BpmnDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                if (anEdge == null) {
                    statuses.add(new Status(2, "org.eclipse.stp.bpmn.diagram", 2, BpmnDiagramMessages.bind((String)BpmnDiagramMessages.BPMNVisual2ProcessGenerator_association_cannot_create_view, (Object)association), null));
                } else {
                    anEdge.setSource((View)BPMNVisual2ProcessGenerator.this.semantic2notationMap.get(association.getSource()));
                    anEdge.setTarget((View)BPMNVisual2ProcessGenerator.this.semantic2notationMap.get(association.getTarget()));
                    this.setReturnedObject((EObject)anEdge);
                }
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
        return (Edge)command.getReturnedObject();
    }

    public Map<EObject, View> getSemantic2notationMap() {
        return this.semantic2notationMap;
    }

    public void setEObjectFeature(final EObject elt, final EStructuralFeature feature, final Object value) {
        BPMNProcessGenerator.InternalRecordingCommand command = new BPMNProcessGenerator.InternalRecordingCommand(this){

            protected void doExecute() {
                elt.eSet(feature, value);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)command);
    }
}

