/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.ui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.diagram.ui.tools.PopupBarTool;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.ui.PopupBarDescriptor;
import org.eclipse.stp.bpmn.diagram.ui.RoundedRectangleWithTail;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PopupBalloon {
    private int partHashCode;
    private static int ACTION_BUTTON_START_X = 5;
    private static int ACTION_BUTTON_START_Y = 5;
    private static int ACTION_MARGIN_RIGHT = 10;
    private static int ACTION_WIDTH_HGT = 30;
    private static double BALLOON_X_OFFSET_RHS = 0.65;
    private static double BALLOON_X_OFFSET_LHS = 0.25;
    private static int BALLOON_Y_OFFSET = 10;
    private static final int DISAPPEARANCE_DELAY = 1000;
    private int disappearance_delay = 1000;
    protected List<Image> imagesToBeDisposed = new LinkedList<Image>();
    private double myBallonOffsetPercent = BALLOON_X_OFFSET_RHS;
    private IFigure myBalloon = null;
    private List<PopupBarDescriptor> myPopupBarDescriptors = new LinkedList<PopupBarDescriptor>();
    private Layer layer;

    public PopupBalloon(EditPart part) {
        this.layer = (Layer)LayerManager.Helper.find((EditPart)part).getLayer((Object)"Feedback Layer");
        this.partHashCode = part.hashCode();
    }

    public void addPopupBarDescriptor(String text, int severity) {
        if (text == null) {
            return;
        }
        ArrayList<PopupBarDescriptor> toRemove = new ArrayList<PopupBarDescriptor>();
        for (PopupBarDescriptor desc : this.myPopupBarDescriptors) {
            if (!desc.getToolTip().equals(text)) continue;
            if (severity > desc.getSeverity()) {
                toRemove.add(desc);
                continue;
            }
            return;
        }
        this.myPopupBarDescriptors.removeAll(toRemove);
        PopupBarDescriptor p = new PopupBarDescriptor(text, severity);
        p.setShouldBeDisposed(false);
        this.myPopupBarDescriptors.add(p);
    }

    public void addPopupBarDescriptor(IElementType type) {
        PopupBarDescriptor p = new PopupBarDescriptor(BpmnDiagramMessages.bind((String)BpmnDiagramMessages.PopupBalloon_add_new, (Object)type.getDisplayName()), IconService.getInstance().getIcon((IAdaptable)type), type, this.getDragTracker());
        p.setShouldBeDisposed(false);
        this.myPopupBarDescriptors.add(p);
    }

    public void addPopupBarDescriptor(IElementType type, DragTracker tracker) {
        PopupBarDescriptor p = new PopupBarDescriptor(BpmnDiagramMessages.bind((String)BpmnDiagramMessages.PopupBalloon_add_new, (Object)type.getDisplayName()), IconService.getInstance().getIcon((IAdaptable)type), type, tracker);
        p.setShouldBeDisposed(false);
        this.myPopupBarDescriptors.add(p);
    }

    protected IFigure createPopupBarFigure() {
        return new RoundedRectangleWithTail();
    }

    protected void fillPopupBarDescriptors() {
    }

    public IFigure getBalloon() {
        return this.myBalloon;
    }

    protected int getDisappearanceDelay() {
        return this.disappearance_delay;
    }

    protected List<PopupBarDescriptor> getPopupBarDescriptors() {
        return this.myPopupBarDescriptors;
    }

    public void hide() {
        this.internalHide(true);
    }

    private void internalHide(boolean disassociateWithEditPart) {
        if (this.getBalloon() != null) {
            this.teardownPopupBar();
        }
    }

    protected void hideAfterDelay(int delay) {
        if (this.isShowing()) {
            Display.getCurrent().timerExec(delay, new Runnable(){

                public void run() {
                    PopupBalloon.this.internalHide(false);
                }
            });
        }
    }

    private void initPopupBars() {
        List<PopupBarDescriptor> theList = this.getPopupBarDescriptors();
        if (theList.isEmpty()) {
            return;
        }
        this.myBalloon = this.createPopupBarFigure();
        int yTotal = 0;
        int xTotal = 0;
        int yLoc = ACTION_BUTTON_START_Y;
        int xLoc = ACTION_BUTTON_START_X;
        for (PopupBarDescriptor theDesc : theList) {
            Label b = new Label(theDesc.getToolTip(), theDesc.getIcon());
            Rectangle r1 = new Rectangle();
            r1.setLocation(xLoc, yLoc);
            b.setFont(Display.getCurrent().getSystemFont());
            r1.setSize(b.getPreferredSize());
            b.setBounds(r1);
            this.getBalloon().add((IFigure)b);
            yTotal = (yLoc += r1.height) + r1.height;
            int n = xTotal = xTotal < r1.width ? r1.width : xTotal;
        }
        this.getBalloon().setSize(xTotal += ACTION_BUTTON_START_X + ACTION_MARGIN_RIGHT, yTotal);
    }

    public boolean isShowing() {
        return this.getBalloon() != null;
    }

    protected boolean isRightDisplay() {
        return BALLOON_X_OFFSET_RHS == this.myBallonOffsetPercent;
    }

    protected void setRightHandDisplay() {
        this.myBallonOffsetPercent = BALLOON_X_OFFSET_RHS;
    }

    protected void populatePopupBars() {
        this.fillPopupBarDescriptors();
    }

    public void showBalloon(Point referencePoint, EditPart part) {
        this.partHashCode = part.hashCode();
        this.showBalloon(referencePoint);
    }

    public void showBalloon(Point referencePoint) {
        if (this.getBalloon() != null) {
            return;
        }
        this.populatePopupBars();
        this.initPopupBars();
        if (this.myPopupBarDescriptors.isEmpty()) {
            return;
        }
        this.layer.add(this.getBalloon());
        if (referencePoint == null) {
            throw new IllegalArgumentException("Reference point is null");
        }
        this.setLocation(referencePoint);
        this.hideAfterDelay(this.getDisappearanceDelay());
    }

    private void teardownPopupBar() {
        if (this.myBalloon.getParent() != null) {
            this.layer.remove(this.myBalloon);
        }
        this.myBalloon = null;
        for (PopupBarDescriptor desc : this.myPopupBarDescriptors) {
            if (!desc.shouldBeDisposed()) continue;
            this.imagesToBeDisposed.add(desc.getIcon());
        }
        this.myPopupBarDescriptors.clear();
        this.setRightHandDisplay();
        for (Image img : this.imagesToBeDisposed) {
            img.dispose();
        }
        this.imagesToBeDisposed.clear();
    }

    public void setLocation(Point location) {
        location = location.getTranslated(10, -(this.getBalloon().getBounds().height + 30));
        this.getBalloon().setLocation(location);
    }

    public boolean showsOnThisEditPart(EditPart part) {
        return part != null && part.hashCode() == this.partHashCode;
    }

    protected DragTracker getDragTracker() {
        return null;
    }

    public boolean hasPopupBarDescriptors() {
        return this.myPopupBarDescriptors.isEmpty();
    }

    public void showBalloonExclusive(Point location, Control control) {
        this.showBalloon(location);
        Display display = control.getDisplay();
        while (this.getBalloon() != null) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public Command getCommand() {
        for (PopupBarDescriptor descriptor : this.myPopupBarDescriptors) {
            if (!(descriptor.getDragTracker() instanceof PassivePopupBarTool) || ((PassivePopupBarTool)descriptor.getDragTracker()).getCommand() == null) continue;
            return ((PassivePopupBarTool)descriptor.getDragTracker()).getCommand();
        }
        return null;
    }

    public void setDisappearanceDelay(int disappearance_delay) {
        this.disappearance_delay = disappearance_delay;
    }

    public class PassivePopupBarTool
    extends PopupBarTool {
        private PopupBalloon _balloon;

        public PassivePopupBarTool(PopupBalloon balloon, EditPart epHost, IElementType elementType) {
            super(epHost, elementType);
            this._balloon = balloon;
        }

        protected boolean handleButtonUp(int button) {
            this.setCurrentCommand(this.getCommand());
            if (this._balloon != null) {
                this._balloon.hide();
            }
            return true;
        }

        protected boolean handleButtonDown(int button) {
            return false;
        }

        public Command getCommand() {
            return super.getCommand();
        }
    }
}

