/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures.router;

import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.stp.bpmn.diagram.edit.parts.SequenceEdgeEditPart;
import org.eclipse.stp.bpmn.figures.router.RectilinearRouterEx;

public class EdgeRectilinearRouter
extends RectilinearRouterEx {
    public static final int NO_CONSTRAINT = 0;
    public static final int CONSTRAINT_ON_TOP = 1;
    public static final int CONSTRAINT_BOTTOM = 2;
    public static final int CONSTRAINT_MIDDLE = 3;
    private SequenceEdgeEditPart edge;

    public EdgeRectilinearRouter() {
        this.normalizeBehavior = 3;
    }

    public EdgeRectilinearRouter(SequenceEdgeEditPart edge) {
        this();
        this.edge = edge;
    }

    public PointList routeClosestDistance(Connection conn) {
        Rectangle src;
        int gatewaySourceConstraint = this.edge.getSourceGatewayConstraint();
        int gatewayTargetConstraint = this.edge.getTargetGatewayConstraint();
        if (gatewaySourceConstraint == 0 && gatewayTargetConstraint == 0) {
            return super.routeClosestDistance(conn);
        }
        PointList newLine = this.routeFromConstraint(conn);
        Point ptOrig = new Point(newLine.getFirstPoint());
        Point ptTerm = new Point(newLine.getLastPoint());
        newLine.removeAllPoints();
        newLine.addPoint(ptOrig);
        IMapMode mm = MapModeUtil.getMapMode((IFigure)conn);
        int extra = mm.DPtoLP(16);
        Rectangle rectangle = src = conn.getSourceAnchor().getOwner() == null ? null : this.getOwnerBounds(conn.getSourceAnchor()).getCopy();
        if (src == null) {
            src = new Rectangle(ptOrig.getCopy().translate(new Dimension(-extra, -extra / 2)), ptOrig);
        } else {
            conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)src);
            conn.translateToRelative((Translatable)src);
        }
        if (this.normalizeBehavior == 4) {
            if (!EdgeRectilinearRouter.areAlmostEqual(ptOrig.x, ptTerm.x)) {
                newLine.addPoint(new Point(ptOrig.x, ptTerm.y));
            }
        } else {
            boolean needMiddleBendPoint = !EdgeRectilinearRouter.areAlmostEqual(ptOrig.y, ptTerm.y) && ptOrig.x + extra < ptTerm.x;
            boolean bl = needMiddleBendPoint = needMiddleBendPoint && gatewaySourceConstraint == gatewayTargetConstraint && (gatewaySourceConstraint == 0 || gatewaySourceConstraint == 3);
            if (needMiddleBendPoint) {
                Point ptOnOrigY = null;
                Point ptOnTermY = null;
                PointList oldLine = this.routeFromConstraint(conn);
                int i = 1;
                while (i < oldLine.size() - 1) {
                    Point bp = oldLine.getPoint(i);
                    if (bp.y == ptOrig.y) {
                        ptOnOrigY = bp;
                        break;
                    }
                    if (bp.y == ptTerm.y) {
                        ptOnTermY = bp;
                        break;
                    }
                    ++i;
                }
                if (ptOnOrigY != null) {
                    if (ptOnOrigY.x >= ptTerm.x || ptOnOrigY.x <= ptOrig.x) {
                        ptOnOrigY.x = (ptOrig.x + ptTerm.x) / 2;
                    }
                    newLine.addPoint(ptOnOrigY);
                    newLine.addPoint(new Point(ptOnOrigY.x, ptTerm.y));
                } else if (ptOnTermY != null) {
                    if (ptOnTermY.x >= ptTerm.x || ptTerm.x <= ptOrig.x) {
                        ptOnTermY.x = (ptOrig.x + ptTerm.x) / 2;
                    }
                    newLine.addPoint(new Point(ptOnTermY.x, ptOrig.y));
                    newLine.addPoint(ptOnTermY);
                }
            }
        }
        Point midSourceYPoint = new Point(ptOrig.x, (ptTerm.y + ptOrig.y) / 2);
        Point midTargetYPoint = new Point(ptTerm.x, (ptTerm.y + ptOrig.y) / 2);
        PointList oldLine = this.routeFromConstraint(conn);
        int bestBendPointX = oldLine.getMidpoint().x;
        if (ptOrig.x + extra > bestBendPointX || ptTerm.x < bestBendPointX) {
            int n = bestBendPointX = ptOrig.x + src.width + extra > ptTerm.x ? (ptOrig.x + ptTerm.x) / 2 : ptOrig.x + src.width + extra;
        }
        if (gatewaySourceConstraint != 0 && gatewaySourceConstraint != 3 && ptOrig.x + extra < ptTerm.x) {
            if (gatewayTargetConstraint == gatewaySourceConstraint && gatewayTargetConstraint != 0 && gatewayTargetConstraint != 3) {
                if (gatewaySourceConstraint == 2) {
                    newLine.addPoint(new Point(ptOrig.x, Math.max(ptOrig.y, ptTerm.y) + extra));
                } else if (gatewaySourceConstraint == 1) {
                    newLine.addPoint(new Point(ptOrig.x, Math.min(ptOrig.y, ptTerm.y) - extra));
                }
            } else if (ptOrig.y > ptTerm.y && gatewaySourceConstraint == 2) {
                newLine.addPoint(new Point(ptOrig.x, ptOrig.y + extra));
                newLine.addPoint(new Point(bestBendPointX, ptOrig.y + extra));
                newLine.addPoint(new Point(bestBendPointX, ptTerm.y));
            } else if (ptOrig.y < ptTerm.y && gatewaySourceConstraint == 1) {
                newLine.addPoint(new Point(ptOrig.x, ptOrig.y - extra));
                newLine.addPoint(new Point(bestBendPointX, ptOrig.y - extra));
                newLine.addPoint(new Point(bestBendPointX, ptTerm.y));
            } else if (!EdgeRectilinearRouter.areAlmostEqual(ptOrig.y, ptTerm.y)) {
                Point pointToConsider = gatewayTargetConstraint != 0 && gatewayTargetConstraint != 3 ? midTargetYPoint : ptTerm;
                newLine.addPoint(new Point(ptOrig.x, pointToConsider.y));
            }
        }
        if (gatewayTargetConstraint != 0 && gatewayTargetConstraint != 3 && ptOrig.x + extra < ptTerm.x) {
            if (gatewayTargetConstraint == gatewaySourceConstraint && gatewaySourceConstraint != 0 && gatewaySourceConstraint != 3) {
                if (gatewayTargetConstraint == 2) {
                    newLine.addPoint(new Point(ptTerm.x, Math.max(ptOrig.y, ptTerm.y) + extra));
                } else if (gatewayTargetConstraint == 1) {
                    newLine.addPoint(new Point(ptTerm.x, Math.min(ptOrig.y, ptTerm.y) - extra));
                }
            } else if (ptOrig.y < ptTerm.y && gatewayTargetConstraint == 2) {
                if (ptOrig.y + extra > ptTerm.y) {
                    newLine.addPoint(new Point(ptOrig.x + extra, ptOrig.y));
                    newLine.addPoint(new Point(ptTerm.x, ptTerm.y + extra));
                } else {
                    newLine.addPoint(new Point(ptTerm.x, ptOrig.y));
                }
            } else if (ptOrig.y > ptTerm.y && gatewayTargetConstraint == 1) {
                if (ptOrig.y - extra < ptTerm.y) {
                    newLine.addPoint(new Point(ptOrig.x + extra, ptOrig.y));
                    newLine.addPoint(new Point(ptTerm.x, ptTerm.y - extra));
                } else {
                    newLine.addPoint(new Point(ptTerm.x, ptOrig.y));
                }
            } else if (!EdgeRectilinearRouter.areAlmostEqual(ptOrig.y, ptTerm.y)) {
                Point pointToConsider = gatewaySourceConstraint != 0 ? midSourceYPoint : ptOrig;
                newLine.addPoint(ptTerm.x, pointToConsider.y);
            }
        }
        newLine.addPoint(ptTerm);
        return newLine;
    }

    protected void routeAroundSelfForClosestDistance(Connection conn, PointList newLine) {
        int sourceGatewayConstraint = this.edge.getSourceGatewayConstraint();
        int targetGatewayConstraint = this.edge.getTargetGatewayConstraint();
        if (targetGatewayConstraint != 0 && targetGatewayConstraint != 3 || sourceGatewayConstraint != 0 && sourceGatewayConstraint != 3) {
            Rectangle target;
            Rectangle src;
            Point ptOrig = newLine.getPoint(0);
            Point ptTerm = newLine.getLastPoint();
            IMapMode mm = MapModeUtil.getMapMode((IFigure)conn);
            mm.DPtoLP(3);
            int extra = mm.DPtoLP(16);
            Rectangle rectangle = src = conn.getSourceAnchor().getOwner() == null ? null : this.getOwnerBounds(conn.getSourceAnchor()).getCopy();
            if (src == null) {
                src = new Rectangle(ptOrig.getCopy().translate(new Dimension(-extra, -extra / 2)), ptOrig);
            } else {
                conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)src);
                conn.translateToRelative((Translatable)src);
            }
            Rectangle rectangle2 = target = conn.getTargetAnchor().getOwner() == null ? null : this.getOwnerBounds(conn.getTargetAnchor()).getCopy();
            if (target == null) {
                target = new Rectangle(ptTerm.getCopy().translate(new Dimension(extra, -extra / 2)), ptTerm);
            } else {
                conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)target);
                conn.translateToRelative((Translatable)target);
            }
            if (ptOrig.x + extra >= ptTerm.x) {
                newLine.setSize(newLine.size() - 1);
                int heightOwnerSrc = src.height;
                int heightOwnerTarget = target.height;
                int topRightSrcY = src.y;
                int bottomRightSrcY = src.y + src.height;
                int topLeftTargetY = target.y;
                int bottomLeftTargetY = target.y + target.height;
                int aboveY = -1;
                int farRightX = -1;
                if (topRightSrcY > bottomLeftTargetY + extra && sourceGatewayConstraint != 2) {
                    aboveY = (topRightSrcY + bottomLeftTargetY) / 2;
                    farRightX = ptOrig.x + extra;
                } else if (topLeftTargetY > bottomRightSrcY + extra) {
                    aboveY = (topLeftTargetY + bottomRightSrcY) / 2;
                    farRightX = ptOrig.x + extra;
                } else {
                    int extraY = Math.max(extra, Math.min(heightOwnerSrc / 2, heightOwnerTarget / 2));
                    Math.min(topRightSrcY, topLeftTargetY);
                    int belowYone = Math.max(bottomLeftTargetY, bottomRightSrcY);
                    aboveY = belowYone + extraY;
                    farRightX = Math.max(ptOrig.x + extra, ptTerm.x + extra + target.width);
                }
                int farLeft = ptTerm.x - extra;
                Point origPlus = new Point(farRightX, ptOrig.y);
                Point origAbove = new Point(origPlus.x, aboveY);
                Point termMinus = new Point(farLeft, ptTerm.y);
                Point termAbove = new Point(termMinus.x, aboveY);
                if (sourceGatewayConstraint == 0 || sourceGatewayConstraint == 3) {
                    newLine.addPoint(origPlus);
                    newLine.addPoint(origAbove);
                } else if (ptOrig.x + extra >= ptTerm.x) {
                    if (sourceGatewayConstraint == 1) {
                        newLine.addPoint(new Point(ptOrig.x, ptOrig.y - extra));
                        int minx = Math.min(ptOrig.x, ptTerm.x);
                        newLine.addPoint(new Point(minx - extra, ptOrig.y - extra));
                        newLine.addPoint(new Point(minx - extra, ptTerm.y));
                        if (targetGatewayConstraint == 0 || targetGatewayConstraint == 3) {
                            newLine.addPoint(ptTerm);
                            return;
                        }
                    } else {
                        newLine.addPoint(new Point(ptOrig.x, aboveY));
                    }
                }
                if (targetGatewayConstraint == 0 || targetGatewayConstraint == 3) {
                    if (ptOrig.x + extra > ptTerm.x) {
                        newLine.addPoint(termAbove);
                        newLine.addPoint(termMinus);
                    }
                } else {
                    newLine.addPoint(new Point(ptTerm.x, aboveY));
                }
                newLine.addPoint(ptTerm);
            }
            return;
        }
        super.routeAroundSelfForClosestDistance(conn, newLine);
    }
}

