/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.layouts;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gmf.runtime.gef.ui.figures.WrapperNodeFigure;
import org.eclipse.stp.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.swt.graphics.Font;

public class ActivityLayout
implements LayoutManager {
    private static final int EVENT_GATEWAYS_LABEL_MIN_WIDTH = 90;
    public static final Integer CENTER = new Integer(2);
    public static final Integer BOTTOM = new Integer(32);
    private IFigure center;
    private WrappingLabel bottom;
    private int vGap = 0;
    private int hGap = 0;

    public Dimension getMinimumSize(IFigure container, int wHint, int hHint) {
        return this.getPreferredSize(container, wHint, hHint);
    }

    public Dimension getPreferredSize(IFigure container, int wHint, int hHint) {
        return this.calculatePreferredSize(container, wHint, hHint);
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Dimension prefSize = new Dimension();
        if (this.center != null && this.center.isVisible()) {
            prefSize = this.center.getPreferredSize(wHint, wHint);
        }
        if (prefSize.width < 90 && this.bottom != null && this.bottom.isVisible() && this.bottom instanceof WrappingLabel) {
            Dimension prefLabel = this.bottom.getPreferredSize(wHint, hHint);
            if (prefLabel.width > 90) {
                prefSize.width = 90;
            }
        }
        return prefSize;
    }

    public void layout(IFigure container) {
        Dimension childSize;
        Rectangle area = container.getClientArea().getCopy();
        if (this.bottom.getSize().height == 0) {
            area.width = area.height = Math.min(area.height, area.width);
        }
        int squaresize = 0;
        int centerMinWidth = this.center.getMinimumSize().width;
        int bottomHeight = this.bottom.getPreferredSize().height;
        squaresize = bottomHeight > 0 ? area.height - bottomHeight : area.width;
        if (centerMinWidth > squaresize) {
            squaresize = centerMinWidth;
        }
        Rectangle rect = new Rectangle();
        if (this.center != null && this.center.isVisible()) {
            if (area.width < 0) {
                area.width = 0;
            }
            if (area.height < 0) {
                area.height = 0;
            }
            childSize = new Dimension(squaresize, squaresize);
            rect.setLocation(area.x, area.y);
            rect.setSize(childSize);
            this.center.setBounds(rect);
            area.height -= rect.height + this.vGap;
            area.y += rect.height + this.vGap;
        }
        if (this.bottom != null && this.bottom.isVisible()) {
            if (this.bottom instanceof WrappingLabel && area.height <= 0) {
                area.height = FigureUtilities.getFontMetrics((Font)this.bottom.getFont()).getHeight() * 2;
            }
            if (this.bottom.getText() != null && !"".equals(this.bottom.getText())) {
                childSize = this.bottom.getPreferredSize();
                childSize.height += 4;
            } else {
                childSize = Dimension.SINGLETON.getCopy();
            }
            rect.setSize(childSize);
            rect.setLocation(area.x, area.y);
            this.bottom.setBounds(rect);
            area.height -= rect.height + this.vGap;
        }
        if (this.bottom.getSize().height != 0) {
            int x = (this.bottom.getSize().width - squaresize) / 2;
            if (x < 0) {
                this.bottom.setLocation(this.bottom.getBounds().getLocation().translate(-x, 0));
            } else {
                this.center.setLocation(this.center.getBounds().getLocation().translate(x, 0));
            }
        }
        Dimension b = new Dimension();
        b.height = this.center.getSize().height + this.bottom.getSize().height;
        b.width = Math.max(this.bottom.getSize().width, this.center.getSize().width);
        container.setSize(b.getCopy());
        if (container.getParent() instanceof WrapperNodeFigure) {
            container.getParent().setSize(b.getCopy());
        }
    }

    public void remove(IFigure child) {
        if (this.center == child) {
            this.center = null;
        } else if (this.bottom == child) {
            this.bottom = null;
        }
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.remove(child);
        if (constraint == null) {
            return;
        }
        switch ((Integer)constraint) {
            case 2: {
                this.center = child;
                break;
            }
            case 32: {
                this.bottom = (WrappingLabel)child;
                break;
            }
        }
    }

    public void setHorizontalSpacing(int gap) {
        this.hGap = gap;
    }

    public void setVerticalSpacing(int gap) {
        this.vGap = gap;
    }

    public Object getConstraint(IFigure child) {
        return null;
    }

    public void invalidate() {
    }

    public IFigure getOvalOrDiamondFigure() {
        return this.center;
    }

    public WrappingLabel getLabelFigure() {
        return this.bottom;
    }
}

