/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.DragEditPartsTrackerEx;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.policies.ResizableShapeEditPolicyEx;
import org.eclipse.stp.bpmn.tools.PoolResizeTracker;

public class ResizablePoolEditPolicy
extends ResizableShapeEditPolicyEx {
    protected Handle createHandle(GraphicalEditPart owner, int direction) {
        return new PoolResizeHandle(owner, direction);
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move children");
        req.setEditParts(request.getEditParts());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        return this.getHost().getParent().getCommand((Request)req);
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"resize children");
        req.setEditParts(request.getEditParts());
        req.setMoveDelta(request.getMoveDelta());
        req.setSizeDelta(request.getSizeDelta());
        req.setLocation(request.getLocation());
        req.setExtendedData(request.getExtendedData());
        req.setResizeDirection(request.getResizeDirection());
        return this.getHost().getParent().getCommand((Request)req);
    }

    protected void replaceHandleDragEditPartsTracker(Handle handle) {
        if (handle instanceof AbstractHandle) {
            AbstractHandle h = (AbstractHandle)handle;
            h.setDragTracker((DragTracker)new DragEditPartsTrackerEx(this.getHost()){

                protected void addSourceCommands(boolean isMove, CompoundCommand command) {
                    if (!this.isCloneActive()) {
                        Request request = this.getTargetRequest();
                        request.setType((Object)(isMove ? "move" : "drag"));
                        command.add(ResizablePoolEditPolicy.this.getHost().getCommand(request));
                        request.setType((Object)"drop");
                    } else {
                        super.addSourceCommands(isMove, command);
                    }
                }
            });
        }
    }

    protected Command getAutoSizeCommand(Request request) {
        ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Dimension size = new Dimension(200, 200);
        Dimension minSize = this.getMinPoolSize(this.getHost().getParent().getChildren());
        size.width = Math.max(size.width, minSize.width);
        size.height = Math.max(size.height, minSize.height);
        ChangeBoundsRequest req = new ChangeBoundsRequest();
        req.setEditParts(this.getHost().getViewer().getSelectedEditParts());
        req.setMoveDelta(new Point(0, 0));
        Dimension currentSize = this.getHostFigure().getSize().getCopy();
        req.setSizeDelta(new Dimension(size.width - currentSize.width, size.height - currentSize.height));
        return this.getResizeCommand(req);
    }

    private Dimension getMinPoolSize(List parts) {
        Dimension result = new Dimension(200, 50);
        if (parts == null) {
            return result;
        }
        int i = 0;
        while (i < parts.size()) {
            PoolEditPart pool;
            IGraphicalEditPart poolCompartment;
            if (parts.get(i) instanceof PoolEditPart && (poolCompartment = (pool = (PoolEditPart)((Object)parts.get(i))).getChildBySemanticHint(Integer.toString(5001))) != null) {
                int nameWidth = poolCompartment.getFigure().getBounds().x + 1;
                Dimension maxRoomOfChildren = new Dimension(0, 0);
                for (Object ep : poolCompartment.getChildren()) {
                    if (!(ep instanceof IGraphicalEditPart)) continue;
                    IFigure figure = ((IGraphicalEditPart)ep).getFigure();
                    Rectangle bounds = figure.getBounds();
                    maxRoomOfChildren.height = Math.max(bounds.y + bounds.height, maxRoomOfChildren.height);
                    maxRoomOfChildren.width = Math.max(bounds.x + bounds.width, maxRoomOfChildren.width);
                }
                maxRoomOfChildren.expand(PoolPoolCompartmentEditPart.INSETS.getWidth(), PoolPoolCompartmentEditPart.INSETS.getHeight() + 2);
                if (this.getHost().equals(parts.get(i))) {
                    result.height = maxRoomOfChildren.height;
                }
                result.width = Math.max(maxRoomOfChildren.width + nameWidth, result.width);
            }
            ++i;
        }
        return result;
    }

    protected static class PoolResizeHandle
    extends ResizableShapeEditPolicyEx.ResizeHandleEx {
        public PoolResizeHandle(GraphicalEditPart owner, int direction) {
            super(owner, direction);
        }

        protected DragTracker createDragTracker() {
            return new PoolResizeTracker(this.getOwner(), this.cursorDirection);
        }
    }
}

