/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.List;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.diagram.edit.parts.Group2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.GroupEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.BpmnShapesDefaultSizes;
import org.eclipse.stp.bpmn.policies.ResizableShapeEditPolicyEx;

public class SubProcessSubProcessCompartmentXYLayoutEditPolicy
extends XYLayoutEditPolicy {
    private static final Dimension MIN_DIMENSION = SubProcessEditPart.EXPANDED_SIZE.getCopy().expand(0, -25);
    public static final boolean RESIZE_COMPARTMENT_ON = false;

    private double getZoom() {
        return ((DiagramRootEditPart)this.getHost().getRoot()).getZoomManager().getZoom();
    }

    protected Command getResizeChildrenCommand(ChangeBoundsRequest request) {
        if (request.getMoveDelta().x == 0 && request.getMoveDelta().y == 0 && request.getSizeDelta().width == 0 && request.getSizeDelta().height == 0) {
            return null;
        }
        boolean onlyContainsGroups = true;
        for (Object o : request.getEditParts()) {
            boolean bl = onlyContainsGroups = onlyContainsGroups && (o instanceof GroupEditPart || o instanceof Group2EditPart);
        }
        if (onlyContainsGroups) {
            return super.getResizeChildrenCommand(request);
        }
        CompoundCommand command = new CompoundCommand();
        if (this.negativeMoveDetected(request)) {
            return UnexecutableCommand.INSTANCE;
        }
        command.add(super.getResizeChildrenCommand(request));
        boolean unexec = this.avoidOverlap(request, command);
        if (unexec) {
            return UnexecutableCommand.INSTANCE;
        }
        Point moveChildren = new Point(0, 0);
        if ((request.getResizeDirection() & 1) != 0) {
            moveChildren.y = request.getSizeDelta().height;
        }
        if ((request.getResizeDirection() & 8) != 0) {
            moveChildren.x = request.getSizeDelta().width;
        }
        if (!(moveChildren.x == 0 && moveChildren.y == 0 || request.getEditParts() == null || request.getEditParts().isEmpty())) {
            for (Object part : request.getEditParts()) {
                IGraphicalEditPart comp;
                if (!(part instanceof SubProcessEditPart) || (comp = ((SubProcessEditPart)((Object)part)).getChildBySemanticHint(BpmnVisualIDRegistry.getType(5002))) == null) continue;
                ChangeBoundsRequest move = new ChangeBoundsRequest((Object)"move children");
                move.setMoveDelta(moveChildren);
                move.setEditParts(comp.getChildren());
                Command c = comp.getCommand((Request)move);
                if (c == null || !c.canExecute()) continue;
                command.add(c);
            }
        }
        if (BpmnDiagramEditorPlugin.getInstance().getPreferenceStore().getBoolean("bpmn.connections.snap.back.on.move")) {
            this.makeSnapBackCommands(command, request);
        }
        return command;
    }

    private void makeSnapBackCommands(CompoundCommand compound, ChangeBoundsRequest request) {
        for (Object epObj : request.getEditParts()) {
            if (!(epObj instanceof AbstractGraphicalEditPart)) continue;
            this.iterateOverConnections(((AbstractGraphicalEditPart)epObj).getSourceConnections(), compound);
            this.iterateOverConnections(((AbstractGraphicalEditPart)epObj).getTargetConnections(), compound);
        }
    }

    private void iterateOverConnections(List connections, CompoundCommand compound) {
        Request snapBack = new Request((Object)"snap_back");
        for (Object con : connections) {
            if (!(con instanceof ConnectionEditPart)) continue;
            LabelEditPart label = (LabelEditPart)((ConnectionEditPart)con).getChildBySemanticHint(BpmnVisualIDRegistry.getType(4012));
            if (label == null) {
                label = (LabelEditPart)((ConnectionEditPart)con).getChildBySemanticHint(BpmnVisualIDRegistry.getType(4013));
            }
            if (label == null) continue;
            compound.add(label.getCommand(snapBack));
        }
    }

    private boolean negativeMoveDetected(ChangeBoundsRequest request) {
        if (request == null) {
            return false;
        }
        boolean isNegative = false;
        for (Object ep : request.getEditParts()) {
            int ymove;
            Point loc = ((GraphicalEditPart)ep).getFigure().getBounds().getLocation().getCopy();
            int xmove = (int)((double)loc.x + (double)request.getMoveDelta().x / this.getZoom());
            if (xmove < 0) {
                isNegative = true;
            }
            if ((ymove = (int)((double)loc.y + (double)request.getMoveDelta().y / this.getZoom())) >= 0) continue;
            isNegative = true;
        }
        return isNegative;
    }

    protected boolean considerPartForMinimumSizeComputations(IGraphicalEditPart childEditPart) {
        EObject domainObject = childEditPart.resolveSemanticElement();
        return domainObject == null || !(domainObject instanceof Artifact);
    }

    protected Command getCreateCommand(CreateRequest request) {
        SubProcessSubProcessBodyCompartmentEditPart spCompartment = (SubProcessSubProcessBodyCompartmentEditPart)this.getHost();
        IFigure compartmentFigure = spCompartment.getFigure();
        IFigure currentFigure = this.getHostFigure().getParent();
        while (currentFigure != null && currentFigure != spCompartment) {
            if (currentFigure instanceof FreeformViewport) {
                compartmentFigure = currentFigure;
                break;
            }
            currentFigure = currentFigure.getParent();
        }
        Point loc = request.getLocation().getCopy();
        Rectangle here = compartmentFigure.getBounds().getCopy();
        if (here.x != 0 || here.y != 0) {
            Dimension requestSize;
            compartmentFigure.translateToAbsolute((Translatable)here);
            this.getHostFigure().translateToAbsolute((Translatable)loc);
            this.getHostFigure().translateToRelative((Translatable)loc);
            loc.x -= here.x;
            loc.y -= here.y;
            Dimension dimension = requestSize = request.getSize() == null ? null : request.getSize().getCopy().scale(1.0 / this.getZoom());
            if (requestSize == null) {
                CreateViewRequest.ViewDescriptor desc;
                List descriptors;
                requestSize = new Dimension(300, 100);
                if (request instanceof CreateViewRequest && !(descriptors = ((CreateViewRequest)request).getViewDescriptors()).isEmpty() && (desc = (CreateViewRequest.ViewDescriptor)descriptors.get(0)).getElementAdapter() != null) {
                    IElementType type = (IElementType)desc.getElementAdapter().getAdapter(IElementType.class);
                    requestSize = BpmnShapesDefaultSizes.getDefaultSize(type).getCopy();
                }
            }
            if ((double)loc.x + (double)requestSize.width * this.getZoom() > (double)here.width) {
                request.getLocation().x = (int)((double)request.getLocation().x - ((double)((long)loc.x + Math.round((double)requestSize.width * this.getZoom()) - (long)here.width + 1L) + 1.0 * this.getZoom()));
            }
            if ((double)loc.y + (double)requestSize.height * this.getZoom() > (double)here.height) {
                request.getLocation().y = (int)((double)request.getLocation().y - ((double)((long)loc.y + Math.round((double)requestSize.height * this.getZoom()) - (long)here.height + 1L) + 1.0 * this.getZoom()));
            }
            if (loc.x < 0) {
                request.getLocation().x += -loc.x + 1;
            }
            if (loc.y < 0) {
                request.getLocation().y += -loc.y + 1;
            }
        }
        return super.getCreateCommand(request);
    }

    private boolean avoidOverlap(ChangeBoundsRequest request, CompoundCommand compound) {
        return ResizableShapeEditPolicyEx.isOverlappingRequest((Request)request);
    }
}

