/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.Connection;
import org.eclipse.stp.eid.datamodel.diagram.edit.policies.Cimero2EditorBaseItemSemanticEditPolicy;

public class ConnectionReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ConnectionReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Connection)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof ComponentInstance) || !(this.newEnd instanceof ComponentInstance)) {
            return false;
        }
        ComponentInstance target = this.getLink().getTarget();
        if (!(this.getLink().eContainer() instanceof ComponentInstance)) {
            return false;
        }
        ComponentInstance container = (ComponentInstance)this.getLink().eContainer();
        return Cimero2EditorBaseItemSemanticEditPolicy.LinkConstraints.canExistConnection_3001(container, this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof ComponentInstance) || !(this.newEnd instanceof ComponentInstance)) {
            return false;
        }
        ComponentInstance source = this.getLink().getSource();
        if (!(this.getLink().eContainer() instanceof ComponentInstance)) {
            return false;
        }
        ComponentInstance container = (ComponentInstance)this.getLink().eContainer();
        return Cimero2EditorBaseItemSemanticEditPolicy.LinkConstraints.canExistConnection_3001(container, source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().setSource(this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTarget(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Connection getLink() {
        return (Connection)this.getElementToEdit();
    }

    protected ComponentInstance getOldSource() {
        return (ComponentInstance)this.oldEnd;
    }

    protected ComponentInstance getNewSource() {
        return (ComponentInstance)this.newEnd;
    }

    protected ComponentInstance getOldTarget() {
        return (ComponentInstance)this.oldEnd;
    }

    protected ComponentInstance getNewTarget() {
        return (ComponentInstance)this.newEnd;
    }
}

