/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.expressions;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.Query;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.utilities.AbstractVisitor;
import org.eclipse.ocl.utilities.Visitor;
import org.eclipse.stp.eid.datamodel.diagram.expressions.Cimero2EditorAbstractExpression;

public class Cimero2EditorOCLFactory {
    private Cimero2EditorOCLFactory() {
    }

    public static Cimero2EditorAbstractExpression getExpression(String body, EClassifier context, Map environment) {
        return new Expression(body, context, environment);
    }

    public static Cimero2EditorAbstractExpression getExpression(String body, EClassifier context) {
        return Cimero2EditorOCLFactory.getExpression(body, context, Collections.EMPTY_MAP);
    }

    private static class Expression
    extends Cimero2EditorAbstractExpression {
        private WeakReference queryRef;
        private final OCL oclInstance = OCL.newInstance();

        public Expression(String body, EClassifier context, Map environment) {
            super(body, context);
            Expression.initCustomEnv(this.oclInstance.getEnvironment(), environment);
        }

        protected Query getQuery() {
            Query oclQuery = null;
            if (this.queryRef != null) {
                oclQuery = (Query)this.queryRef.get();
            }
            if (oclQuery == null) {
                OCL.Helper oclHelper = this.oclInstance.createOCLHelper();
                oclHelper.setContext((Object)this.context());
                try {
                    OCLExpression oclExpression = oclHelper.createQuery(this.body());
                    oclQuery = this.oclInstance.createQuery(oclExpression);
                    this.queryRef = new WeakReference<Query>(oclQuery);
                    this.setStatus(0, null, null);
                }
                catch (ParserException e) {
                    this.setStatus(4, e.getMessage(), e);
                }
            }
            return oclQuery;
        }

        protected Object doEvaluate(Object context, Map env) {
            Query oclQuery = this.getQuery();
            if (oclQuery == null) {
                return null;
            }
            EvaluationEnvironment evalEnv = oclQuery.getEvaluationEnvironment();
            for (Map.Entry nextEntry : env.entrySet()) {
                evalEnv.replace((String)nextEntry.getKey(), nextEntry.getValue());
            }
            try {
                this.initExtentMap(context);
                Object result = oclQuery.evaluate(context);
                Object object = result != this.oclInstance.getEnvironment().getOCLStandardLibrary().getOclInvalid() ? result : null;
                return object;
            }
            finally {
                evalEnv.clear();
                oclQuery.getExtentMap().clear();
            }
        }

        protected Object performCast(Object value, ETypedElement targetType) {
            if (targetType.getEType() instanceof EEnum && value instanceof EEnumLiteral) {
                EEnumLiteral literal = (EEnumLiteral)value;
                return literal.getInstance() != null ? literal.getInstance() : literal;
            }
            return super.performCast(value, targetType);
        }

        private void initExtentMap(Object context) {
            if (!this.getStatus().isOK() || context == null) {
                return;
            }
            final Query queryToInit = this.getQuery();
            final Object extentContext = context;
            queryToInit.getExtentMap().clear();
            if (queryToInit.queryText() != null && queryToInit.queryText().indexOf("allInstances") >= 0) {
                AbstractVisitor visitior = new AbstractVisitor(){
                    private boolean usesAllInstances = false;

                    public Object visitOperationCallExp(OperationCallExp oc) {
                        if (!this.usesAllInstances) {
                            boolean bl = this.usesAllInstances = 40 == oc.getOperationCode();
                            if (this.usesAllInstances) {
                                queryToInit.getExtentMap().putAll(Expression.this.oclInstance.getEvaluationEnvironment().createExtentMap(extentContext));
                            }
                        }
                        return super.visitOperationCallExp(oc);
                    }
                };
                queryToInit.getExpression().accept((Visitor)visitior);
            }
        }

        private static void initCustomEnv(Environment ecoreEnv, Map environment) {
            for (String varName : environment.keySet()) {
                EClassifier varType = (EClassifier)environment.get(varName);
                ecoreEnv.addElement(varName, Expression.createVar(ecoreEnv, varName, varType), false);
            }
        }

        private static org.eclipse.ocl.expressions.Variable createVar(Environment ecoreEnv, String name, EClassifier type) {
            Variable var = EcoreFactory.eINSTANCE.createVariable();
            var.setName(name);
            var.setType(ecoreEnv.getUMLReflection().getOCLType((Object)type));
            return var;
        }
    }
}

