/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.diagram.preferences;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.eid.datamodel.ESB;
import org.eclipse.stp.eid.datamodel.cimero2Factory;
import org.eclipse.stp.eid.datamodel.diagram.part.Cimero2EditorDiagramEditorPlugin;
import org.eclipse.stp.eid.datamodel.diagram.providers.Cimero2EditorIconProvider;
import org.eclipse.stp.eid.datamodel.util.Cimero2EditorPlugin;
import org.eclipse.stp.eid.datamodel.util.LoggerTool;
import org.eclipse.stp.eid.datamodel.util.Parser;
import org.eclipse.stp.eid.generator.coordinator.Coordinateur;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class DiagramAddComponentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
Listener {
    private Text componentName;
    private Combo componentType;
    private Combo esb;
    private Text installComponentName;
    private Text installComponentZip;
    private Text graphIcon;
    private Text componentNamespace;
    private Text maxInput;
    private Text minInput;
    private Text maxOutput;
    private Text minOutput;
    private String componentNameValue;
    private String componentTypeValue;
    private String esbValue;
    private String installComponentNameValue;
    private String installComponentZipValue;
    private String graphIconValue;
    private String componentNamespaceValue;
    private String maxInputValue;
    private String minInputValue;
    private String maxOutputValue;
    private String minOutputValue;
    private Shell dialogShell;
    private static Button okButton;
    private static Button cancelButton;
    private String currentEsb;
    private Button[] esbButtons = new Button[cimero2Factory.eINSTANCE.getEsbList().size()];
    static final String[] esbs;
    private ScrolledComposite componentVariablesScroll;
    private TableViewer componentsVariables;
    private ComponentVariableContentProvider componentVariablesContent;
    private Button newVariable;
    private Button editVariable;

    static {
        esbs = new String[cimero2Factory.eINSTANCE.getEsbList().size()];
    }

    protected final Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        GridData gridData = null;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(1808);
        int i = 0;
        while (i < this.esbButtons.length) {
            this.esbButtons[i] = new Button(composite, 16);
            this.esbButtons[i].setText(esbs[i]);
            this.esbButtons[i].addListener(13, (Listener)this);
            ++i;
        }
        this.esbButtons[0].setSelection(true);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 2;
        Label pathVariablesLabel = new Label(composite, 16384);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 20;
        pathVariablesLabel.setLayoutData((Object)gridData);
        pathVariablesLabel.setText("Create or edit components");
        this.componentVariablesScroll = new ScrolledComposite(composite, 2816);
        this.componentVariablesScroll.setExpandHorizontal(true);
        this.componentVariablesScroll.setExpandVertical(true);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        this.componentVariablesScroll.setLayoutData((Object)gridData);
        this.componentsVariables = new TableViewer((Composite)this.componentVariablesScroll);
        this.componentVariablesScroll.setContent((Control)this.componentsVariables.getTable());
        this.componentVariablesContent = new ComponentVariableContentProvider();
        this.componentsVariables.setContentProvider((IContentProvider)this.componentVariablesContent);
        this.componentsVariables.setLabelProvider((IBaseLabelProvider)new ComponentVariableLabelProvider());
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = false;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 1;
        gridData.verticalAlignment = 1;
        buttonComposite.setLayoutData((Object)gridData);
        this.newVariable = new Button(buttonComposite, 0x1000000);
        this.newVariable.setText("New");
        this.setButtonLayoutData(this.newVariable);
        this.editVariable = new Button(buttonComposite, 0x1000000);
        this.editVariable.setText("Edit");
        this.editVariable.addListener(3, (Listener)this);
        this.setButtonLayoutData(this.editVariable);
        Label closeDiagramsLabel = new Label(composite, 16384);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = false;
        gridData.horizontalSpan = 2;
        gridData.verticalIndent = 20;
        closeDiagramsLabel.setLayoutData((Object)gridData);
        Display display = this.getShell().getDisplay();
        closeDiagramsLabel.setImage(display.getSystemImage(8));
        closeDiagramsLabel.setText("To make the new components available close and re-open your diagrams.\nTo use your edited components use new diagrams.");
        this.componentsVariables.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DiagramAddComponentPreferencePage.this.componentVariableSelected(event.getSelection());
            }
        });
        this.newVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagramAddComponentPreferencePage.this.addComponent();
            }
        });
        this.editVariable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DiagramAddComponentPreferencePage.this.editComponent(DiagramAddComponentPreferencePage.this.componentsVariables.getSelection());
            }
        });
        this.initializeContents();
        this.applyDialogFont(composite);
        return composite;
    }

    protected final void addComponent() {
        Shell dialog;
        Shell shell = this.getShell();
        Display display = shell.getDisplay();
        this.dialogShell = dialog = new Shell(shell, 67680);
        this.createComponentContents(dialog);
        dialog.pack();
        dialog.open();
        while (!dialog.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void createComponentContents(Shell dialog) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        dialog.setLayout((Layout)gridLayout);
        dialog.setSize(200, 500);
        dialog.setText("New component");
        Image image = Cimero2EditorIconProvider.getImage("eclipse_icon");
        dialog.setImage(image);
        Group componentInfos = new Group((Composite)dialog, 0);
        componentInfos.setText("Basic component informations");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        componentInfos.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(256);
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        componentInfos.setLayoutData((Object)gridData);
        this.createTextFields(componentInfos);
        GridData buttonGrid = new GridData(17408);
        okButton = new Button((Composite)dialog, 8);
        okButton.setText("     OK     ");
        okButton.setLayoutData((Object)buttonGrid);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiagramAddComponentPreferencePage.this.componentNameValue = DiagramAddComponentPreferencePage.this.componentName.getText();
                DiagramAddComponentPreferencePage.this.esbValue = DiagramAddComponentPreferencePage.this.esb.getText();
                DiagramAddComponentPreferencePage.this.componentTypeValue = DiagramAddComponentPreferencePage.this.componentType.getText();
                if (DiagramAddComponentPreferencePage.this.componentTypeValue.compareTo("Service Engine") == 0) {
                    DiagramAddComponentPreferencePage.this.componentTypeValue = "SE";
                } else {
                    DiagramAddComponentPreferencePage.this.componentTypeValue = "BC";
                }
                DiagramAddComponentPreferencePage.this.installComponentNameValue = DiagramAddComponentPreferencePage.this.installComponentName.getText();
                DiagramAddComponentPreferencePage.this.installComponentZipValue = DiagramAddComponentPreferencePage.this.installComponentZip.getText();
                DiagramAddComponentPreferencePage.this.graphIconValue = DiagramAddComponentPreferencePage.this.graphIcon.getText();
                DiagramAddComponentPreferencePage.this.componentNamespaceValue = DiagramAddComponentPreferencePage.this.componentNamespace.getText();
                DiagramAddComponentPreferencePage.this.maxInputValue = DiagramAddComponentPreferencePage.this.maxInput.getText();
                DiagramAddComponentPreferencePage.this.minInputValue = DiagramAddComponentPreferencePage.this.minInput.getText();
                DiagramAddComponentPreferencePage.this.maxOutputValue = DiagramAddComponentPreferencePage.this.maxOutput.getText();
                DiagramAddComponentPreferencePage.this.minOutputValue = DiagramAddComponentPreferencePage.this.minOutput.getText();
                String[] params = new String[]{DiagramAddComponentPreferencePage.this.componentNameValue, DiagramAddComponentPreferencePage.this.esbValue, DiagramAddComponentPreferencePage.this.componentTypeValue, DiagramAddComponentPreferencePage.this.installComponentNameValue, DiagramAddComponentPreferencePage.this.installComponentZipValue, Cimero2EditorPlugin.findTheFileNameInAPath((String)DiagramAddComponentPreferencePage.this.graphIconValue), DiagramAddComponentPreferencePage.this.componentNamespaceValue, DiagramAddComponentPreferencePage.this.maxInputValue, DiagramAddComponentPreferencePage.this.maxOutputValue, DiagramAddComponentPreferencePage.this.minInputValue, DiagramAddComponentPreferencePage.this.minOutputValue};
                boolean areValuesValid = DiagramAddComponentPreferencePage.this.validate();
                if (areValuesValid) {
                    DiagramAddComponentPreferencePage.this.copyIcons(DiagramAddComponentPreferencePage.this.graphIconValue);
                    DiagramAddComponentPreferencePage.this.createNewComponentFile(params);
                    DiagramAddComponentPreferencePage.this.initializeContents();
                    DiagramAddComponentPreferencePage.this.dialogShell.close();
                }
            }
        });
        cancelButton = new Button((Composite)dialog, 8);
        cancelButton.setText("   Cancel  ");
        cancelButton.setLayoutData((Object)buttonGrid);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DiagramAddComponentPreferencePage.this.dialogShell.close();
            }
        });
    }

    protected final boolean validate() {
        boolean valid = true;
        Color notEmptyFieldColor = new Color(null, 255, 255, 255);
        Color emptyFieldColor = new Color(null, 245, 222, 219);
        Text[] dialogTextFields = new Text[]{this.componentName, this.installComponentName, this.installComponentZip, this.graphIcon, this.componentNamespace, this.maxInput, this.minInput, this.maxOutput, this.minOutput};
        Combo[] dialogComboFields = new Combo[]{this.componentType, this.esb};
        int i = 0;
        while (i < dialogTextFields.length) {
            Text textField = dialogTextFields[i];
            if (textField.getText().compareTo("") == 0) {
                valid = false;
                textField.setBackground(emptyFieldColor);
            } else {
                textField.setBackground(notEmptyFieldColor);
            }
            ++i;
        }
        int j = 0;
        while (j < dialogComboFields.length) {
            Combo comboField = dialogComboFields[j];
            if (comboField.getText().compareTo("") == 0) {
                valid = false;
                comboField.setBackground(emptyFieldColor);
            } else {
                comboField.setBackground(notEmptyFieldColor);
            }
            ++j;
        }
        return valid;
    }

    private void createTextFields(Group componentInfos) {
        GridData basicFieldGrid = new GridData(768);
        basicFieldGrid.horizontalSpan = 2;
        new Label((Composite)componentInfos, 0).setText("Component Name :");
        this.componentName = new Text((Composite)componentInfos, 2052);
        this.componentName.setLayoutData((Object)basicFieldGrid);
        this.componentName.setToolTipText("This is the name of the component which will appear as your tool name");
        new Label((Composite)componentInfos, 0x1000008).setText("Component type :");
        this.componentType = new Combo((Composite)componentInfos, 2052);
        this.componentType.setItems(new String[]{"Binding Component", "Service Engine"});
        this.componentType.setLayoutData((Object)basicFieldGrid);
        this.componentName.setToolTipText("This is the type of the component, which could only be binding component or service engine");
        new Label((Composite)componentInfos, 0x1000008).setText("ESB :");
        this.esb = new Combo((Composite)componentInfos, 2052);
        Vector esbList = cimero2Factory.eINSTANCE.getEsbList();
        String[] esbs = new String[esbList.size()];
        int i = 0;
        while (i < esbList.size()) {
            esbs[i] = ((ESB)esbList.get(i)).getName();
            ++i;
        }
        this.esb.setItems(esbs);
        this.esb.setLayoutData((Object)basicFieldGrid);
        this.esb.setToolTipText("This is the ESB on which this component could be deploy");
        new Label((Composite)componentInfos, 0).setText("Install Component Name (Use in the SA) :");
        this.installComponentName = new Text((Composite)componentInfos, 2052);
        this.installComponentName.setLayoutData((Object)basicFieldGrid);
        this.installComponentName.setToolTipText("This is the name use in the SA to reference the install-component that could be installed to allow this component to be deployed correctly");
        new Label((Composite)componentInfos, 0x1000008).setText("Zip file to install to use this component :");
        this.installComponentZip = new Text((Composite)componentInfos, 2052);
        this.installComponentZip.setLayoutData((Object)basicFieldGrid);
        this.installComponentZip.setToolTipText("This is the Zip name ofthe install-component that must be installed to allow this component to deployed correctly");
        new Label((Composite)componentInfos, 0x1000008).setText("Icon use to represent the component :");
        this.graphIcon = new Text((Composite)componentInfos, 2052);
        GridData longTextGrid = new GridData(1);
        longTextGrid.grabExcessHorizontalSpace = true;
        this.graphIcon.setLayoutData((Object)longTextGrid);
        Button browse2 = new Button((Composite)componentInfos, 8);
        browse2.setText("Browse...");
        browse2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String fileName = new FileDialog(DiagramAddComponentPreferencePage.this.getShell()).open();
                if (fileName != null) {
                    DiagramAddComponentPreferencePage.this.graphIcon.setText(fileName);
                }
            }
        });
        this.graphIcon.setToolTipText("This is the image that will be usedas the component representation on the tool bar and on the diagram");
        new Label((Composite)componentInfos, 0x1000008).setText("Component namespace :");
        this.componentNamespace = new Text((Composite)componentInfos, 2052);
        this.componentNamespace.setLayoutData((Object)basicFieldGrid);
        this.componentNamespace.setToolTipText("This is the namespace of the component. Like http://servicemix.apache.org/saxon/1.0, for the servicemix saxon");
        new Label((Composite)componentInfos, 0x1000008).setText("Maximum input connection allowed :");
        this.maxInput = new Text((Composite)componentInfos, 2052);
        this.maxInput.setLayoutData((Object)basicFieldGrid);
        this.maxInput.setToolTipText("This is the maximum input connections that the component allowed");
        new Label((Composite)componentInfos, 0x1000008).setText("Minimum input connection required :");
        this.minInput = new Text((Composite)componentInfos, 2052);
        this.minInput.setLayoutData((Object)basicFieldGrid);
        this.minInput.setToolTipText("This is the minimum input connections that are required");
        new Label((Composite)componentInfos, 0x1000008).setText("Maximum output connection allowed :");
        this.maxOutput = new Text((Composite)componentInfos, 2052);
        this.maxOutput.setLayoutData((Object)basicFieldGrid);
        this.maxInput.setToolTipText("This is the maximum output connections that the component allowed");
        new Label((Composite)componentInfos, 0x1000008).setText("Minimum output connection required :");
        this.minOutput = new Text((Composite)componentInfos, 2052);
        this.minOutput.setLayoutData((Object)basicFieldGrid);
        this.minInput.setToolTipText("This is the minimum output connections that are required");
    }

    private void componentVariableSelected(ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.editVariable.setEnabled(this.validateEdit(ssel, false));
    }

    private void editComponent(ISelection selection) {
        IStructuredSelection ssel;
        ComponentVariableEntry entry = null;
        if (selection instanceof IStructuredSelection && !(ssel = (IStructuredSelection)selection).isEmpty()) {
            entry = (ComponentVariableEntry)ssel.getFirstElement();
        }
        if (entry != null) {
            File componentFile = new File(entry.getFileName());
            this.openFile(componentFile);
        } else {
            LoggerTool.logger.severe("Bad entry");
        }
    }

    private void openFile(File componentFile) {
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(componentFile.getAbsolutePath()));
        if (!fileStore.fetchInfo().isDirectory() && fileStore.fetchInfo().exists()) {
            IWorkbenchPage iWorkbenchPage;
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
            IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
            if (iWorkbenchWindow != null && (iWorkbenchPage = iWorkbenchWindow.getActivePage()) != null) {
                try {
                    IDE.openEditorOnFileStore((IWorkbenchPage)iWorkbenchPage, (IFileStore)fileStore);
                }
                catch (PartInitException partInitException) {
                    LoggerTool.logger.severe("Error when trying to open the file");
                }
            }
        } else {
            LoggerTool.logger.severe("The file" + fileStore + "can't be openned");
        }
    }

    private boolean validateEdit(IStructuredSelection selection, boolean showError) {
        return !selection.isEmpty();
    }

    private void initializeContents() {
        this.setMessage(null);
        HashSet<ComponentVariableEntry> allVariables = new HashSet<ComponentVariableEntry>();
        try {
            ArrayList componentModelFiles = Parser.scanDir((String)(String.valueOf(Cimero2EditorPlugin.cimeroDirPath) + File.separator + "componentModel"));
            int i = 0;
            while (i < componentModelFiles.size()) {
                String componentModelName = Parser.getComponentModelAttributeFromFile((String)((String)componentModelFiles.get(i)), (String)"component-name");
                if (Parser.getComponentModelAttributeFromFile((String)((String)componentModelFiles.get(i)), (String)"esb") != null && componentModelName != null && this.currentEsb.compareTo(Parser.getComponentModelAttributeFromFile((String)((String)componentModelFiles.get(i)), (String)"esb")) == 0) {
                    ComponentVariableEntry entry = new ComponentVariableEntry(componentModelName, (String)componentModelFiles.get(i));
                    allVariables.add(entry);
                }
                ++i;
            }
        }
        catch (IOException e) {
            LoggerTool.logger.warning("No cimero directory to scan, all your components data where maybe lost" + e.getStackTrace().toString());
        }
        this.componentsVariables.setInput(allVariables);
        this.editVariable.setEnabled(false);
    }

    public final void init(IWorkbench workbench) {
        Vector esbList = cimero2Factory.eINSTANCE.getEsbList();
        int i = 0;
        while (i < esbList.size()) {
            String esbName;
            DiagramAddComponentPreferencePage.esbs[i] = esbName = ((ESB)esbList.get(i)).getName();
            ++i;
        }
        this.currentEsb = esbs[0];
    }

    public final void handleEvent(Event event) {
        switch (event.type) {
            case 13: {
                this.setSelectedEsb();
                this.initializeContents();
                break;
            }
        }
    }

    private void setSelectedEsb() {
        boolean found = false;
        int i = 0;
        while (i < this.esbButtons.length && !found) {
            if (this.esbButtons[i].getSelection()) {
                found = true;
                this.currentEsb = this.esbButtons[i].getText();
            }
            ++i;
        }
    }

    private void copyIcons(String graphIcon) {
        String graphFileName = Cimero2EditorPlugin.findTheFileNameInAPath((String)graphIcon);
        new File(graphIcon);
        File dest = new File(String.valueOf(Cimero2EditorPlugin.cimeroIconsDirPath) + File.separator + graphFileName);
        try {
            dest.createNewFile();
        }
        catch (IOException e) {
            LoggerTool.logger.severe("Error when trying to create a copy of " + graphFileName + e.getMessage());
        }
        Image graphImage = this.resizeImage(graphIcon, 82, 50);
        this.saveImage(dest.getPath(), graphImage);
        dest = new File(String.valueOf(Cimero2EditorPlugin.cimeroIconsDirPath) + File.separator + "ico_" + graphFileName);
        Image paletteImage = this.resizeImage(graphIcon, 31, 19);
        this.saveImage(dest.getPath(), paletteImage);
    }

    private void saveImage(String imagePath, Image resizedImage) {
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{resizedImage.getImageData()};
        imageLoader.save(imagePath, 5);
    }

    private Image resizeImage(String img, int width, int height) {
        Image image = new Image(null, img);
        ImageData data = image.getImageData();
        ImageData resizeImageData = data.scaledTo(width, height);
        Image resizedImage = new Image(null, resizeImageData);
        return resizedImage;
    }

    private void createNewComponentFile(String[] params) {
        String fileName = params[0].toLowerCase();
        if (params[1].compareTo("ServiceMix") == 0) {
            fileName = "servicemix-" + fileName;
        } else if (params[1].compareTo("Petals") == 0) {
            fileName = String.valueOf(fileName) + "PetalsComponent";
        }
        String createdModelFile = String.valueOf(Cimero2EditorPlugin.cimeroComponentModelDirPath) + File.separator + fileName + ".xml";
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(createdModelFile));
            String generatedText = Coordinateur.COORDINATEUR_INSTANCE.generateComponentXMLModel(params);
            out.write(generatedText);
            out.close();
            LoggerTool.logger.info("XML model generation sucessfull");
        }
        catch (IOException e) {
            e.printStackTrace();
            LoggerTool.logger.info("XML model generation failed");
        }
    }

    public final Shell getDialogShell() {
        return this.dialogShell;
    }

    private static class ComponentVariableContentProvider
    implements IStructuredContentProvider {
        private Set<ComponentVariableEntry> entries = new HashSet<ComponentVariableEntry>();
        private TableViewer table;

        ComponentVariableContentProvider() {
        }

        void add(ComponentVariableEntry entry) {
            if (!this.entries.contains(entry)) {
                this.entries.add(entry);
                this.table.add((Object)entry);
            }
        }

        void remove(ComponentVariableEntry entry) {
            if (this.entries.contains(entry)) {
                this.entries.remove(entry);
                this.table.remove((Object)entry);
            }
        }

        public Object[] getElements(Object inputElement) {
            return this.entries.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.entries = (Set)newInput;
            this.table = (TableViewer)viewer;
        }

        public void dispose() {
        }
    }

    private static final class ComponentVariableEntry {
        private String name;
        private String fileName;

        ComponentVariableEntry(String componentName, String componentFileName) {
            this.name = componentName;
            this.fileName = componentFileName;
        }

        String getName() {
            return this.name;
        }

        String getFileName() {
            return this.fileName;
        }
    }

    private static class ComponentVariableLabelProvider
    implements ITableLabelProvider,
    IColorProvider {
        ComponentVariableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            ComponentVariableEntry entry = (ComponentVariableEntry)element;
            return NLS.bind((String)entry.getName(), (Object)entry.getName());
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ComponentVariableEntry entry = (ComponentVariableEntry)element;
            String imageName = Parser.getComponentPictureFromFile((String)entry.fileName);
            Image img = this.getIconImage(imageName);
            return img;
        }

        public final Image getIconImage(String imageName) {
            Image img = null;
            ImageDescriptor imgDescr = this.getImageDescriptor("ico_" + imageName + ".jpg");
            File imageFile = new File(String.valueOf(Cimero2EditorPlugin.cimeroDirPath) + File.separator + "icons" + File.separator + "ico_" + imageName);
            if (imgDescr == null && imageFile.exists()) {
                Image image;
                img = image = new Image(null, imageFile.getPath());
            } else if (imgDescr == null && !imageFile.exists()) {
                imgDescr = this.getImageDescriptor("ico_NotFound.jpg");
            } else {
                img = imgDescr.createImage();
            }
            return img;
        }

        public final ImageDescriptor getImageDescriptor(String imageName) {
            ImageDescriptor imageDesc = Cimero2EditorDiagramEditorPlugin.getBundledImageDescriptor("icons/obj16/" + imageName);
            return imageDesc;
        }
    }
}

