/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentInstanceProperty;
import org.eclipse.stp.eid.datamodel.Container;
import org.eclipse.stp.eid.datamodel.Namespace;
import org.eclipse.stp.eid.datamodel.Property;
import org.eclipse.stp.eid.datamodel.cimero2Factory;
import org.eclipse.stp.eid.datamodel.desccriptor.MyComboBoxPropertyDescriptor;
import org.eclipse.stp.eid.datamodel.desccriptor.MyTextPropertyDescriptor;
import org.eclipse.stp.eid.datamodel.provider.MyPropertiesPropertySource;
import org.eclipse.stp.eid.datamodel.provider.PropertyDescriptorProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyComponentInstancePropertySource
implements IPropertySource {
    private ComponentInstance componentInstance;
    private transient List<IPropertyDescriptor> descriptorList = new ArrayList<IPropertyDescriptor>();
    private Map<String, Object> simplePropertiesMap = new HashMap<String, Object>();
    private Map<String, Object> complexPropertiesMap = new HashMap<String, Object>();
    private String[] unrequiredBooleanValues = new String[]{"", "true", "false"};
    private Map<String, String[]> comboMap = new HashMap<String, String[]>();
    private int propertyNumber = 1;
    private static int MAX_INDICE = 10;
    private static String containerId = "CONTAINER";
    private static String nameId = "NAME";

    public MyComponentInstancePropertySource(Object componentInstance) {
        this.componentInstance = (ComponentInstance)componentInstance;
        String componentName = this.componentInstance.getName();
        if (componentName == null) {
            componentName = "";
        }
        if (!this.simplePropertiesMap.containsKey(nameId)) {
            this.simplePropertiesMap.put(nameId, componentName);
        }
        if (!this.simplePropertiesMap.containsKey(containerId)) {
            this.comboMap.put(containerId, PropertyDescriptorProvider.getContainerNameList((EList<Container>)this.componentInstance.getGraph().getContainers()));
            Container container = this.componentInstance.getContainer();
            String value = null;
            if (container != null) {
                value = this.componentInstance.getContainer().getId();
            }
            this.simplePropertiesMap.put(containerId, this.getIndice(containerId, value));
        }
        int i = 0;
        while (i < this.componentInstance.getProperties().size()) {
            ComponentInstanceProperty currentProperty = (ComponentInstanceProperty)this.componentInstance.getProperties().get(i);
            String propertyName = String.valueOf(currentProperty.getModel().getPropertyModelId()) + currentProperty.getName();
            if (currentProperty.getSubProperties().size() == 0 && !this.simplePropertiesMap.containsKey(propertyName)) {
                if (currentProperty.getModel().getType().compareTo("Boolean") == 0) {
                    this.comboMap.put(propertyName, this.unrequiredBooleanValues);
                    this.simplePropertiesMap.put(propertyName, this.getIndice(propertyName, currentProperty.getValue()));
                }
                if (((ComponentInstanceProperty)this.componentInstance.getProperties().get(i)).getModel().getType().compareTo("Namespace") == 0) {
                    this.comboMap.put(propertyName, PropertyDescriptorProvider.getNamespacePrefixList((EList<Namespace>)this.componentInstance.getGraph().getNamespaces()));
                    this.simplePropertiesMap.put(propertyName, this.getIndice(propertyName, ((ComponentInstanceProperty)this.componentInstance.getProperties().get(i)).getValue()));
                } else if (currentProperty.getModel().getAuthorizedValues().size() > 0) {
                    this.comboMap.put(propertyName, (String[])currentProperty.getModel().getAuthorizedValues().toArray());
                    this.simplePropertiesMap.put(propertyName, this.getIndice(propertyName, currentProperty.getValue()));
                } else {
                    this.simplePropertiesMap.put(propertyName, currentProperty.getValue());
                }
            } else {
                this.complexPropertiesMap.put(propertyName, this.componentInstance.getProperties().get(i));
            }
            ++i;
        }
    }

    private Object getIndice(String propertyName, String value) {
        if (value != null && propertyName != null) {
            String[] values = this.comboMap.get(propertyName);
            int i = 0;
            while (i < values.length) {
                if (values[i].compareTo(value) == 0) {
                    return new Integer(i);
                }
                ++i;
            }
        }
        return new Integer(0);
    }

    public final Object getEditableValue() {
        return this;
    }

    public final IPropertyDescriptor[] getPropertyDescriptors() {
        Object descr = new MyTextPropertyDescriptor("NAME", "0" + this.propertyNumber + "- " + "name", null);
        descr.setCategory("Component");
        descr.setDescription("Component name");
        this.descriptorList.add((IPropertyDescriptor)descr);
        ++this.propertyNumber;
        descr = new MyComboBoxPropertyDescriptor(containerId, "0" + this.propertyNumber + "- " + "Container", PropertyDescriptorProvider.getContainerNameList((EList<Container>)this.componentInstance.getGraph().getContainers()), null);
        ((MyComboBoxPropertyDescriptor)((Object)descr)).setCategory("Component");
        ((MyComboBoxPropertyDescriptor)((Object)descr)).setDescription("The container of this component");
        this.descriptorList.add((IPropertyDescriptor)descr);
        ++this.propertyNumber;
        this.getSimplePropertyDescriptors();
        this.getComplexPropertyDescriptors();
        IPropertyDescriptor[] myDescTable = new IPropertyDescriptor[this.descriptorList.size()];
        int indice = 0;
        for (IPropertyDescriptor it : this.descriptorList) {
            myDescTable[indice++] = it;
        }
        return myDescTable;
    }

    private void getComplexPropertyDescriptors() {
        ArrayList<String> repeatableProperties = new ArrayList<String>();
        List<ComponentInstanceProperty> properties = this.getComplexProperties();
        int i = 0;
        while (i < properties.size()) {
            ComponentInstanceProperty currentComplexSubProperty = properties.get(i);
            if (currentComplexSubProperty.isValidPropertyForCurrentRole()) {
                IPropertyDescriptor descr;
                String propertyName = String.valueOf(currentComplexSubProperty.getModel().getPropertyModelId()) + currentComplexSubProperty.getName();
                ++this.propertyNumber;
                String propertyLabel = String.valueOf(this.propertyNumber) + "- " + currentComplexSubProperty.getModel().getName();
                if (this.propertyNumber < MAX_INDICE) {
                    propertyLabel = "0" + propertyLabel;
                }
                if (!currentComplexSubProperty.getModel().isRepeatable()) {
                    descr = PropertyDescriptorProvider.createDescriptor(propertyName, propertyLabel, currentComplexSubProperty);
                } else if (!repeatableProperties.contains(currentComplexSubProperty.getModel().getName())) {
                    descr = PropertyDescriptorProvider.createRepeatableAddDescriptor(propertyName, propertyLabel, currentComplexSubProperty);
                    repeatableProperties.add(currentComplexSubProperty.getModel().getName());
                } else {
                    descr = PropertyDescriptorProvider.createRepeatableDeleteDescriptor(propertyName, propertyLabel, currentComplexSubProperty);
                }
                this.descriptorList.add(descr);
            }
            ++i;
        }
    }

    private void getSimplePropertyDescriptors() {
        ArrayList<String> repeatableProperties = new ArrayList<String>();
        List<ComponentInstanceProperty> properties = this.getSimpleProperties();
        int i = 0;
        while (i < properties.size()) {
            ComponentInstanceProperty currentSubProperty = properties.get(i);
            String propertyName = String.valueOf(currentSubProperty.getModel().getPropertyModelId()) + currentSubProperty.getName();
            if (currentSubProperty.isValidPropertyForCurrentRole()) {
                IPropertyDescriptor descr;
                ++this.propertyNumber;
                String propertyLabel = String.valueOf(this.propertyNumber) + "- " + currentSubProperty.getModel().getName();
                if (this.propertyNumber < MAX_INDICE) {
                    propertyLabel = "0" + propertyLabel;
                }
                if (currentSubProperty.getModel().isRepeatable()) {
                    IPropertyDescriptor repetableDescr;
                    String repeatablePropertyLabel = null;
                    if (!repeatableProperties.contains(currentSubProperty.getModel().getName())) {
                        repeatablePropertyLabel = String.valueOf(this.propertyNumber) + "- Add a new " + currentSubProperty.getModel().getName();
                        if (this.propertyNumber < MAX_INDICE) {
                            repeatablePropertyLabel = "0" + repeatablePropertyLabel;
                        }
                        repetableDescr = PropertyDescriptorProvider.createRepeatableAddDescriptor(repeatablePropertyLabel, repeatablePropertyLabel, currentSubProperty);
                        this.descriptorList.add(repetableDescr);
                        repeatableProperties.add(currentSubProperty.getModel().getName());
                    } else {
                        repeatablePropertyLabel = String.valueOf(this.propertyNumber) + "- Delete the next " + currentSubProperty.getModel().getName() + " property";
                        if (this.propertyNumber < MAX_INDICE) {
                            repeatablePropertyLabel = "0" + repeatablePropertyLabel;
                        }
                        repetableDescr = PropertyDescriptorProvider.createRepeatableDeleteDescriptor(repeatablePropertyLabel, repeatablePropertyLabel, currentSubProperty);
                        this.descriptorList.add(repetableDescr);
                    }
                    ++this.propertyNumber;
                }
                if (currentSubProperty.isBoolean(false)) {
                    String[] booleanValues = (String[])this.unrequiredBooleanValues.clone();
                    descr = PropertyDescriptorProvider.createComboDescriptor(propertyName, propertyLabel, booleanValues, currentSubProperty);
                } else {
                    descr = currentSubProperty.getModel().getAuthorizedValues().size() > 0 ? PropertyDescriptorProvider.createComboDescriptor(propertyName, propertyLabel, this.comboMap.get(propertyName), currentSubProperty) : (currentSubProperty.isRole(false) || currentSubProperty.getConnection() != null || currentSubProperty.isUnsettable() ? PropertyDescriptorProvider.createUnsettableDescriptor(propertyName, propertyLabel, currentSubProperty) : PropertyDescriptorProvider.createTextDescriptor(propertyName, propertyLabel, currentSubProperty));
                }
                this.descriptorList.add(descr);
            }
            ++i;
        }
    }

    public final Object getPropertyValue(Object id) {
        if (this.simplePropertiesMap.containsKey(id)) {
            return this.simplePropertiesMap.get(id);
        }
        if (this.complexPropertiesMap.containsKey(id)) {
            return new MyPropertiesPropertySource(this.complexPropertiesMap.get(id), this.componentInstance);
        }
        return null;
    }

    public final boolean isPropertySet(Object id) {
        return this.simplePropertiesMap.containsKey(id) || this.complexPropertiesMap.containsKey(id);
    }

    public final void resetPropertyValue(Object id) {
    }

    public final void setPropertyValue(Object id, Object value) {
        String[] values = this.comboMap.get(id);
        if (nameId.compareTo((String)id) == 0) {
            this.componentInstance.setName((String)value);
        } else if (containerId.compareTo((String)id) == 0) {
            this.componentInstance.setContainer(cimero2Factory.eINSTANCE.getContainerById(values[(Integer)value], this.componentInstance.getGraph()));
        } else if (this.simplePropertiesMap.containsKey(id)) {
            int i = 0;
            while (i < this.componentInstance.getProperties().size()) {
                ComponentInstanceProperty subProperty = (ComponentInstanceProperty)this.componentInstance.getProperties().get(i);
                String propertyName = String.valueOf(subProperty.getModel().getPropertyModelId()) + subProperty.getName();
                if (propertyName.compareTo((String)id) == 0) {
                    if (subProperty.getModel().getAuthorizedValues().size() > 0 || subProperty.getModel().getType().compareTo("Boolean") == 0 || subProperty.getModel().getType().compareTo("Namespace") == 0) {
                        subProperty.setValue(values[(Integer)value]);
                    } else {
                        subProperty.setValue((String)value);
                    }
                    if (subProperty.isMEP(false)) {
                        PropertyDescriptorProvider.notifyConnectionMEPChanged(values[(Integer)value], this.componentInstance);
                    }
                    if (subProperty.isService(false) || subProperty.isEndPoint(false) || subProperty.isInterface(false)) {
                        String newReferenceName = null;
                        if (subProperty.isService(false) || subProperty.isInterface(false)) {
                            String prefix = "";
                            if (((Property)subProperty.getSubProperties().get(0)).getValue().compareTo("") != 0) {
                                prefix = String.valueOf(((Property)subProperty.getSubProperties().get(0)).getValue()) + ":";
                            }
                            newReferenceName = String.valueOf(prefix) + ((Property)subProperty.getSubProperties().get(1)).getValue();
                            PropertyDescriptorProvider.notifySourceReferenceToExternalComponentChanged(newReferenceName, subProperty.getModel().getType(), this.componentInstance);
                        } else {
                            newReferenceName = subProperty.getValue();
                            PropertyDescriptorProvider.notifySourceReferenceToExternalComponentChanged(newReferenceName, subProperty.getModel().getType(), this.componentInstance);
                        }
                    }
                }
                ++i;
            }
        }
        if (this.simplePropertiesMap.containsKey(id)) {
            this.simplePropertiesMap.remove(id);
        }
        this.simplePropertiesMap.put((String)id, value);
    }

    private List<ComponentInstanceProperty> getSimpleProperties() {
        ArrayList<ComponentInstanceProperty> simpleProperties = new ArrayList<ComponentInstanceProperty>();
        EList properties = this.componentInstance.getProperties();
        int i = 0;
        while (i < properties.size()) {
            if (((ComponentInstanceProperty)properties.get(i)).getSubProperties().size() == 0) {
                simpleProperties.add((ComponentInstanceProperty)properties.get(i));
            }
            ++i;
        }
        return simpleProperties;
    }

    private List<ComponentInstanceProperty> getComplexProperties() {
        ArrayList<ComponentInstanceProperty> complexProperties = new ArrayList<ComponentInstanceProperty>();
        EList properties = this.componentInstance.getProperties();
        int i = 0;
        while (i < properties.size()) {
            if (((ComponentInstanceProperty)properties.get(i)).getSubProperties().size() > 0) {
                complexProperties.add((ComponentInstanceProperty)properties.get(i));
            }
            ++i;
        }
        return complexProperties;
    }
}

