/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentInstanceProperty;
import org.eclipse.stp.eid.datamodel.Connection;
import org.eclipse.stp.eid.datamodel.MEPType;
import org.eclipse.stp.eid.datamodel.Namespace;
import org.eclipse.stp.eid.datamodel.Property;
import org.eclipse.stp.eid.datamodel.PropertyModel;
import org.eclipse.stp.eid.datamodel.provider.PropertyDescriptorProvider;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyPropertiesPropertySource
implements IPropertySource {
    private ComponentInstanceProperty property;
    private ComponentInstance componentInstance;
    private transient List<IPropertyDescriptor> descriptorList = null;
    private Map<String, Object> simplePropertiesMap = new HashMap<String, Object>();
    private Map<String, Object> complexPropertiesMap = new HashMap<String, Object>();
    private String[] unrequiredBooleanValues = new String[]{"", "true", "false"};
    private Map<String, String[]> comboMap = new HashMap<String, String[]>();
    private int propertyNumber = 0;
    private static int MAX_INDICE = 10;

    public MyPropertiesPropertySource(Object property, ComponentInstance componentInstance) {
        this.property = (ComponentInstanceProperty)property;
        this.componentInstance = componentInstance;
        if (!this.property.isUnsettable()) {
            if (this.property.isBoolean(false)) {
                this.comboMap.put(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), this.unrequiredBooleanValues);
                this.simplePropertiesMap.put(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), this.getIndice(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), this.property.getValue()));
            } else if (this.property.isNamespace()) {
                this.comboMap.put(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), PropertyDescriptorProvider.getNamespacePrefixList((EList<Namespace>)this.property.getGraph().getNamespaces()));
                this.simplePropertiesMap.put(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), this.getIndice(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), this.property.getValue()));
            } else if (this.property.isMEP(false)) {
                if (this.property.getComponentInstance().getSourceConnections().size() == 0) {
                    this.comboMap.put(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), (String[])this.property.getModel().getAuthorizedValues().toArray());
                } else {
                    String[] allowedValues = this.intersection((EList<Connection>)this.property.getComponentInstance().getSourceConnections(), (EList<String>)this.property.getModel().getAuthorizedValues());
                    this.comboMap.put(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), allowedValues);
                }
                this.simplePropertiesMap.put(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), this.getIndice(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), this.property.getValue()));
            } else if (this.property.getModel().getAuthorizedValues().size() > 0) {
                this.comboMap.put(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), (String[])this.property.getModel().getAuthorizedValues().toArray((Object[])new String[this.property.getModel().getAuthorizedValues().size()]));
                this.simplePropertiesMap.put(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), this.getIndice(String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName(), this.property.getValue()));
            }
        }
        int i = 0;
        while (i < this.property.getSimpleSubProperties().size()) {
            ComponentInstanceProperty subProperty = (ComponentInstanceProperty)this.property.getSimpleSubProperties().get(i);
            String propertyName = String.valueOf(((ComponentInstanceProperty)this.property.getSimpleSubProperties().get(i)).getModel().getPropertyModelId()) + ((ComponentInstanceProperty)this.property.getSimpleSubProperties().get(i)).getName();
            if (subProperty.isBoolean(false)) {
                this.comboMap.put(propertyName, this.unrequiredBooleanValues);
                this.simplePropertiesMap.put(propertyName, this.getIndice(propertyName, subProperty.getValue()));
            } else if (subProperty.isNamespace()) {
                this.comboMap.put(propertyName, PropertyDescriptorProvider.getNamespacePrefixList((EList<Namespace>)this.property.getGraph().getNamespaces()));
                this.simplePropertiesMap.put(propertyName, this.getIndice(propertyName, subProperty.getValue()));
            } else if (subProperty.isMEP(false)) {
                if (this.property.getComponentInstance().getSourceConnections().size() == 0) {
                    this.comboMap.put(propertyName, (String[])subProperty.getModel().getAuthorizedValues().toArray());
                } else {
                    String[] allowedValues = this.intersection((EList<Connection>)this.property.getComponentInstance().getSourceConnections(), (EList<String>)subProperty.getModel().getAuthorizedValues());
                    this.comboMap.put(propertyName, allowedValues);
                }
                this.simplePropertiesMap.put(propertyName, this.getIndice(propertyName, subProperty.getValue()));
            } else if (subProperty.getModel().getAuthorizedValues().size() > 0) {
                this.comboMap.put(propertyName, (String[])subProperty.getModel().getAuthorizedValues().toArray((Object[])new String[subProperty.getModel().getAuthorizedValues().size()]));
                this.simplePropertiesMap.put(propertyName, this.getIndice(propertyName, subProperty.getValue()));
            } else {
                this.simplePropertiesMap.put(propertyName, subProperty.getValue());
            }
            ++i;
        }
        i = 0;
        while (i < this.property.getComplexSubProperties().size()) {
            String propertyName = String.valueOf(((ComponentInstanceProperty)this.property.getComplexSubProperties().get(i)).getModel().getPropertyModelId()) + ((ComponentInstanceProperty)this.property.getComplexSubProperties().get(i)).getName();
            this.complexPropertiesMap.put(propertyName, this.property.getComplexSubProperties().get(i));
            ++i;
        }
    }

    private String[] intersection(EList<Connection> list, EList<String> list2) {
        if (list != null && list2 != null) {
            Object intersection = list2;
            ArrayList<String> restrictedInputMEPSetString = null;
            int i = 0;
            while (i < list.size()) {
                EList restrictedInputMEPSet = ((Connection)list.get(i)).getTarget().getModel().getRestrictedInputMEPSet();
                restrictedInputMEPSetString = new ArrayList<String>();
                int j = 0;
                while (j < restrictedInputMEPSet.size()) {
                    restrictedInputMEPSetString.add(((MEPType)restrictedInputMEPSet.get(j)).getLiteral());
                    ++j;
                }
                if (restrictedInputMEPSetString.size() > 0) {
                    intersection = this.intersection((List<String>)restrictedInputMEPSetString, (List<String>)intersection);
                }
                ++i;
            }
            return intersection.toArray((String[])new String[intersection.size()]);
        }
        return null;
    }

    private List<String> intersection(List<String> list, List<String> list2) {
        ArrayList<String> intersection = new ArrayList<String>();
        intersection.add("");
        int i = 0;
        while (i < list.size()) {
            int j = 0;
            while (j < list2.size()) {
                if (list.get(i).compareTo(list2.get(j)) == 0) {
                    intersection.add(list.get(i));
                }
                ++j;
            }
            ++i;
        }
        return intersection;
    }

    private Object getIndice(String propertyName, String value) {
        String[] values = this.comboMap.get(propertyName);
        int i = 0;
        while (i < values.length) {
            if (values[i].compareTo(value) == 0) {
                return new Integer(i);
            }
            ++i;
        }
        return new Integer(0);
    }

    public final Object getEditableValue() {
        return this;
    }

    public final IPropertyDescriptor[] getPropertyDescriptors() {
        this.descriptorList = new ArrayList<IPropertyDescriptor>();
        this.propertyNumber = 0;
        this.componentInstance.getRole();
        this.getSimplePropertyDescriptors();
        this.getComplexPropertyDescriptors();
        IPropertyDescriptor[] myDescTable = new IPropertyDescriptor[this.descriptorList.size()];
        int indice = 0;
        for (IPropertyDescriptor it : this.descriptorList) {
            myDescTable[indice++] = it;
        }
        return myDescTable;
    }

    private void getSimplePropertyDescriptors() {
        ArrayList<String> repeatableProperties = new ArrayList<String>();
        int i = 0;
        while (i < this.property.getSimpleSubProperties().size()) {
            ComponentInstanceProperty currentSubProperty = (ComponentInstanceProperty)this.property.getSimpleSubProperties().get(i);
            String propertyName = String.valueOf(currentSubProperty.getModel().getPropertyModelId()) + currentSubProperty.getName();
            if (currentSubProperty.isValidPropertyForCurrentRole()) {
                IPropertyDescriptor descr;
                ++this.propertyNumber;
                String propertyLabel = String.valueOf(this.propertyNumber) + "- " + currentSubProperty.getModel().getName();
                if (this.propertyNumber < MAX_INDICE) {
                    propertyLabel = "0" + propertyLabel;
                }
                if (currentSubProperty.getModel().isRepeatable()) {
                    IPropertyDescriptor repetableDescr;
                    String repeatablePropertyLabel = null;
                    if (!repeatableProperties.contains(currentSubProperty.getModel().getName())) {
                        repeatablePropertyLabel = String.valueOf(this.propertyNumber) + "- Add a new " + currentSubProperty.getModel().getName();
                        if (this.propertyNumber < MAX_INDICE) {
                            repeatablePropertyLabel = "0" + repeatablePropertyLabel;
                        }
                        repetableDescr = PropertyDescriptorProvider.createRepeatableAddDescriptor(repeatablePropertyLabel, repeatablePropertyLabel, currentSubProperty);
                        this.descriptorList.add(repetableDescr);
                        repeatableProperties.add(currentSubProperty.getModel().getName());
                    } else {
                        repeatablePropertyLabel = String.valueOf(this.propertyNumber) + "- Delete the next " + currentSubProperty.getModel().getName() + " property";
                        if (this.propertyNumber < MAX_INDICE) {
                            repeatablePropertyLabel = "0" + repeatablePropertyLabel;
                        }
                        repetableDescr = PropertyDescriptorProvider.createRepeatableDeleteDescriptor(repeatablePropertyLabel, repeatablePropertyLabel, currentSubProperty);
                        this.descriptorList.add(repetableDescr);
                    }
                    ++this.propertyNumber;
                }
                if (currentSubProperty.isBoolean(false)) {
                    String[] booleanValues = (String[])this.unrequiredBooleanValues.clone();
                    descr = PropertyDescriptorProvider.createComboDescriptor(propertyName, propertyLabel, booleanValues, currentSubProperty);
                } else if (currentSubProperty.isNamespace()) {
                    this.comboMap.put(currentSubProperty.getName(), PropertyDescriptorProvider.getNamespacePrefixList((EList<Namespace>)this.property.getGraph().getNamespaces()));
                    descr = PropertyDescriptorProvider.createComboDescriptor(propertyName, propertyLabel, PropertyDescriptorProvider.getNamespacePrefixList((EList<Namespace>)this.property.getGraph().getNamespaces()), this.property);
                } else {
                    descr = currentSubProperty.getModel().getAuthorizedValues().size() > 0 ? PropertyDescriptorProvider.createComboDescriptor(propertyName, propertyLabel, this.comboMap.get(propertyName), currentSubProperty) : (currentSubProperty.isRole(false) || currentSubProperty.getConnection() != null || currentSubProperty.isUnsettable() ? PropertyDescriptorProvider.createUnsettableDescriptor(propertyName, propertyLabel, currentSubProperty) : (currentSubProperty.isFile(false) || currentSubProperty.isURI(false) && currentSubProperty.getName().compareTo("location") == 0 && this.property.isClass(true) ? PropertyDescriptorProvider.createFileBrowsingDescriptor(propertyName, propertyLabel, currentSubProperty) : PropertyDescriptorProvider.createTextDescriptor(propertyName, propertyLabel, currentSubProperty)));
                }
                this.descriptorList.add(descr);
            }
            ++i;
        }
    }

    private void getComplexPropertyDescriptors() {
        ArrayList<String> repeatableProperties = new ArrayList<String>();
        int i = 0;
        while (i < this.property.getComplexSubProperties().size()) {
            ComponentInstanceProperty currentComplexSubProperty = (ComponentInstanceProperty)this.property.getComplexSubProperties().get(i);
            if (currentComplexSubProperty.isValidPropertyForCurrentRole()) {
                IPropertyDescriptor descr;
                String propertyName = String.valueOf(currentComplexSubProperty.getModel().getPropertyModelId()) + currentComplexSubProperty.getName();
                ++this.propertyNumber;
                String propertyLabel = String.valueOf(this.propertyNumber) + "- " + currentComplexSubProperty.getModel().getName();
                if (this.propertyNumber < MAX_INDICE) {
                    propertyLabel = "0" + propertyLabel;
                }
                if (!currentComplexSubProperty.getModel().isRepeatable()) {
                    descr = PropertyDescriptorProvider.createDescriptor(propertyName, propertyLabel, currentComplexSubProperty);
                } else if (!repeatableProperties.contains(currentComplexSubProperty.getModel().getName())) {
                    descr = PropertyDescriptorProvider.createRepeatableAddDescriptor(propertyName, propertyLabel, currentComplexSubProperty);
                    repeatableProperties.add(currentComplexSubProperty.getModel().getName());
                } else {
                    descr = PropertyDescriptorProvider.createRepeatableDeleteDescriptor(propertyName, propertyLabel, currentComplexSubProperty);
                }
                this.descriptorList.add(descr);
            }
            ++i;
        }
    }

    public final Object getPropertyValue(Object propName) {
        if (this.simplePropertiesMap.containsKey(propName)) {
            return this.simplePropertiesMap.get(propName);
        }
        if (this.complexPropertiesMap.containsKey(propName)) {
            return new MyPropertiesPropertySource(this.complexPropertiesMap.get(propName), this.componentInstance);
        }
        return null;
    }

    public final boolean isPropertySet(Object propName) {
        return this.simplePropertiesMap.containsKey(propName) || this.complexPropertiesMap.containsKey(propName);
    }

    public void resetPropertyValue(Object propName) {
    }

    public final void setPropertyValue(Object propName, Object value) {
        if (this.simplePropertiesMap.containsKey(propName)) {
            String[] values = this.comboMap.get(propName);
            int i = 0;
            while (i < this.property.getSimpleSubProperties().size()) {
                String propertyId = String.valueOf(((ComponentInstanceProperty)this.property.getSimpleSubProperties().get(i)).getModel().getPropertyModelId()) + ((ComponentInstanceProperty)this.property.getSimpleSubProperties().get(i)).getName();
                if (propertyId.compareTo((String)propName) == 0) {
                    ComponentInstanceProperty subProperty = (ComponentInstanceProperty)this.property.getSimpleSubProperties().get(i);
                    PropertyModel subPropertyModel = subProperty.getModel();
                    if (subPropertyModel.getAuthorizedValues().size() > 0 || subProperty.isBoolean(false) || subProperty.isNamespace()) {
                        if (subProperty.isMyFatherValue()) {
                            this.property.getSuperProperty().setValue(values[(Integer)value]);
                        }
                        subProperty.setValue(values[(Integer)value]);
                    } else {
                        if (subProperty.isMyFatherValue()) {
                            this.property.setValue((String)value);
                        }
                        subProperty.setValue((String)value);
                    }
                    if (subProperty.isMEP(false)) {
                        PropertyDescriptorProvider.notifyConnectionMEPChanged(values[(Integer)value], this.componentInstance);
                    }
                    if (this.property.isService(false) || subProperty.isEndPoint(false) || this.property.isInterface(false)) {
                        String newReferenceName = null;
                        if (this.property.isService(false) || this.property.isInterface(false)) {
                            String prefix = "";
                            if (((Property)this.property.getSubProperties().get(0)).getValue().compareTo("") != 0) {
                                prefix = String.valueOf(((Property)this.property.getSubProperties().get(0)).getValue()) + ":";
                            }
                            newReferenceName = String.valueOf(prefix) + ((Property)this.property.getSubProperties().get(1)).getValue();
                            PropertyDescriptorProvider.notifySourceReferenceToExternalComponentChanged(newReferenceName, this.property.getModel().getType(), this.componentInstance);
                        } else {
                            newReferenceName = subProperty.getValue();
                            PropertyDescriptorProvider.notifySourceReferenceToExternalComponentChanged(newReferenceName, subProperty.getModel().getType(), this.componentInstance);
                        }
                    }
                }
                ++i;
            }
            String propertyId = String.valueOf(this.property.getModel().getPropertyModelId()) + this.property.getName();
            if (propertyId.compareTo((String)propName) == 0) {
                if (this.property.getModel().getAuthorizedValues().size() > 0 || this.property.isBoolean(false) || this.property.isNamespace()) {
                    if (this.property.getModel().getType().compareTo("MyFatherValue") == 0) {
                        this.property.getSuperProperty().setValue(values[(Integer)value]);
                    }
                    this.property.setValue(values[(Integer)value]);
                } else {
                    if (this.property.getModel().getType().compareTo("MyFatherValue") == 0) {
                        this.property.getSuperProperty().setValue((String)value);
                    }
                    this.property.setValue((String)value);
                }
            }
            if (this.simplePropertiesMap.containsKey(propName)) {
                this.simplePropertiesMap.remove(propName);
            }
            this.simplePropertiesMap.put((String)propName, value);
        }
    }
}

