/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jet.BodyContentWriter;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.JET2Template;
import org.eclipse.jet.JET2Writer;
import org.eclipse.stp.eid.datamodel.ComponentInstance;
import org.eclipse.stp.eid.datamodel.ComponentInstanceProperty;
import org.eclipse.stp.eid.datamodel.Container;
import org.eclipse.stp.eid.datamodel.Graph;
import org.eclipse.stp.eid.datamodel.Property;
import org.eclipse.stp.eid.datamodel.cimero2Factory;
import org.eclipse.stp.eid.datamodel.util.Cimero2EditorPlugin;
import org.eclipse.stp.eid.datamodel.util.LoggerTool;
import org.eclipse.stp.eid.generator.CimeroEditorGeneratorPlugin;
import org.eclipse.stp.eid.generator.Generator;
import org.eclipse.stp.eid.internal.generation.AntTaskGenerator;
import org.eclipse.stp.eid.internal.generation.JBIDescriptorGenerator;
import org.eclipse.stp.eid.internal.generation.PetalsGenerator;
import org.eclipse.stp.eid.internal.generation.PropertyGenerator;
import org.eclipse.stp.eid.internal.generation.ServicemixGenerator;
import org.eclipse.stp.eid.internal.generation.ServicemixScreenGenerator;
import org.eclipse.stp.eid.internal.generation.XmlModelGenerator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorImpl
implements Generator {
    private static String currentESB = null;
    private static final String NL = System.getProperty("line.separator");
    private static File jbiDirectory = null;
    private static String jarDirectory = "lib";
    private static File xbeanDirectory = null;
    private static File saDescriptorsDirectory = null;
    private static File buildedPackageDirectory = null;
    private ClassLoader classloader = this.getClass().getClassLoader();
    private Map<String, Object> commonVars = new HashMap<String, Object>();
    private File camelDirectory;
    private Map<String, JET2Template> templateGeneratorMap = new HashMap<String, JET2Template>();
    private IStatus camelStatus;
    private static List<ComponentInstanceProperty> componentInstanceProperties = null;

    public GeneratorImpl() {
        this.commonVars.put("EMFCOMMON", "org.eclipse.emf.common");
        this.commonVars.put("CIMEROEDITOR", Cimero2EditorPlugin.getPluginId());
        this.commonVars.put("CIMEROEDITORGENERATOR", CimeroEditorGeneratorPlugin.getPluginId());
        this.commonVars.put("EMFECORE", "org.eclipse.emf.ecore");
        this.commonVars.put("templateGeneratorMap", this.templateGeneratorMap);
    }

    @Override
    public boolean generateJbiPackage(Graph graph, Resource modelResource) {
        boolean generationComplete = false;
        LoggerTool.logger.info("Generating package ...............");
        EList componentInstanceList = graph.getComponents();
        int i = 0;
        while (i < componentInstanceList.size()) {
            BufferedWriter out;
            componentInstanceProperties = new ArrayList<ComponentInstanceProperty>();
            File suDir = new File(String.valueOf(xbeanDirectory.getAbsolutePath()) + File.separator + (((ComponentInstance)componentInstanceList.get(i)).getName() == null ? String.valueOf(((ComponentInstance)componentInstanceList.get(i)).getModel().getName()) + i : ((ComponentInstance)componentInstanceList.get(i)).getName()));
            ComponentInstance componentInstance = (ComponentInstance)componentInstanceList.get(i);
            currentESB = graph.getEsb(modelResource).getName();
            if (currentESB.compareTo("ServiceMix") == 0) {
                try {
                    String fileName = null;
                    Object jetmitter = null;
                    if (componentInstance.getModel().getName().compareTo("ScreenOutput") != 0) {
                        fileName = "xbean.xml";
                        jetmitter = new ServicemixGenerator();
                    } else {
                        fileName = "servicemix.xml";
                        jetmitter = new ServicemixScreenGenerator();
                    }
                    File xbeanFile = new File(String.valueOf(suDir.getAbsolutePath()) + File.separator + fileName);
                    if (xbeanFile.exists()) {
                        xbeanFile.delete();
                    }
                    out = new BufferedWriter(new FileWriter(String.valueOf(suDir.getAbsolutePath()) + File.separator + fileName));
                    int iProp = 0;
                    while (iProp < componentInstance.getProperties().size()) {
                        ComponentInstanceProperty property = this.cleanAndPrepare((ComponentInstanceProperty)componentInstance.getProperties().get(iProp), suDir);
                        if (property != null) {
                            componentInstanceProperties.add(property);
                        }
                        ++iProp;
                    }
                    JET2Context context = new JET2Context((Object)componentInstance, this.commonVars);
                    BodyContentWriter writer = new BodyContentWriter();
                    jetmitter.generate(context, (JET2Writer)writer);
                    out.write(writer.toString());
                    out.close();
                }
                catch (IOException e) {
                    LoggerTool.logger.severe("Unable to write the xbean.xml for the component " + (componentInstance.getName() == null ? componentInstance.getModel().getName() : componentInstance.getName()));
                    e.printStackTrace();
                }
            } else {
                try {
                    File META_INF = new File(String.valueOf(suDir.getAbsolutePath()) + File.separator + "META-INF");
                    if (META_INF.exists()) {
                        this.deleteDirectory(META_INF);
                    }
                    META_INF.mkdir();
                    out = new BufferedWriter(new FileWriter(String.valueOf(META_INF.getAbsolutePath()) + File.separator + "jbi.xml"));
                    int iProp = 0;
                    while (iProp < componentInstance.getProperties().size()) {
                        ComponentInstanceProperty property = this.cleanAndPrepare((ComponentInstanceProperty)componentInstance.getProperties().get(iProp), suDir);
                        if (property != null) {
                            componentInstanceProperties.add(property);
                        }
                        ++iProp;
                    }
                    PetalsGenerator generator = new PetalsGenerator();
                    JET2Context context = new JET2Context((Object)componentInstance, this.commonVars);
                    BodyContentWriter writer = new BodyContentWriter();
                    generator.generate(context, (JET2Writer)writer);
                    out.write(writer.toString());
                    out.close();
                }
                catch (IOException e) {
                    LoggerTool.logger.severe("Unable to write the jbi.xml for the component " + (componentInstance.getName() == null ? componentInstance.getModel().getName() : componentInstance.getName()));
                    e.printStackTrace();
                }
            }
            ++i;
        }
        return generationComplete;
    }

    private ComponentInstanceProperty cleanAndPrepare(ComponentInstanceProperty property, File suDir) {
        ComponentInstanceProperty newProperty = null;
        if (property.isValueSet() && property.isValidPropertyForCurrentRole()) {
            String propertyType = property.getModel().getType();
            if (propertyType.compareTo("XOR") == 0) {
                newProperty = this.cleanXOR(property, suDir);
            } else if (propertyType.compareTo("File") == 0) {
                newProperty = this.cleanFile(property, suDir);
            } else if (propertyType.compareTo("Service") == 0 || propertyType.compareTo("QName") == 0 || propertyType.compareTo("Interface") == 0) {
                newProperty = this.cleanServiceQNameInterface(property);
            } else if (propertyType.compareTo("MEP") == 0) {
                newProperty = this.cleanMEP(property);
            } else if (propertyType.compareTo("Role") == 0) {
                newProperty = this.cleanRole(property);
            } else if (propertyType.compareTo("Class") == 0) {
                newProperty = this.cleanClass(property, suDir);
            } else if (propertyType.compareTo("MyFatherValue") != 0) {
                newProperty = cimero2Factory.eINSTANCE.createComponentInstanceProperty();
                newProperty.setModel(property.getModel());
                newProperty.setName(property.getName());
                newProperty.setValue(property.getValue());
            }
            if (!(property.isQName(true) || property.isInterface(true) || property.isService(true) || property.isXOR() || property.isClass(true))) {
                int iprop = 0;
                while (iprop < property.getSubProperties().size()) {
                    ComponentInstanceProperty cleanedProperty = this.cleanAndPrepare((ComponentInstanceProperty)property.getSubProperties().get(iprop), suDir);
                    if (cleanedProperty != null) {
                        newProperty.getSubProperties().add((Object)cleanedProperty);
                    }
                    ++iprop;
                }
            }
        }
        return newProperty;
    }

    private ComponentInstanceProperty cleanClass(ComponentInstanceProperty property, File suDir) {
        ComponentInstanceProperty newProperty = cimero2Factory.eINSTANCE.createComponentInstanceProperty();
        File classSrc = null;
        File classDest = null;
        ComponentInstanceProperty location = null;
        boolean found = false;
        int i = 0;
        while (i < property.getSubProperties().size() && !found) {
            if (((Property)property.getSubProperties().get(i)).getName().compareTo("location") == 0) {
                found = true;
                location = (ComponentInstanceProperty)property.getSubProperties().get(i);
            }
            ++i;
        }
        ComponentInstanceProperty classProperty = null;
        boolean foundClass = false;
        int i2 = 0;
        while (i2 < property.getSubProperties().size() && !foundClass) {
            if (((ComponentInstanceProperty)property.getSubProperties().get(i2)).getModel().getType().compareTo("MyFatherValue") == 0) {
                foundClass = true;
                classProperty = (ComponentInstanceProperty)property.getSubProperties().get(i2);
            }
            ++i2;
        }
        classSrc = new File(location.getValue());
        if (location.getValue().endsWith(".jar")) {
            File newDirectory = new File(String.valueOf(suDir.getAbsolutePath()) + File.separator + jarDirectory);
            newDirectory.mkdir();
            classDest = new File(String.valueOf(suDir.getAbsolutePath()) + File.separator + jarDirectory + File.separator + classSrc.getName());
            LoggerTool.logger.info("Copy of " + classSrc.getAbsolutePath() + " to " + classDest.getAbsolutePath());
            this.copyFile(classSrc, classDest);
        } else {
            String packageAndClassName = classProperty.getValue().replace('.', File.separatorChar);
            this.createMissingDirectories(suDir.getAbsolutePath(), packageAndClassName);
            classDest = new File(String.valueOf(suDir.getAbsolutePath()) + File.separator + packageAndClassName + ".class");
            LoggerTool.logger.info("Copy of " + classSrc.getAbsolutePath() + " to " + classDest.getAbsolutePath());
            this.copyFile(classSrc, classDest);
        }
        newProperty.setModel(property.getModel());
        newProperty.setName(property.getName());
        newProperty.setValue(classProperty.getValue());
        int iprop = 0;
        while (iprop < property.getSubProperties().size()) {
            ComponentInstanceProperty cleanedProperty;
            if (((Property)property.getSubProperties().get(iprop)).getName().compareTo("location") != 0 && !((ComponentInstanceProperty)property.getSubProperties().get(iprop)).isClass(false) && (cleanedProperty = this.cleanAndPrepare((ComponentInstanceProperty)property.getSubProperties().get(iprop), suDir)) != null) {
                newProperty.getSubProperties().add((Object)cleanedProperty);
            }
            ++iprop;
        }
        return newProperty;
    }

    private ComponentInstanceProperty cleanRole(ComponentInstanceProperty property) {
        ComponentInstanceProperty newProperty = cimero2Factory.eINSTANCE.createComponentInstanceProperty();
        newProperty.setModel(property.getModel());
        newProperty.setName(property.getName());
        newProperty.setValue(property.getValue().toLowerCase());
        return newProperty;
    }

    private ComponentInstanceProperty cleanMEP(ComponentInstanceProperty property) {
        ComponentInstanceProperty newProperty = cimero2Factory.eINSTANCE.createComponentInstanceProperty();
        String MEPValue = property.getValue();
        if (MEPValue.compareTo("InOnly") == 0) {
            MEPValue = "in-only";
        } else if (MEPValue.compareTo("InOut") == 0) {
            MEPValue = "in-out";
        } else if (MEPValue.compareTo("RobustInOnly") == 0) {
            MEPValue = "robust-in-only";
        } else if (MEPValue.compareTo("InOptionalOut") == 0) {
            MEPValue = "in-optional-out";
        }
        newProperty.setModel(property.getModel());
        newProperty.setName(property.getName());
        newProperty.setValue("http://www.w3.org/2004/08/wsdl/" + MEPValue);
        return newProperty;
    }

    private ComponentInstanceProperty cleanServiceQNameInterface(ComponentInstanceProperty property) {
        ComponentInstanceProperty newProperty = cimero2Factory.eINSTANCE.createComponentInstanceProperty();
        if (property.getModel().isReferenceToExternalComponent()) {
            newProperty.setModel(property.getModel());
            newProperty.setName(property.getName());
            newProperty.setValue(property.getValue());
        } else {
            newProperty.setModel(property.getModel());
            newProperty.setName(property.getName());
            String prefix = "";
            String newServiceName = null;
            if (((Property)property.getSubProperties().get(0)).getValue().compareTo("") != 0) {
                prefix = String.valueOf(((Property)property.getSubProperties().get(0)).getValue()) + ":";
            }
            newServiceName = String.valueOf(prefix) + ((Property)property.getSubProperties().get(1)).getValue();
            newProperty.setValue(newServiceName);
            newProperty.getSubProperties().clear();
        }
        return newProperty;
    }

    private ComponentInstanceProperty cleanFile(ComponentInstanceProperty property, File suDir) {
        String newValue = this.findTheFileNameInAPath(property.getValue());
        ComponentInstanceProperty newProperty = cimero2Factory.eINSTANCE.createComponentInstanceProperty();
        newProperty.setModel(property.getModel());
        newProperty.setName(property.getName());
        if (currentESB.compareTo("ServiceMix") == 0) {
            newProperty.setValue("classpath:" + newValue);
        } else {
            newProperty.setValue(newValue);
        }
        File src = new File(property.getValue());
        File dest = new File(String.valueOf(suDir.getAbsolutePath()) + File.separator + newValue);
        this.copyFile(src, dest);
        return newProperty;
    }

    private ComponentInstanceProperty cleanXOR(ComponentInstanceProperty property, File suDir) {
        int i = 0;
        while (i < property.getSubProperties().size()) {
            if (((ComponentInstanceProperty)property.getSubProperties().get(i)).isValueSet() && ((ComponentInstanceProperty)property.getSubProperties().get(i)).isValidPropertyForCurrentRole() && (ComponentInstanceProperty)property.getSubProperties().get(i) != null) {
                return this.cleanAndPrepare((ComponentInstanceProperty)property.getSubProperties().get(i), suDir);
            }
            ++i;
        }
        LoggerTool.logger.severe("Generation error, no value set for the exclusive property");
        return null;
    }

    private void createMissingDirectories(String absolutePath, String packageAndClassName) {
        String[] directories = packageAndClassName.split(Pattern.quote(File.separator));
        String root = absolutePath;
        File directory = null;
        int i = 0;
        while (i < directories.length - 1) {
            directory = new File(String.valueOf(root) + File.separator + directories[i]);
            root = String.valueOf(root) + File.separator + directories[i];
            directory.mkdir();
            ++i;
        }
    }

    @Override
    public String generatePropertyText(ComponentInstanceProperty componentInstanceProperty) {
        PropertyGenerator generator = new PropertyGenerator();
        JET2Context context = new JET2Context((Object)componentInstanceProperty, this.commonVars);
        BodyContentWriter writer = new BodyContentWriter();
        generator.generate(context, (JET2Writer)writer);
        return writer.toString();
    }

    @Override
    public List<ComponentInstanceProperty> getComponentInstancePropertiesList() {
        return componentInstanceProperties;
    }

    @Override
    public boolean generateAntTask(Graph graph) {
        boolean generationComplete = false;
        LoggerTool.logger.info("Generating Ant task ...............");
        try {
            AntTaskGenerator generator = new AntTaskGenerator();
            JET2Context context = new JET2Context((Object)graph, this.commonVars);
            BodyContentWriter writer = new BodyContentWriter();
            BufferedWriter out = new BufferedWriter(new FileWriter(String.valueOf(jbiDirectory.getAbsolutePath()) + File.separator + "build.xml"));
            generator.generate(context, (JET2Writer)writer);
            String generatedText = writer.toString();
            out.write(generatedText);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        LoggerTool.logger.info("Ant task generation sucessfull");
        return generationComplete;
    }

    @Override
    public boolean generateSAsDescriptors(Graph graph) {
        BufferedWriter out;
        boolean generationComplete = false;
        LoggerTool.logger.info("Generating SA descriptor task ...............");
        int i = 0;
        while (i < graph.getContainers().size()) {
            Container container = (Container)graph.getContainers().get(i);
            if (container.getComponents().size() > 0) {
                ArrayList<Object> args = new ArrayList<Object>();
                args.add(graph);
                args.add(container.getId());
                ArrayList<ComponentInstance> components = new ArrayList<ComponentInstance>();
                int j = 0;
                while (j < container.getComponents().size()) {
                    components.add((ComponentInstance)container.getComponents().get(j));
                    ++j;
                }
                args.add(components);
                try {
                    JBIDescriptorGenerator generator = new JBIDescriptorGenerator();
                    JET2Context context = new JET2Context((Object)new Object[]{args}, this.commonVars);
                    BodyContentWriter writer = new BodyContentWriter();
                    out = new BufferedWriter(new FileWriter(String.valueOf(saDescriptorsDirectory.getAbsolutePath()) + File.separator + "SA_" + container.getId() + File.separator + "META-INF" + File.separator + "jbi.xml"));
                    generator.generate(context, (JET2Writer)writer);
                    String generatedText = writer.toString();
                    out.write(generatedText);
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
        if (graph.getComponentsWithNoContainer().size() > 0) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(graph);
            args.add("");
            args.add(graph.getComponentsWithNoContainer());
            try {
                JBIDescriptorGenerator generator = new JBIDescriptorGenerator();
                JET2Context context = new JET2Context((Object)new Object[]{args}, this.commonVars);
                BodyContentWriter writer = new BodyContentWriter();
                out = new BufferedWriter(new FileWriter(String.valueOf(saDescriptorsDirectory.getAbsolutePath()) + File.separator + "SA_default" + File.separator + "META-INF" + File.separator + "jbi.xml"));
                generator.generate(context, (JET2Writer)writer);
                String generatedText = writer.toString();
                out.write(generatedText);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        LoggerTool.logger.info("SA descriptor generation sucessfull");
        return generationComplete;
    }

    public boolean createCamelFolders(Graph graph) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IEditorInput editorInput = iWorkbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        IPath editorPath = ((IPathEditorInput)editorInput).getPath();
        int matchingSegs = editorPath.matchingFirstSegments(workspace.getRoot().getLocation());
        IProject proj = root.getProject(editorPath.segment(matchingSegs));
        try {
            proj.getNature("org.eclipse.pde.PluginNature");
            IResource metainf = proj.findMember("META-INF");
            this.camelDirectory = metainf != null ? new File(metainf.getLocation().toFile(), "spring") : new File(proj.getLocation().toFile(), graph.getName());
        }
        catch (CoreException coreException) {
            this.camelDirectory = new File(proj.getLocation().toFile(), graph.getName());
        }
        if (!this.camelDirectory.exists()) {
            this.camelDirectory.mkdir();
        }
        return true;
    }

    @Override
    public void generateForComponent(ComponentInstance compo, Map<String, Object> vars, JET2Writer writer) {
        String nextName = compo.getModel().getName();
        JET2Template nextGen = this.templateGeneratorMap.get(nextName);
        if (nextGen == null) {
            writer.write("    <!-- ERROR:  can't find generation template for '<%=nextName%>' -->");
        } else {
            JET2Context nextContext = new JET2Context((Object)compo, vars);
            nextGen.generate(nextContext, writer);
        }
    }

    public Map<String, JET2Template> getTemplateGeneratorMap() {
        return this.templateGeneratorMap;
    }

    public void setCamelGenerationStatus(IStatus status) {
        this.camelStatus = status;
    }

    public String getPluginId() {
        return "org.eclipse.stp.eid.generator";
    }

    @Override
    public boolean createArborescence(Graph graph) {
        String metaInfDescriptorDirectoryPath;
        File metaInfDescriptorDirectory;
        String saDescriptorDirectoryPath;
        File saDescriptorDirectory;
        String xbeanDirectoryPath;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IEditorInput editorInput = iWorkbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        IPath editorPath = ((IPathEditorInput)editorInput).getPath();
        EList componentInstanceList = graph.getComponents();
        String jbiDirectoryPath = String.valueOf(root.getProject(editorPath.removeLastSegments(1).lastSegment()).getLocation().toOSString()) + File.separator + graph.getName();
        jbiDirectory = new File(jbiDirectoryPath);
        if (!jbiDirectory.exists()) {
            jbiDirectory.mkdir();
        }
        if (!(xbeanDirectory = new File(xbeanDirectoryPath = String.valueOf(jbiDirectoryPath) + File.separator + "SUs")).exists()) {
            xbeanDirectory.mkdir();
        }
        File[] fileList = xbeanDirectory.listFiles();
        int i = 0;
        while (i < fileList.length) {
            if (!this.isAValidComponentInstance(graph, fileList[i].getName())) {
                this.deleteDirectory(fileList[i]);
            }
            ++i;
        }
        i = 0;
        while (i < componentInstanceList.size()) {
            File suDir = new File(String.valueOf(xbeanDirectory.getAbsolutePath()) + File.separator + (((ComponentInstance)componentInstanceList.get(i)).getName() == null ? String.valueOf(((ComponentInstance)componentInstanceList.get(i)).getModel().getName()) + i : ((ComponentInstance)componentInstanceList.get(i)).getName()));
            if (!suDir.exists()) {
                suDir.mkdir();
            }
            ++i;
        }
        String saDescriptorsDirectoryPath = String.valueOf(jbiDirectoryPath) + File.separator + "SAs";
        saDescriptorsDirectory = new File(saDescriptorsDirectoryPath);
        if (!saDescriptorsDirectory.exists()) {
            saDescriptorsDirectory.mkdir();
        }
        if (!(saDescriptorDirectory = new File(saDescriptorDirectoryPath = String.valueOf(saDescriptorsDirectoryPath) + File.separator + "SA_default")).exists()) {
            saDescriptorDirectory.mkdir();
        }
        if (!(metaInfDescriptorDirectory = new File(metaInfDescriptorDirectoryPath = String.valueOf(saDescriptorDirectoryPath) + File.separator + "META-INF")).exists()) {
            metaInfDescriptorDirectory.mkdir();
        }
        int i2 = 0;
        while (i2 < graph.getContainers().size()) {
            Container container = (Container)graph.getContainers().get(i2);
            if (container.getComponents().size() > 0) {
                saDescriptorDirectoryPath = String.valueOf(saDescriptorsDirectoryPath) + File.separator + "SA_" + container.getId();
                saDescriptorDirectory = new File(saDescriptorDirectoryPath);
                if (!saDescriptorDirectory.exists()) {
                    saDescriptorDirectory.mkdir();
                }
                if (!(metaInfDescriptorDirectory = new File(metaInfDescriptorDirectoryPath = String.valueOf(saDescriptorDirectoryPath) + File.separator + "META-INF")).exists()) {
                    metaInfDescriptorDirectory.mkdir();
                }
            }
            ++i2;
        }
        String buildedPackageDirectoryPath = String.valueOf(jbiDirectoryPath) + File.separator + "build";
        buildedPackageDirectory = new File(buildedPackageDirectoryPath);
        if (!buildedPackageDirectory.exists()) {
            buildedPackageDirectory.mkdir();
        }
        return true;
    }

    private boolean isAValidComponentInstance(Graph graph, String name) {
        Boolean valid = false;
        int i = 0;
        while (i < graph.getComponents().size() && !valid.booleanValue()) {
            if (((ComponentInstance)graph.getComponents().get(i)).getName().compareTo(name) == 0) {
                valid = true;
            }
            ++i;
        }
        return valid;
    }

    @Override
    public void launchAntTask(String graphName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IEditorInput editorInput = iWorkbench.getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
        IPath editorPath = ((IPathEditorInput)editorInput).getPath();
        Project project = new Project();
        File buildFile = new File(String.valueOf(root.getProject(editorPath.removeLastSegments(1).lastSegment()).getLocation().toOSString()) + File.separator + graphName + File.separator + "build.xml");
        BuildException exception = null;
        try {
            try {
                project.fireBuildStarted();
                project.init();
                ProjectHelper.configureProject((Project)project, (File)buildFile);
                project.executeTarget(project.getDefaultTarget());
            }
            catch (BuildException e) {
                exception = e;
                project.fireBuildFinished((Throwable)exception);
            }
        }
        finally {
            project.fireBuildFinished((Throwable)exception);
        }
    }

    private boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return path.delete();
    }

    private void copyFile(File src, File dest) {
        if (src.exists()) {
            try {
                FileChannel sourceChannel = new FileInputStream(src).getChannel();
                FileChannel destinationChannel = new FileOutputStream(dest).getChannel();
                sourceChannel.transferTo(0L, sourceChannel.size(), destinationChannel);
                sourceChannel.close();
                destinationChannel.close();
            }
            catch (FileNotFoundException e) {
                LoggerTool.logger.severe("File not found !");
                e.printStackTrace();
            }
            catch (IOException e) {
                LoggerTool.logger.severe("IO Exception !");
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String findTheFileNameInAPath(String value) {
        String[] splittedValue = value.split(Pattern.quote(File.separator));
        return splittedValue[splittedValue.length - 1];
    }

    @Override
    public void refreshView() {
        try {
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (CoreException e) {
            LoggerTool.logger.warning("The package explorer refresh view has failed, you have to do it manually !");
            e.printStackTrace();
        }
    }

    @Override
    public String generateComponentXMLModel(String[] params) {
        XmlModelGenerator generator = new XmlModelGenerator();
        BodyContentWriter writer = new BodyContentWriter();
        JET2Context context = new JET2Context((Object)params, this.commonVars);
        generator.generate(context, (JET2Writer)writer);
        return writer.toString();
    }
}

