/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MEPType implements Enumerator
{
    IN_ONLY(0, "InOnly", "InOnly"),
    IN_OUT(1, "InOut", "InOut"),
    ROBUST_IN_ONLY(2, "RobustInOnly", "RobustInOnly"),
    IN_OPTIONAL_OUT(3, "InOptionalOut", "InOptionalOut");

    public static final int IN_ONLY_VALUE = 0;
    public static final int IN_OUT_VALUE = 1;
    public static final int ROBUST_IN_ONLY_VALUE = 2;
    public static final int IN_OPTIONAL_OUT_VALUE = 3;
    private static final MEPType[] VALUES_ARRAY;
    public static final List<MEPType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MEPType[]{IN_ONLY, IN_OUT, ROBUST_IN_ONLY, IN_OPTIONAL_OUT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MEPType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MEPType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MEPType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MEPType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MEPType get(int value) {
        switch (value) {
            case 0: {
                return IN_ONLY;
            }
            case 1: {
                return IN_OUT;
            }
            case 2: {
                return ROBUST_IN_ONLY;
            }
            case 3: {
                return IN_OPTIONAL_OUT;
            }
        }
        return null;
    }

    private MEPType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

