/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.eid.datamodel.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.stp.eid.datamodel.ComponentModel;
import org.eclipse.stp.eid.datamodel.ComponentType;
import org.eclipse.stp.eid.datamodel.ESB;
import org.eclipse.stp.eid.datamodel.MEPType;
import org.eclipse.stp.eid.datamodel.Namespace;
import org.eclipse.stp.eid.datamodel.PropertyModel;
import org.eclipse.stp.eid.datamodel.RoleType;
import org.eclipse.stp.eid.datamodel.cimero2Factory;
import org.eclipse.stp.eid.datamodel.util.Cimero2EditorPlugin;
import org.eclipse.stp.eid.datamodel.util.LoggerTool;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    private static final org.jdom.Namespace NS = org.jdom.Namespace.getNamespace((String)"http://java.sun.com/xml/ns/component");
    private static final String COMPONENTDIRECTORY = Cimero2EditorPlugin.cimeroComponentModelDirPath;

    public static void initComponentModel() {
        try {
            SAXBuilder sxb = new SAXBuilder();
            sxb.setValidation(true);
            sxb.setFeature("http://apache.org/xml/features/validation/schema", true);
            sxb.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            cimero2Factory.eINSTANCE.getComponentModelList().clear();
            ArrayList<String> fileList = Parser.scanDir(COMPONENTDIRECTORY);
            int i = 0;
            while (i < fileList.size()) {
                try {
                    File componentModelFile = new File(fileList.get(i));
                    Document document = sxb.build(componentModelFile);
                    Element racine = document.getRootElement();
                    ESB esb = null;
                    boolean found = false;
                    int j = 0;
                    while (!found && j < cimero2Factory.eINSTANCE.getEsbList().size()) {
                        if (cimero2Factory.eINSTANCE.getEsbList().get(j).getName() == null) {
                            LoggerTool.logger.severe("ESB List not well initialized, name of the esb is null");
                        } else if (racine.getChildTextNormalize("esb", NS) == null) {
                            LoggerTool.logger.warning("Check your file " + fileList.get(i) + ", it seems that the esb name is null");
                        } else if (cimero2Factory.eINSTANCE.getEsbList().get(j).getName().compareTo(racine.getChildTextNormalize("esb", NS)) == 0) {
                            found = true;
                            esb = cimero2Factory.eINSTANCE.getEsbList().get(j);
                        }
                        ++j;
                    }
                    if (found) {
                        ComponentModel current = cimero2Factory.eINSTANCE.createComponentModel();
                        current.setName(racine.getChildTextNormalize("component-name", NS));
                        current.setEsb(esb);
                        current.setPicture(racine.getChildTextNormalize("picture", NS));
                        current.setType(ComponentType.getByName(racine.getChildTextNormalize("component-type", NS)));
                        current.setInstallName(racine.getChildTextNormalize("install-component-name", NS));
                        current.setDirectory(racine.getChildTextNormalize("install-component-directory", NS));
                        current.setNameSpace(racine.getChildTextNormalize("component-namespace", NS));
                        if (Integer.valueOf(racine.getChildTextNormalize("max-input", NS)) == -1) {
                            current.setMaxInput(Integer.MAX_VALUE);
                        } else {
                            current.setMaxInput(Integer.valueOf(racine.getChildTextNormalize("max-input", NS)));
                        }
                        if (Integer.valueOf(racine.getChildTextNormalize("max-output", NS)) == -1) {
                            current.setMaxOutput(Integer.MAX_VALUE);
                        } else {
                            current.setMaxOutput(Integer.valueOf(racine.getChildTextNormalize("max-output", NS)));
                        }
                        current.setMinOutput(Integer.valueOf(racine.getChildTextNormalize("min-output", NS)));
                        current.setMinInput(Integer.valueOf(racine.getChildTextNormalize("min-input", NS)));
                        if (racine.getChildTextNormalize("MEP", NS) != null) {
                            current.setFixedMEPValue(MEPType.get(racine.getChildTextNormalize("MEP", NS)));
                        }
                        List componentProperties = racine.getChildren("property", NS);
                        int iProp = 0;
                        while (iProp < componentProperties.size()) {
                            current.getProperties().add((Object)Parser.addProperty((Element)componentProperties.get(iProp), String.valueOf(current.getName()) + Integer.valueOf(iProp).toString(), null));
                            ++iProp;
                        }
                        cimero2Factory.eINSTANCE.getComponentModelList().add(current);
                    } else {
                        LoggerTool.logger.warning("Check your file " + fileList.get(i) + ", it seems that the esb name is not supported by this version of CIMERO");
                    }
                }
                catch (JDOMException e) {
                    LoggerTool.logger.warning(String.valueOf(fileList.get(i)) + " is not well-formed.");
                    LoggerTool.logger.warning(e.getMessage());
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            LoggerTool.logger.severe("Input/output error");
            LoggerTool.logger.severe("during the call to constructor.parse(xml)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static PropertyModel addProperty(Element property, String idProperty, PropertyModel superPropertyModel) {
        Element propertyValueList;
        PropertyModel propModel = cimero2Factory.eINSTANCE.createPropertyModel();
        propModel.setPropertyModelId(idProperty);
        propModel.setSuperProperty(superPropertyModel);
        propModel.setName(property.getChildTextNormalize("attribute-name", NS));
        if (property.getChildTextNormalize("repeatable-attribute", NS) != null) {
            propModel.setRepeatable(Boolean.valueOf(property.getChildTextNormalize("repeatable-attribute", NS)));
        }
        if (property.getChildTextNormalize("own-tag", NS) != null) {
            propModel.setHasItsOwnTag(Boolean.valueOf(property.getChildTextNormalize("own-tag", NS)));
        }
        if (property.getChildTextNormalize("MEP", NS) != null) {
            propModel.setFixedMEPValue(MEPType.get(property.getChildTextNormalize("MEP", NS)));
        }
        propModel.setRequired(Boolean.valueOf(property.getChildTextNormalize("required-attribute", NS)));
        propModel.setRole(RoleType.get(property.getChildTextNormalize("role", NS)));
        if (property.getChildTextNormalize("default-value", NS) != null) {
            propModel.setValue(property.getChildTextNormalize("default-value", NS));
        }
        propModel.setType(property.getChildTextNormalize("attribute-type", NS));
        propModel.setDescription(property.getChildTextNormalize("attribute-description", NS));
        if (property.getChild("value-description", NS) != null && (propertyValueList = property.getChild("value-description", NS).getChild("values-list", NS)) != null) {
            int iprop = 0;
            while (iprop < propertyValueList.getChildren("value", NS).size()) {
                propModel.getAuthorizedValues().add((Object)((Element)propertyValueList.getChildren("value", NS).get(iprop)).getTextNormalize());
                ++iprop;
            }
        }
        if (property.getChildTextNormalize("referenceToExternalComponent", NS) != null) {
            propModel.setReferenceToExternalComponent(Boolean.valueOf(property.getChildTextNormalize("referenceToExternalComponent", NS)));
        }
        if (property.getChildTextNormalize("specificNamespace", NS) != null) {
            Element namespace = property.getChild("specificNamespace", NS).getChild("namespace", NS);
            if (namespace != null) {
                Namespace propertyNamespace = cimero2Factory.eINSTANCE.createNamespace();
                propertyNamespace.setPrefix(namespace.getChildTextNormalize("prefix", NS));
                propertyNamespace.setValue(namespace.getChildTextNormalize("value", NS));
                propModel.setNamespace(propertyNamespace);
            } else {
                propModel.setNeedNamespace(false);
            }
        }
        if (property.getChildren("property", NS) != null) {
            int iprop = 0;
            while (iprop < property.getChildren("property", NS).size()) {
                propModel.getSubProperties().add((Object)Parser.addProperty((Element)property.getChildren("property", NS).get(iprop), String.valueOf(idProperty) + "." + Integer.valueOf(iprop).toString(), propModel));
                ++iprop;
            }
        }
        if (!(propModel.getType().compareTo("QName") != 0 && propModel.getType().compareTo("Service") != 0 && propModel.getType().compareTo("Interface") != 0 || propModel.isReferenceToExternalComponent())) {
            PropertyModel namespace = cimero2Factory.eINSTANCE.createPropertyModel();
            namespace.setDescription("The namespace to use.");
            namespace.setName("namespace");
            namespace.setPropertyModelId(String.valueOf(idProperty) + ".0");
            namespace.setRequired(false);
            namespace.setRole(propModel.getRole());
            namespace.setSuperProperty(propModel);
            namespace.setType("Namespace");
            PropertyModel value = cimero2Factory.eINSTANCE.createPropertyModel();
            value.setName("value");
            value.setPropertyModelId(String.valueOf(idProperty) + ".1");
            value.setRequired(true);
            value.setRole(propModel.getRole());
            value.setSuperProperty(propModel);
            value.setType("String");
            value.setDescription("The field value.");
            propModel.getSubProperties().add((Object)namespace);
            propModel.getSubProperties().add((Object)value);
        }
        if (propModel.getType().compareTo("Class") == 0) {
            PropertyModel locationPropertyModel = cimero2Factory.eINSTANCE.createPropertyModel();
            locationPropertyModel.setName("location");
            locationPropertyModel.setDescription("Location to the class. It could be a jar or a directory");
            locationPropertyModel.setPropertyModelId(String.valueOf(idProperty) + propModel.getSubProperties().size());
            locationPropertyModel.setReferenceToExternalComponent(false);
            locationPropertyModel.setRepeatable(false);
            locationPropertyModel.setRequired(true);
            locationPropertyModel.setRole(propModel.getRole());
            locationPropertyModel.setSuperProperty(propModel);
            locationPropertyModel.setType("URI");
            propModel.getSubProperties().add((Object)locationPropertyModel);
        }
        if (propModel.getType().compareTo("Unsettable") != 0 && propModel.getType().compareTo("XOR") != 0 && propModel.getType().compareTo("Service") != 0 && propModel.getType().compareTo("QName") != 0 && propModel.getType().compareTo("Interface") != 0 && propModel.getSubProperties().size() > 0) {
            PropertyModel subPropertyModel = cimero2Factory.eINSTANCE.createPropertyModel();
            subPropertyModel.setName(String.valueOf(propModel.getName()) + " value");
            subPropertyModel.setDescription(propModel.getDescription());
            subPropertyModel.setPropertyModelId(String.valueOf(idProperty) + propModel.getSubProperties().size());
            subPropertyModel.setReferenceToExternalComponent(propModel.isReferenceToExternalComponent());
            subPropertyModel.setRepeatable(false);
            subPropertyModel.setRequired(propModel.isRequired());
            subPropertyModel.setRole(propModel.getRole());
            subPropertyModel.setSuperProperty(propModel);
            subPropertyModel.setType("MyFatherValue");
            subPropertyModel.setValue(propModel.getValue());
            int i = 0;
            while (i < propModel.getAuthorizedValues().size()) {
                String value = (String)propModel.getAuthorizedValues().get(i);
                subPropertyModel.getAuthorizedValues().add((Object)value);
                ++i;
            }
            propModel.getSubProperties().add((Object)subPropertyModel);
        }
        return propModel;
    }

    public static ArrayList<String> scanDir(String theDirectory) throws IOException {
        File currDir = new File(theDirectory);
        ArrayList<String> finalListFiles = new ArrayList<String>();
        if (currDir.exists()) {
            if (!currDir.isDirectory()) {
                return null;
            }
            String[] fileList = currDir.list();
            int i = 0;
            while (i < fileList.length) {
                ArrayList<String> temp = Parser.scanDir(String.valueOf(theDirectory) + File.separator + fileList[i]);
                if (temp == null && fileList[i].endsWith(".xml")) {
                    finalListFiles.add(String.valueOf(theDirectory) + File.separator + fileList[i]);
                } else if (temp != null) {
                    finalListFiles.add((String)((Object)temp));
                }
                ++i;
            }
        }
        return finalListFiles;
    }

    public static void populateResource(String esbName, Resource modelResource) {
        try {
            SAXBuilder sxb = new SAXBuilder();
            sxb.setValidation(true);
            sxb.setFeature("http://apache.org/xml/features/validation/schema", true);
            sxb.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
            ArrayList<String> fileList = Parser.scanDir(COMPONENTDIRECTORY);
            int i = 0;
            while (i < fileList.size()) {
                try {
                    File componentModelFile = new File(fileList.get(i));
                    Document document = sxb.build(componentModelFile);
                    Element racine = document.getRootElement();
                    ESB esb = null;
                    boolean found = false;
                    int j = 0;
                    while (!found && j < cimero2Factory.eINSTANCE.getEsbList().size()) {
                        if (cimero2Factory.eINSTANCE.getEsbList().get(j).getName() == null) {
                            LoggerTool.logger.severe("ESB List not well initialized, name of the esb is null");
                        } else if (racine.getChildTextNormalize("esb", NS) == null) {
                            LoggerTool.logger.warning("Check your file " + fileList.get(i) + ", it seems that the esb name is null");
                        } else if (cimero2Factory.eINSTANCE.getEsbList().get(j).getName().compareTo(racine.getChildTextNormalize("esb", NS)) == 0) {
                            found = true;
                            esb = cimero2Factory.eINSTANCE.getEsbList().get(j);
                        }
                        ++j;
                    }
                    if (found && esbName.compareTo(racine.getChildTextNormalize("esb", NS)) == 0) {
                        ComponentModel current = Parser.createComponent(racine, esb);
                        modelResource.getContents().add((Object)current);
                        LoggerTool.logger.info("Component " + current.getName() + " on esb " + current.getEsb().getName() + " installed");
                    }
                }
                catch (JDOMException e) {
                    LoggerTool.logger.warning(String.valueOf(fileList.get(i)) + " is not well-formed.");
                    LoggerTool.logger.warning(e.getMessage());
                }
                ++i;
            }
        }
        catch (IOException iOException) {
            LoggerTool.logger.severe("Input/output error");
            LoggerTool.logger.severe("during the call to constructor.parse(xml)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ComponentModel createComponent(Element racine, ESB esb) {
        int iProp;
        ComponentModel current = cimero2Factory.eINSTANCE.createComponentModel();
        current.setInstallName(racine.getChildTextNormalize("install-component-name", NS));
        current.setName(racine.getChildTextNormalize("component-name", NS));
        current.setDirectory(racine.getChildTextNormalize("install-component-directory", NS));
        current.setEsb(esb);
        current.setNameSpace(racine.getChildTextNormalize("component-namespace", NS));
        current.setType(ComponentType.getByName(racine.getChildTextNormalize("component-type", NS)));
        if (Integer.valueOf(racine.getChildTextNormalize("max-input", NS)) == -1) {
            current.setMaxInput(Integer.MAX_VALUE);
        } else {
            current.setMaxInput(Integer.valueOf(racine.getChildTextNormalize("max-input", NS)));
        }
        if (Integer.valueOf(racine.getChildTextNormalize("max-output", NS)) == -1) {
            current.setMaxOutput(Integer.MAX_VALUE);
        } else {
            current.setMaxOutput(Integer.valueOf(racine.getChildTextNormalize("max-output", NS)));
        }
        current.setMinOutput(Integer.valueOf(racine.getChildTextNormalize("min-output", NS)));
        current.setMinInput(Integer.valueOf(racine.getChildTextNormalize("min-input", NS)));
        if (racine.getChildTextNormalize("MEP", NS) != null) {
            current.setFixedMEPValue(MEPType.get(racine.getChildTextNormalize("MEP", NS)));
        }
        current.setPicture(racine.getChildTextNormalize("picture", NS));
        if (racine.getChild("restrictedInputMEPSet", NS) != null) {
            List restrictedInputMEPSet = racine.getChild("restrictedInputMEPSet", NS).getChildren();
            iProp = 0;
            while (iProp < restrictedInputMEPSet.size()) {
                current.getRestrictedInputMEPSet().add((Object)MEPType.get(((Element)restrictedInputMEPSet.get(iProp)).getTextNormalize()));
                ++iProp;
            }
        }
        List componentProperties = racine.getChildren("property", NS);
        iProp = 0;
        while (iProp < componentProperties.size()) {
            current.getProperties().add((Object)Parser.addProperty((Element)componentProperties.get(iProp), String.valueOf(current.getName()) + Integer.valueOf(iProp).toString(), null));
            ++iProp;
        }
        return current;
    }

    public static String getComponentModelAttributeFromFile(String componentFile, String attribute) {
        String componentModel = null;
        SAXBuilder sxb = new SAXBuilder();
        sxb.setValidation(true);
        sxb.setFeature("http://apache.org/xml/features/validation/schema", true);
        sxb.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        try {
            File componentModelFile = new File(componentFile);
            Document document = sxb.build(componentModelFile);
            Element racine = document.getRootElement();
            componentModel = racine.getChildTextNormalize(attribute, NS);
        }
        catch (JDOMException e) {
            LoggerTool.logger.warning(String.valueOf(componentFile) + " is not well-formed.");
            LoggerTool.logger.warning(e.getMessage());
        }
        catch (IOException iOException) {
            LoggerTool.logger.severe(String.valueOf(componentFile) + "error. \n Maybe it doesn't exist anymore.");
        }
        return componentModel;
    }

    public static String getComponentPictureFromFile(String componentFile) {
        String picture = null;
        SAXBuilder sxb = new SAXBuilder();
        sxb.setValidation(true);
        sxb.setFeature("http://apache.org/xml/features/validation/schema", true);
        sxb.setFeature("http://apache.org/xml/features/validation/schema-full-checking", true);
        try {
            File componentModelFile = new File(componentFile);
            Document document = sxb.build(componentModelFile);
            Element racine = document.getRootElement();
            picture = racine.getChildTextNormalize("picture", NS);
        }
        catch (JDOMException e) {
            LoggerTool.logger.warning(String.valueOf(componentFile) + " is not well-formed.");
            LoggerTool.logger.warning(e.getMessage());
        }
        catch (IOException iOException) {
            LoggerTool.logger.severe(String.valueOf(componentFile) + "error. \n Maybe it doesn't exist anymore.");
        }
        return picture;
    }
}

