/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.resources.datasources;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stp.im.resources.IImResource;
import org.eclipse.stp.im.resources.ui.providers.IImResourceContentProvider;
import org.eclipse.stp.im.resources.ui.providers.IImResourceLabelProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectImResourcesDialog
extends TitleAreaDialog {
    private SashForm internalSash = null;
    private Table tableResources = null;
    private TableViewer tbvResources = null;
    private List<IImResource> availableResources = null;
    private List<IImResource> selectedImResources = null;
    private String title = null;

    public SelectImResourcesDialog(Shell parentShell, String title, List<IImResource> dataSourcesList) {
        super(parentShell);
        this.title = title;
        this.availableResources = dataSourcesList;
    }

    public void create() {
        super.create();
        this.setTitle(this.title);
        this.setMessage("Select Resources To Import In Local Resource Store ");
    }

    protected Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        return ctrl;
    }

    protected Control createDialogArea(Composite parent) {
        this.internalSash = new SashForm(parent, 0x800200);
        this.internalSash.setLayoutData((Object)new GridData(1808));
        this.tableResources = new Table((Composite)this.internalSash, 67586);
        this.tableResources.setLinesVisible(true);
        this.tableResources.setHeaderVisible(true);
        TableColumn column = null;
        column = new TableColumn(this.tableResources, 16384);
        column.setText("Name");
        column.setWidth(200);
        column = new TableColumn(this.tableResources, 16384);
        column.setText("Driver");
        column.setWidth(200);
        column = new TableColumn(this.tableResources, 16384);
        column.setText("url");
        column.setWidth(200);
        column = new TableColumn(this.tableResources, 16384);
        column.setText("user");
        column.setWidth(200);
        this.tbvResources = new TableViewer(this.tableResources);
        this.tbvResources.setContentProvider((IContentProvider)new IImResourceContentProvider());
        this.tbvResources.setLabelProvider((IBaseLabelProvider)new IImResourceLabelProvider());
        this.tbvResources.setInput(this.availableResources);
        return parent;
    }

    protected void okPressed() {
        TableItem[] selection = this.tableResources.getSelection();
        if (selection != null && selection.length > 0) {
            this.selectedImResources = new ArrayList<IImResource>();
            int i = 0;
            while (i < selection.length) {
                this.selectedImResources.add((IImResource)selection[i].getData());
                ++i;
            }
        }
        super.okPressed();
    }

    protected void cancelPressed() {
        this.selectedImResources = null;
        super.cancelPressed();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Import In Local Resource Store", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, true);
    }

    public List<IImResource> getSelectedImResources() {
        return this.selectedImResources;
    }

    public void setSelectedImResources(List<IImResource> selectedImResources) {
        this.selectedImResources = selectedImResources;
    }
}

