/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.runtime.property.listeners;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.stp.im.runtime.IProperty;
import org.eclipse.stp.im.runtime.property.listeners.IPropertyListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractParamsMapHandlerListener
implements IPropertyListener {
    private String matchRegexp = "\\$\\w+";
    public static String PLACE_HOLDER_SIGN = "$".intern();

    @Override
    public void handleUpdate(String sourcePropertyValue, String dependentPropertyName, IProperty destinationServiceBindingProperty, EAnnotation ea) {
        List<String> parametersList = this.getStringParameterNames(sourcePropertyValue);
        if (parametersList.size() >= 0) {
            String basePropertyName = null;
            for (String aParamName : parametersList) {
                basePropertyName = String.valueOf(dependentPropertyName) + "[" + aParamName + "]";
                String propertyToFoundInEAnnotation = String.valueOf(basePropertyName) + "." + destinationServiceBindingProperty.getMapFieldList().get(0);
                if (ea.getDetails().get((Object)propertyToFoundInEAnnotation) != null) continue;
                String destPropertyNameInAnnotation = null;
                for (String propOfMap : destinationServiceBindingProperty.getMapFieldList()) {
                    destPropertyNameInAnnotation = String.valueOf(basePropertyName) + "." + propOfMap;
                    if (propOfMap.equalsIgnoreCase(destinationServiceBindingProperty.getMapKey())) {
                        ea.getDetails().put((Object)destPropertyNameInAnnotation, (Object)aParamName);
                        continue;
                    }
                    ea.getDetails().put((Object)destPropertyNameInAnnotation, (Object)"");
                }
            }
            String parName = null;
            ArrayList<String> keyToRemove = new ArrayList<String>();
            for (String s : ea.getDetails().keySet()) {
                if (!s.startsWith(dependentPropertyName) || parametersList.contains(parName = s.substring(s.indexOf("[") + 1, s.indexOf("]")))) continue;
                keyToRemove.add(s);
            }
            for (String s : keyToRemove) {
                ea.getDetails().removeKey((Object)s);
            }
        }
    }

    public List<String> getStringParameterNames(String propertyValue) {
        Pattern pattern = Pattern.compile(this.matchRegexp);
        Matcher matcher = pattern.matcher(propertyValue);
        ArrayList<String> toReturn = new ArrayList<String>();
        int idx = 1;
        while (matcher.find()) {
            String placeHolder = matcher.group();
            placeHolder = placeHolder.substring(placeHolder.indexOf(PLACE_HOLDER_SIGN) + 1);
            toReturn.add(placeHolder);
            ++idx;
        }
        return toReturn;
    }
}

