/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.im.ImActivator;

public class ImLogger {
    public static void info(String msg) {
        ImLogger.info("org.eclipse.stp.im", msg);
    }

    public static void warning(String msg) {
        ImLogger.warning("org.eclipse.stp.im", msg);
    }

    public static void warning(String msg, Throwable e) {
        ImLogger.warning("org.eclipse.stp.im", msg, e);
    }

    public static void error(String msg) {
        ImLogger.error("org.eclipse.stp.im", msg);
    }

    public static void error(String msg, Throwable e) {
        ImLogger.error("org.eclipse.stp.im", msg, e);
    }

    public static void info(String pluginID, String msg) {
        ImActivator.getDefault().getLog().log((IStatus)new Status(1, pluginID, 1, msg, null));
    }

    public static void warning(String pluginID, String msg) {
        ImLogger.warning(pluginID, msg, null);
    }

    public static void warning(String pluginID, String msg, Throwable e) {
        ImActivator.getDefault().getLog().log((IStatus)new Status(2, pluginID, 2, msg, ImLogger.getCause(e)));
    }

    public static void error(String pluginID, String msg) {
        ImLogger.error(pluginID, msg, null);
    }

    public static void error(String pluginID, String msg, Throwable e) {
        ImActivator.getDefault().getLog().log((IStatus)new Status(4, pluginID, 4, msg, ImLogger.getCause(e)));
    }

    public static Throwable getCause(Throwable exception) {
        Throwable cause = null;
        if (exception != null) {
            if (exception instanceof CoreException) {
                CoreException ce = (CoreException)exception;
                cause = ce.getStatus().getException();
            } else {
                try {
                    Method causeMethod = exception.getClass().getMethod("getCause", new Class[0]);
                    Object o = causeMethod.invoke((Object)exception, new Object[0]);
                    if (o instanceof Throwable) {
                        cause = (Throwable)o;
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    cause = null;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    cause = null;
                }
                catch (IllegalAccessException illegalAccessException) {
                    cause = null;
                }
                catch (InvocationTargetException invocationTargetException) {
                    cause = null;
                }
            }
            if (cause == null) {
                cause = exception;
            }
        }
        return cause;
    }
}

