/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.common.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Stack;
import org.apache.log4j.Logger;

public class FileUtils {
    private static final Logger log = Logger.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static String normalizeResourcePath(String resourcePath) throws IllegalArgumentException {
        String normalizedPath = resourcePath;
        String objPath = null;
        objPath = resourcePath.replace('\\', '/');
        String[] parts = objPath.split("/");
        Stack<String> stackParts = new Stack<String>();
        try {
            int i = 0;
            while (i < parts.length) {
                if (parts[i].compareTo(".") != 0) {
                    if (parts[i].compareTo("..") == 0) {
                        stackParts.pop();
                    } else {
                        stackParts.add(parts[i]);
                    }
                }
                ++i;
            }
        }
        catch (EmptyStackException emptyStackException) {
            throw new IllegalArgumentException("Incorrect resource path");
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Unexpected problem while normalizing resource path: " + e.toString());
        }
        int partsCount = stackParts.size();
        normalizedPath = "";
        int pIndex = 0;
        while (pIndex < partsCount) {
            String thisPart = (String)stackParts.get(pIndex);
            normalizedPath = String.valueOf(normalizedPath) + "/";
            normalizedPath = String.valueOf(normalizedPath) + thisPart;
            ++pIndex;
        }
        return normalizedPath;
    }

    public static String formRelativePath(String homeDirectory, String filePath) {
        String relativeFilePath = "";
        try {
            if (File.separatorChar == '\\') {
                homeDirectory = homeDirectory.toLowerCase();
                filePath = filePath.toLowerCase();
            }
            File homeFileObj = new File(homeDirectory);
            File targetFileObj = new File(filePath);
            ArrayList<String> targetSegments = new ArrayList<String>();
            ArrayList<String> homeSegments = new ArrayList<String>();
            String segment = null;
            File canonicalFile = targetFileObj.getCanonicalFile();
            while (canonicalFile != null) {
                segment = canonicalFile.getName();
                if (segment == null || "".compareTo(segment) == 0) {
                    segment = canonicalFile.getPath();
                }
                targetSegments.add(segment);
                canonicalFile = canonicalFile.getParentFile();
            }
            canonicalFile = homeFileObj.getCanonicalFile();
            while (canonicalFile != null) {
                segment = canonicalFile.getName();
                if (segment == null || "".compareTo(segment) == 0) {
                    segment = canonicalFile.getPath();
                }
                homeSegments.add(segment);
                canonicalFile = canonicalFile.getParentFile();
            }
            Collections.reverse(targetSegments);
            Collections.reverse(homeSegments);
            Iterator itSDX = targetSegments.iterator();
            Iterator itSPDX = homeSegments.iterator();
            int index = 0;
            while (itSDX.hasNext() && itSPDX.hasNext() && ((String)itSDX.next()).compareTo((String)itSPDX.next()) == 0) {
                ++index;
            }
            if (index != 0 && File.separatorChar == '\\' || File.separatorChar == '/') {
                itSDX = targetSegments.iterator();
                itSPDX = homeSegments.iterator();
                int i = 0;
                while (i < index) {
                    itSDX.next();
                    itSPDX.next();
                    ++i;
                }
                while (itSDX.hasNext()) {
                    relativeFilePath = relativeFilePath.length() != 0 ? String.valueOf(relativeFilePath) + File.separator + (String)itSDX.next() : (String)itSDX.next();
                }
                while (itSPDX.hasNext()) {
                    relativeFilePath = ".." + File.separator + relativeFilePath;
                    itSPDX.next();
                }
            } else {
                log.warn((Object)"Unable to create relative path because files are located on different drives");
            }
        }
        catch (Exception err) {
            log.error((Object)("The problem while resolving the relative path =" + err.toString()), (Throwable)err);
            relativeFilePath = null;
        }
        return relativeFilePath;
    }

    public static boolean isAbsolutePath(String path) {
        boolean isAbsolute = false;
        if (File.separatorChar == '\\') {
            File[] roots = File.listRoots();
            int i = 0;
            while (i < roots.length && !isAbsolute) {
                try {
                    if (path.toLowerCase().startsWith(roots[i].getAbsolutePath().substring(0, 2).toLowerCase())) {
                        isAbsolute = true;
                    }
                }
                catch (Exception err) {
                    log.error((Object)("The problem in checking for absolute path: [" + err.toString() + "]"));
                }
                ++i;
            }
        } else if (path.startsWith("/")) {
            isAbsolute = true;
        }
        return isAbsolute;
    }
}

