/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.gef.commands.Command;
import org.eclipse.stp.policy.model.All;
import org.eclipse.stp.policy.model.Assertion;
import org.eclipse.stp.policy.model.ExactlyOne;
import org.eclipse.stp.policy.model.PolicyComponent;
import org.eclipse.stp.policy.model.PolicyComposite;
import org.eclipse.stp.policy.model.PolicyReference;
import org.eclipse.stp.policy.wtp.editor.integration.XefOpenExternalEditorHelper;
import org.eclipse.stp.policy.wtp.editor.model.AllModel;
import org.eclipse.stp.policy.wtp.editor.model.AssertionModel;
import org.eclipse.stp.policy.wtp.editor.model.ExactlyOneModel;
import org.eclipse.stp.policy.wtp.editor.model.commands.AddAllCommand;
import org.eclipse.stp.policy.wtp.editor.model.commands.AddAssertionCommand;
import org.eclipse.stp.policy.wtp.editor.model.commands.AddExactlyOneCommand;
import org.eclipse.stp.policy.wtp.editor.model.commands.DeletePolicyCompositeCommand;
import org.eclipse.wst.wsdl.ui.internal.adapters.WSDLBaseAdapter;
import org.eclipse.wst.wsdl.ui.internal.asd.outline.ITreeElement;
import org.eclipse.wst.wsdl.ui.internal.asd.util.IOpenExternalEditorHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PolicyCompositeModel
extends WSDLBaseAdapter {
    private PolicyComposite policyComposite;
    private PolicyCompositeModel parent;
    private boolean isReadOnly;
    List models = null;

    public PolicyCompositeModel(PolicyComposite composite, PolicyCompositeModel parent, boolean isReadOnly) {
        this.policyComposite = composite;
        this.parent = parent;
        this.isReadOnly = isReadOnly;
    }

    public ITreeElement getParent() {
        return this.parent;
    }

    public ITreeElement[] getChildren() {
        List<ITreeElement> models = this.getModelChildren();
        return models.toArray(new ITreeElement[models.size()]);
    }

    public boolean hasChildren() {
        return this.policyComposite.isEmpty();
    }

    public String[] getActions(Object object) {
        ArrayList<String> actions = new ArrayList<String>();
        if (!this.isReadOnly()) {
            actions.add("org.eclipse.stp.policy.wtp.editor.model.actions.AddAssertionAction");
            actions.add("org.eclipse.stp.policy.wtp.editor.model.actions.AddAllAction");
            actions.add("org.eclipse.stp.policy.wtp.editor.model.actions.AddExactlyOneAction");
        }
        return actions.toArray(new String[actions.size()]);
    }

    public List<ITreeElement> getModelChildren() {
        if (this.models == null) {
            List<PolicyComponent> children = this.policyComposite.getPolicyComponents();
            this.models = new ArrayList(children.size());
            for (PolicyComponent policyComponent : children) {
                if (policyComponent.getType() == 2) {
                    this.models.add(new ExactlyOneModel((ExactlyOne)policyComponent, this, this.isReadOnly()));
                    continue;
                }
                if (policyComponent.getType() == 3) {
                    this.models.add(new AllModel((All)policyComponent, this, this.isReadOnly()));
                    continue;
                }
                if (policyComponent.getType() == 5) {
                    this.models.add(new AssertionModel((Assertion)policyComponent, this, this.isReadOnly()));
                    continue;
                }
                if (policyComponent.getType() == 4) {
                    PolicyReference cfr_ignored_0 = (PolicyReference)policyComponent;
                    continue;
                }
                throw new IllegalArgumentException();
            }
        }
        return this.models;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public Command getAddPolicyAssertionCommand() {
        return new AddAssertionCommand(this);
    }

    public Command getAddAllCommand() {
        return new AddAllCommand(this);
    }

    public Command getAddExactlyOneCommand() {
        return new AddExactlyOneCommand(this);
    }

    public Command getDeletePolicyCompositeCommand() {
        return new DeletePolicyCompositeCommand(this);
    }

    public void addPolicyAssertion() {
        IOpenExternalEditorHelper openHelper = this.getExternalEditorOpener();
        if (openHelper != null) {
            openHelper.openExternalEditor();
        }
    }

    public AssertionModel createAssertion(QName assertionName) {
        AssertionModel assertionModel = new AssertionModel(this.policyComposite.createAssertion(assertionName), this, this.isReadOnly());
        this.models.add(assertionModel);
        return assertionModel;
    }

    public PolicyCompositeModel createAll() {
        AllModel allModel = new AllModel(this.policyComposite.createAll(), this, this.isReadOnly());
        this.models.add(allModel);
        return allModel;
    }

    public PolicyCompositeModel createExactlyOne() {
        ExactlyOneModel exactlyOneModel = new ExactlyOneModel(this.policyComposite.createExactlyOne(), this, this.isReadOnly());
        this.models.add(exactlyOneModel);
        return exactlyOneModel;
    }

    public void deleteAssertion(AssertionModel assertion) {
        this.policyComposite.removePolicyComponent(assertion.getAssertion());
        this.deletePolicyComponent((ITreeElement)assertion);
    }

    public void deletePolicyComposite() {
        this.parent.policyComposite.removePolicyComponent(this.policyComposite);
        this.parent.deletePolicyComponent((ITreeElement)this);
    }

    private void deletePolicyComponent(ITreeElement policyComponent) {
        this.models.remove(policyComponent);
    }

    public void deleteAll() {
        this.models = null;
    }

    private IOpenExternalEditorHelper getExternalEditorOpener() {
        IOpenExternalEditorHelper openExternalEditorHelper = XefOpenExternalEditorHelper.getExternalEditorOpener();
        if (openExternalEditorHelper != null) {
            openExternalEditorHelper.setModel((Object)this);
        }
        return openExternalEditorHelper;
    }

    public PolicyComposite getPolicyComposite() {
        return this.policyComposite;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PolicyCompositeModel) {
            return this.policyComposite.equals(((PolicyCompositeModel)((Object)obj)).policyComposite);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.policyComposite.hashCode();
    }
}

