/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.policy.wtp.common.utils.ui.EclipseUI;
import org.eclipse.stp.policy.wtp.editor.Messages;
import org.eclipse.stp.policy.wtp.editor.wizards.OperationPolicyWizardPage;
import org.eclipse.stp.policy.wtp.generator.wizards.OperationPolicyGenerationRunnable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.IWizardDescriptor;

public class OperationPolicyNewWizard
extends Wizard
implements INewWizard {
    private OperationPolicyWizardPage page;
    private ISelection selection;
    private String description = "";

    public OperationPolicyNewWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new OperationPolicyWizardPage(this.selection);
        this.page.setTitle(this.description);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        String containerName = this.page.getContainerName();
        String fileName = this.page.getFileName();
        String policyName = this.page.getPolicyName();
        String idName = this.page.getIdName();
        if (EclipseUI.isResourceInWorkspace((String)containerName, (String)fileName) && !EclipseUI.openOverwriteDialog((String)fileName)) {
            return false;
        }
        OperationPolicyGenerationRunnable op = new OperationPolicyGenerationRunnable(containerName, fileName, policyName, idName, false);
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.TITLE_ERROR, (String)realException.getMessage());
            return false;
        }
        EclipseUI.openEditor((IFile)EclipseUI.getIFile((String)containerName, (String)fileName));
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        IWizardDescriptor wizardDescriptor = workbench.getNewWizardRegistry().findWizard(((Object)((Object)this)).getClass().getName());
        if (wizardDescriptor != null) {
            this.setWindowTitle(wizardDescriptor.getLabel());
            this.description = wizardDescriptor.getDescription();
        }
    }
}

