/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.validation.impl;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stp.common.validator.core.BaseValidationObject;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.core.IValidationObject;
import org.eclipse.stp.common.validator.core.ValidationObjectID;
import org.eclipse.stp.common.validator.core.ValidationObjectTypeEnum;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;
import org.eclipse.stp.policy.wtp.validation.Logger;
import org.eclipse.stp.policy.wtp.validation.impl.IDEValidationContextFactory;
import org.w3c.dom.Document;

public class IDEValidationContext
implements IValidationContext {
    private IFile iContextFile = null;
    private File fExtFile = null;
    private Document document = null;
    private ValidationObjectTypeEnum docType = null;
    private Map props = new HashMap();

    public IDEValidationContext(IFile contextFile) {
        this.iContextFile = contextFile;
    }

    public IDEValidationContext(File extFile) {
        this.fExtFile = extFile;
    }

    public IDEValidationContext(Document doc, ValidationObjectTypeEnum type) {
        this.document = doc;
        this.docType = type;
    }

    public IValidationContext[] getAllNestedValidationContexts() {
        return null;
    }

    public IValidationContext getNestedValidationContext(ValidationObjectID pObjectID) {
        URI locationURI;
        URI fullObjectURI;
        IValidationContext nestedContext = null;
        IDEValidationContextFactory contextFactory = IDEValidationContextFactory.getInstance();
        URI nestedURI = pObjectID.getURI();
        if (nestedURI != null && this.iContextFile != null && (fullObjectURI = (locationURI = this.iContextFile.getLocationURI()).resolve(nestedURI)) != null) {
            try {
                File objFile = new File(fullObjectURI.getPath());
                nestedContext = contextFactory.createContext(objFile);
            }
            catch (ContextInitializationException e) {
                Logger.error("Unable to initialize nested context: " + e.getMessage(), e);
            }
        }
        return nestedContext;
    }

    public IValidationObject getObject() {
        BaseValidationObject valObj = null;
        ValidationObjectID objID = null;
        String path = null;
        if (this.document != null) {
            objID = new ValidationObjectID(null, null, null, this.docType);
            valObj = new BaseValidationObject(objID, this.document);
        } else {
            path = this.iContextFile != null ? this.iContextFile.getName().toUpperCase() : this.fExtFile.getName();
            ValidationObjectTypeEnum objType = BaseValidationObject.resolveObjectTypeFromFileName((String)path);
            InputStream inputStream = null;
            if (this.iContextFile != null) {
                try {
                    objID = new ValidationObjectID(this.iContextFile.getName(), new QName("", this.iContextFile.getName()), this.iContextFile.getLocationURI(), objType);
                    inputStream = this.iContextFile.getContents();
                    valObj = new BaseValidationObject(objID, inputStream);
                }
                catch (CoreException e) {
                    Logger.error("Unable to get the contents of the Eclipse resource", e);
                }
            } else {
                objID = new ValidationObjectID(this.fExtFile.getName(), new QName("", this.fExtFile.getName()), this.fExtFile.toURI(), objType);
                valObj = new BaseValidationObject(objID, this.fExtFile);
            }
        }
        return valObj;
    }

    public void setProperty(String propName, Object propObj) {
        this.props.put(propName, propObj);
    }

    public Object getProperty(String propName) {
        return this.props.get(propName);
    }
}

