/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.common.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.common.annotations.ext.AnnotationSupportProxy;
import org.eclipse.stp.sc.common.utils.JDTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScAnnotationSupportUtils {
    public static final LoggingProxy LOG = LoggingProxy.getlogger(ScAnnotationSupportUtils.class);

    protected ScAnnotationSupportUtils() {
    }

    public static List<Class> getAvailableAnnotationsForClass(IProject project) {
        List<Class> typeAnnotations = ScAnnotationSupportUtils.getAnnotationClassesForJavaElement(ElementType.TYPE, project);
        int i = 0;
        while (i < typeAnnotations.size()) {
            if (!ScAnnotationSupportUtils.isTypeAllowed(typeAnnotations.get(i), JavaTypes.CLASS)) {
                typeAnnotations.remove(i);
            }
            ++i;
        }
        return typeAnnotations;
    }

    public static List<Class> getAvailableAnnotationsForInterface(IProject project) {
        List<Class> typeAnnotations = ScAnnotationSupportUtils.getAnnotationClassesForJavaElement(ElementType.TYPE, project);
        Iterator<Class> itor = typeAnnotations.iterator();
        while (itor.hasNext()) {
            Class cls = itor.next();
            if (ScAnnotationSupportUtils.isTypeAllowed(cls, JavaTypes.INTERFACE)) continue;
            itor.remove();
        }
        return typeAnnotations;
    }

    public static List<Class> getAvailableAnnotationsForAnno(IProject project) {
        return ScAnnotationSupportUtils.getAnnotationClassesForJavaElement(ElementType.ANNOTATION_TYPE, project);
    }

    public static List<Class> getAvailableAnnotationsForType(IProject project) {
        return ScAnnotationSupportUtils.getAnnotationClassesForJavaElement(ElementType.TYPE, project);
    }

    public static List<Class> getAvailableAnnotationsForType(IProject project, IType type) {
        try {
            if (type.isClass()) {
                return ScAnnotationSupportUtils.getAvailableAnnotationsForClass(project);
            }
            if (type.isInterface()) {
                return ScAnnotationSupportUtils.getAvailableAnnotationsForInterface(project);
            }
        }
        catch (JavaModelException javaModelException) {
            LOG.error((Object)"error to check sub-types of java element type");
        }
        return ScAnnotationSupportUtils.getAvailableAnnotationsForType(project);
    }

    public static List<Class> getAvailableAnnotationsForField(IProject project) {
        return ScAnnotationSupportUtils.getAnnotationClassesForJavaElement(ElementType.FIELD, project);
    }

    public static List<Class> getAvailableAnnotationsForMethod(IProject project) {
        return ScAnnotationSupportUtils.getAnnotationClassesForJavaElement(ElementType.METHOD, project);
    }

    public static List<Class> getAvailableAnnotationsForParam(IProject project) {
        return ScAnnotationSupportUtils.getAnnotationClassesForJavaElement(ElementType.PARAMETER, project);
    }

    public static String getAnnotationImport(org.eclipse.jdt.core.dom.Annotation annotation) {
        String annotationName = annotation.getTypeName().toString();
        if (AnnotationSupportProxy.hasAnnotation(annotationName)) {
            return AnnotationSupportProxy.getAnnotationClass(annotationName).getCanonicalName();
        }
        return null;
    }

    public static Class getAnnotationClass(org.eclipse.jdt.core.dom.Annotation annotation) {
        String annotationName = annotation.getTypeName().toString();
        return AnnotationSupportProxy.getAnnotationClass(annotationName);
    }

    public static org.eclipse.jdt.core.dom.Annotation getDefaultedAnnotationNode(Class<? extends Annotation> annClass, CompilationUnit astRoot, IMember jdtMember, SingleVariableDeclaration jdtMemberParam) {
        if (!ScAnnotationSupportUtils.isAnnotationValidForMember(annClass, jdtMember, jdtMemberParam)) {
            return null;
        }
        List<MemberValuePair> annotValues = AnnotationSupportProxy.getDefaultAttributes(annClass, astRoot, jdtMember, jdtMemberParam);
        return JDTUtils.newNormalAnnotation(astRoot, annClass.getSimpleName(), annotValues);
    }

    private static boolean isAnnotationValidForMember(Class annotationClass, IMember jdtMember, SingleVariableDeclaration jdtMemberParam) {
        IProject project;
        block4: {
            project = null;
            if (jdtMember != null) break block4;
            return false;
        }
        try {
            project = jdtMember.getUnderlyingResource().getProject();
            if (project == null) {
                return false;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"error to get project", (Throwable)e);
        }
        return jdtMember instanceof IMethod && ScAnnotationSupportUtils.getAvailableAnnotationsForMethod(project).contains(annotationClass) || jdtMember instanceof IType && ScAnnotationSupportUtils.getAvailableAnnotationsForType(project, (IType)jdtMember).contains(annotationClass) || jdtMember instanceof IField && ScAnnotationSupportUtils.getAvailableAnnotationsForField(project).contains(annotationClass) || ScAnnotationSupportUtils.getAvailableAnnotationsForParam(project).contains(annotationClass) && jdtMemberParam != null;
    }

    private static List<Class> getAnnotationClassesForJavaElement(ElementType aType, IProject project) {
        ArrayList<Class> theList = new ArrayList<Class>();
        Iterator<Class<? extends Annotation>> iter = AnnotationSupportProxy.getAllAnnotationClasses();
        while (iter.hasNext()) {
            Class<? extends Annotation> nextAnnotationClass = iter.next();
            Target annotationTarget = nextAnnotationClass.getAnnotation(Target.class);
            ElementType[] targetedTypes = annotationTarget.value();
            int i = 0;
            while (i < targetedTypes.length) {
                if (targetedTypes[i] == aType) {
                    String[] natureIDs = new String[]{};
                    try {
                        natureIDs = project.getDescription().getNatureIds();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"error during get project nature", (Throwable)e);
                    }
                    if (AnnotationSupportProxy.verifyNature(nextAnnotationClass.getName(), natureIDs)) {
                        theList.add(nextAnnotationClass);
                    }
                }
                ++i;
            }
            if (targetedTypes.length != 0) continue;
            theList.add(nextAnnotationClass);
        }
        return theList;
    }

    private static boolean isTypeAllowed(Class anno, JavaTypes type) {
        boolean classOnly = AnnotationSupportProxy.isClassOnly(anno.getCanonicalName());
        boolean interfaceOnly = AnnotationSupportProxy.isInterfaceOnly(anno.getCanonicalName());
        if (classOnly && type != JavaTypes.CLASS) {
            return false;
        }
        return !interfaceOnly || type == JavaTypes.INTERFACE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JavaTypes {
        ENUM,
        CLASS,
        INTERFACE,
        ANNOTATION;

    }
}

