/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.sca.diagram.navigator.ScaAbstractNavigatorItem;
import org.eclipse.stp.sca.diagram.navigator.ScaNavigatorGroup;
import org.eclipse.stp.sca.diagram.navigator.ScaNavigatorItem;
import org.eclipse.stp.sca.diagram.part.Messages;
import org.eclipse.stp.sca.diagram.part.ScaVisualIDRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class ScaNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public ScaNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            public void run() {
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : ScaNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ScaNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : ScaNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ScaNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : ScaNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ScaNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            result.addAll(this.createNavigatorItems(this.selectViewsByType((Collection)resource.getContents(), "Sca"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof ScaNavigatorGroup) {
            ScaNavigatorGroup group = (ScaNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof ScaNavigatorItem) {
            ScaNavigatorItem navigatorItem = (ScaNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (ScaVisualIDRegistry.getVisualID(view)) {
            case 79: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup links = new ScaNavigatorGroup(Messages.NavigatorGroupName_DocumentRoot_79_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 1001);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 3001);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 3002);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 3003);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 3004);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
            case 1001: {
                ArrayList result = new ArrayList();
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5001);
                connectedViews = this.getChildrenByType(connectedViews, 2001);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5002);
                connectedViews = this.getChildrenByType(connectedViews, 2015);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5003);
                connectedViews = this.getChildrenByType(connectedViews, 2029);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5004);
                connectedViews = this.getChildrenByType(connectedViews, 2030);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
            case 2001: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup outgoinglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_Service_2001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup incominglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_Service_2001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5005);
                connectedViews = this.getChildrenByType(connectedViews, 2002);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5005);
                connectedViews = this.getChildrenByType(connectedViews, 2003);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5005);
                connectedViews = this.getChildrenByType(connectedViews, 2004);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5006);
                connectedViews = this.getChildrenByType(connectedViews, 2005);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5006);
                connectedViews = this.getChildrenByType(connectedViews, 2006);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5006);
                connectedViews = this.getChildrenByType(connectedViews, 2007);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5006);
                connectedViews = this.getChildrenByType(connectedViews, 2008);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5006);
                connectedViews = this.getChildrenByType(connectedViews, 2009);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5006);
                connectedViews = this.getChildrenByType(connectedViews, 2010);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5006);
                connectedViews = this.getChildrenByType(connectedViews, 2011);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5006);
                connectedViews = this.getChildrenByType(connectedViews, 2012);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5006);
                connectedViews = this.getChildrenByType(connectedViews, 2013);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5006);
                connectedViews = this.getChildrenByType(connectedViews, 2014);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 3002);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3004);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2015: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup outgoinglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_Reference_2015_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5007);
                connectedViews = this.getChildrenByType(connectedViews, 2016);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5007);
                connectedViews = this.getChildrenByType(connectedViews, 2017);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5007);
                connectedViews = this.getChildrenByType(connectedViews, 2018);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5008);
                connectedViews = this.getChildrenByType(connectedViews, 2019);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5008);
                connectedViews = this.getChildrenByType(connectedViews, 2020);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5008);
                connectedViews = this.getChildrenByType(connectedViews, 2021);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5008);
                connectedViews = this.getChildrenByType(connectedViews, 2022);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5008);
                connectedViews = this.getChildrenByType(connectedViews, 2023);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5008);
                connectedViews = this.getChildrenByType(connectedViews, 2024);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5008);
                connectedViews = this.getChildrenByType(connectedViews, 2025);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5008);
                connectedViews = this.getChildrenByType(connectedViews, 2026);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5008);
                connectedViews = this.getChildrenByType(connectedViews, 2027);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5008);
                connectedViews = this.getChildrenByType(connectedViews, 2028);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 3001);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 3004);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 2030: {
                ArrayList result = new ArrayList();
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5009);
                connectedViews = this.getChildrenByType(connectedViews, 2031);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5011);
                connectedViews = this.getChildrenByType(connectedViews, 2045);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5012);
                connectedViews = this.getChildrenByType(connectedViews, 2059);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5010);
                connectedViews = this.getChildrenByType(connectedViews, 2060);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5010);
                connectedViews = this.getChildrenByType(connectedViews, 2061);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5010);
                connectedViews = this.getChildrenByType(connectedViews, 2062);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5010);
                connectedViews = this.getChildrenByType(connectedViews, 2063);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5010);
                connectedViews = this.getChildrenByType(connectedViews, 2064);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5010);
                connectedViews = this.getChildrenByType(connectedViews, 2065);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5010);
                connectedViews = this.getChildrenByType(connectedViews, 2066);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5010);
                connectedViews = this.getChildrenByType(connectedViews, 2067);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5010);
                connectedViews = this.getChildrenByType(connectedViews, 2068);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
            case 2031: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup incominglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_ComponentService_2031_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5013);
                connectedViews = this.getChildrenByType(connectedViews, 2032);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5013);
                connectedViews = this.getChildrenByType(connectedViews, 2033);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5013);
                connectedViews = this.getChildrenByType(connectedViews, 2034);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5014);
                connectedViews = this.getChildrenByType(connectedViews, 2035);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5014);
                connectedViews = this.getChildrenByType(connectedViews, 2036);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5014);
                connectedViews = this.getChildrenByType(connectedViews, 2037);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5014);
                connectedViews = this.getChildrenByType(connectedViews, 2038);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5014);
                connectedViews = this.getChildrenByType(connectedViews, 2039);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5014);
                connectedViews = this.getChildrenByType(connectedViews, 2040);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5014);
                connectedViews = this.getChildrenByType(connectedViews, 2041);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5014);
                connectedViews = this.getChildrenByType(connectedViews, 2042);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5014);
                connectedViews = this.getChildrenByType(connectedViews, 2043);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5014);
                connectedViews = this.getChildrenByType(connectedViews, 2044);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3002);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3003);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3004);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 2045: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup incominglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_ComponentReference_2045_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup outgoinglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_ComponentReference_2045_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 5015);
                connectedViews = this.getChildrenByType(connectedViews, 2046);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5015);
                connectedViews = this.getChildrenByType(connectedViews, 2047);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5015);
                connectedViews = this.getChildrenByType(connectedViews, 2048);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5016);
                connectedViews = this.getChildrenByType(connectedViews, 2049);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5016);
                connectedViews = this.getChildrenByType(connectedViews, 2050);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5016);
                connectedViews = this.getChildrenByType(connectedViews, 2051);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5016);
                connectedViews = this.getChildrenByType(connectedViews, 2052);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5016);
                connectedViews = this.getChildrenByType(connectedViews, 2053);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5016);
                connectedViews = this.getChildrenByType(connectedViews, 2054);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5016);
                connectedViews = this.getChildrenByType(connectedViews, 2055);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5016);
                connectedViews = this.getChildrenByType(connectedViews, 2056);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5016);
                connectedViews = this.getChildrenByType(connectedViews, 2057);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 5016);
                connectedViews = this.getChildrenByType(connectedViews, 2058);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 3001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 3003);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 3004);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3001: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup target = new ScaNavigatorGroup(Messages.NavigatorGroupName_ReferencePromote2_3001_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup source = new ScaNavigatorGroup(Messages.NavigatorGroupName_ReferencePromote2_3001_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2045);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2015);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 3002: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup target = new ScaNavigatorGroup(Messages.NavigatorGroupName_ServicePromote2_3002_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup source = new ScaNavigatorGroup(Messages.NavigatorGroupName_ServicePromote2_3002_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2031);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2001);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 3003: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup target = new ScaNavigatorGroup(Messages.NavigatorGroupName_Wire_3003_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup source = new ScaNavigatorGroup(Messages.NavigatorGroupName_Wire_3003_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2031);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2045);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 3004: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup target = new ScaNavigatorGroup(Messages.NavigatorGroupName_BaseReferenceTarget2_3004_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup source = new ScaNavigatorGroup(Messages.NavigatorGroupName_BaseReferenceTarget2_3004_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2001);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 2031);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2015);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 2045);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection edges, int visualID) {
        ArrayList<View> result = new ArrayList<View>();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, int visualID) {
        ArrayList<View> result = new ArrayList<View>();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection getIncomingLinksByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getChildrenByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, int visualID) {
        ArrayList result = new ArrayList();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Sca".equals(ScaVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<ScaNavigatorItem> result = new ArrayList<ScaNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new ScaNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof ScaAbstractNavigatorItem) {
            ScaAbstractNavigatorItem abstractNavigatorItem = (ScaAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

