/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.ScaPackage;
import org.eclipse.stp.sca.diagram.part.ScaDiagramEditorPlugin;

public class ScaVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(ScaDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Sca".equals(view.getType())) {
                return 79;
            }
            return -1;
        }
        return ScaVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                ScaDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return String.valueOf(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ScaPackage.eINSTANCE.getDocumentRoot().isSuperTypeOf(domainElement.eClass()) && ScaVisualIDRegistry.isDiagram((DocumentRoot)domainElement)) {
            return 79;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = ScaVisualIDRegistry.getModelID(containerView);
        if (!"Sca".equals(containerModelID)) {
            return -1;
        }
        if ("Sca".equals(containerModelID)) {
            containerVisualID = ScaVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 5001: {
                if (!ScaPackage.eINSTANCE.getService().isSuperTypeOf(domainElement.eClass())) break;
                return 2001;
            }
            case 5002: {
                if (!ScaPackage.eINSTANCE.getReference().isSuperTypeOf(domainElement.eClass())) break;
                return 2015;
            }
            case 5003: {
                if (!ScaPackage.eINSTANCE.getProperty().isSuperTypeOf(domainElement.eClass())) break;
                return 2029;
            }
            case 5004: {
                if (!ScaPackage.eINSTANCE.getComponent().isSuperTypeOf(domainElement.eClass())) break;
                return 2030;
            }
            case 5005: {
                if (ScaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2002;
                }
                if (ScaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 2003;
                }
                if (!ScaPackage.eINSTANCE.getBpelPartnerLinkType().isSuperTypeOf(domainElement.eClass())) break;
                return 2004;
            }
            case 5006: {
                if (ScaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2005;
                }
                if (ScaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2006;
                }
                if (ScaPackage.eINSTANCE.getRMIBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2007;
                }
                if (ScaPackage.eINSTANCE.getAtomBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2008;
                }
                if (ScaPackage.eINSTANCE.getDWRBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2009;
                }
                if (ScaPackage.eINSTANCE.getHTTPBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2010;
                }
                if (ScaPackage.eINSTANCE.getJSONRPCBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2011;
                }
                if (ScaPackage.eINSTANCE.getNotificationBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2012;
                }
                if (ScaPackage.eINSTANCE.getRSSBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2013;
                }
                if (!ScaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 2014;
            }
            case 5007: {
                if (ScaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2016;
                }
                if (ScaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 2017;
                }
                if (!ScaPackage.eINSTANCE.getBpelPartnerLinkType().isSuperTypeOf(domainElement.eClass())) break;
                return 2018;
            }
            case 5008: {
                if (ScaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2019;
                }
                if (ScaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2020;
                }
                if (ScaPackage.eINSTANCE.getRMIBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2021;
                }
                if (ScaPackage.eINSTANCE.getAtomBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2022;
                }
                if (ScaPackage.eINSTANCE.getDWRBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2023;
                }
                if (ScaPackage.eINSTANCE.getHTTPBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2024;
                }
                if (ScaPackage.eINSTANCE.getJSONRPCBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2025;
                }
                if (ScaPackage.eINSTANCE.getNotificationBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2026;
                }
                if (ScaPackage.eINSTANCE.getRSSBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2027;
                }
                if (!ScaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 2028;
            }
            case 5009: {
                if (!ScaPackage.eINSTANCE.getComponentService().isSuperTypeOf(domainElement.eClass())) break;
                return 2031;
            }
            case 5010: {
                if (ScaPackage.eINSTANCE.getJavaImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 2060;
                }
                if (ScaPackage.eINSTANCE.getSCAImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 2061;
                }
                if (ScaPackage.eINSTANCE.getScriptImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 2062;
                }
                if (ScaPackage.eINSTANCE.getXQueryImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 2063;
                }
                if (ScaPackage.eINSTANCE.getNotificationImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 2064;
                }
                if (ScaPackage.eINSTANCE.getResourceImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 2065;
                }
                if (ScaPackage.eINSTANCE.getOSGiImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 2066;
                }
                if (ScaPackage.eINSTANCE.getSpringImplementation().isSuperTypeOf(domainElement.eClass())) {
                    return 2067;
                }
                if (!ScaPackage.eINSTANCE.getBpelImplementation().isSuperTypeOf(domainElement.eClass())) break;
                return 2068;
            }
            case 5011: {
                if (!ScaPackage.eINSTANCE.getComponentReference().isSuperTypeOf(domainElement.eClass())) break;
                return 2045;
            }
            case 5012: {
                if (!ScaPackage.eINSTANCE.getPropertyValue().isSuperTypeOf(domainElement.eClass())) break;
                return 2059;
            }
            case 5013: {
                if (ScaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2032;
                }
                if (ScaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 2033;
                }
                if (!ScaPackage.eINSTANCE.getBpelPartnerLinkType().isSuperTypeOf(domainElement.eClass())) break;
                return 2034;
            }
            case 5014: {
                if (ScaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2035;
                }
                if (ScaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2036;
                }
                if (ScaPackage.eINSTANCE.getRMIBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2037;
                }
                if (ScaPackage.eINSTANCE.getAtomBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2038;
                }
                if (ScaPackage.eINSTANCE.getDWRBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2039;
                }
                if (ScaPackage.eINSTANCE.getHTTPBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2040;
                }
                if (ScaPackage.eINSTANCE.getJSONRPCBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2041;
                }
                if (ScaPackage.eINSTANCE.getNotificationBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2042;
                }
                if (ScaPackage.eINSTANCE.getRSSBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2043;
                }
                if (!ScaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 2044;
            }
            case 5015: {
                if (ScaPackage.eINSTANCE.getJavaInterface().isSuperTypeOf(domainElement.eClass())) {
                    return 2046;
                }
                if (ScaPackage.eINSTANCE.getWSDLPortType().isSuperTypeOf(domainElement.eClass())) {
                    return 2047;
                }
                if (!ScaPackage.eINSTANCE.getBpelPartnerLinkType().isSuperTypeOf(domainElement.eClass())) break;
                return 2048;
            }
            case 5016: {
                if (ScaPackage.eINSTANCE.getSCABinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2049;
                }
                if (ScaPackage.eINSTANCE.getWebServiceBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2050;
                }
                if (ScaPackage.eINSTANCE.getRMIBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2051;
                }
                if (ScaPackage.eINSTANCE.getAtomBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2052;
                }
                if (ScaPackage.eINSTANCE.getDWRBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2053;
                }
                if (ScaPackage.eINSTANCE.getHTTPBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2054;
                }
                if (ScaPackage.eINSTANCE.getJSONRPCBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2055;
                }
                if (ScaPackage.eINSTANCE.getNotificationBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2056;
                }
                if (ScaPackage.eINSTANCE.getRSSBinding().isSuperTypeOf(domainElement.eClass())) {
                    return 2057;
                }
                if (!ScaPackage.eINSTANCE.getEJBSessionBeanBinding().isSuperTypeOf(domainElement.eClass())) break;
                return 2058;
            }
            case 79: {
                if (!ScaPackage.eINSTANCE.getComposite().isSuperTypeOf(domainElement.eClass())) break;
                return 1001;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = ScaVisualIDRegistry.getModelID(containerView);
        if (!"Sca".equals(containerModelID)) {
            return false;
        }
        if ("Sca".equals(containerModelID)) {
            containerVisualID = ScaVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 79;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1001: {
                if (4008 == nodeVisualID) {
                    return true;
                }
                if (5001 == nodeVisualID) {
                    return true;
                }
                if (5002 == nodeVisualID) {
                    return true;
                }
                if (5003 == nodeVisualID) {
                    return true;
                }
                if (5004 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (4001 == nodeVisualID) {
                    return true;
                }
                if (5005 == nodeVisualID) {
                    return true;
                }
                if (5006 != nodeVisualID) break;
                return true;
            }
            case 2015: {
                if (4002 == nodeVisualID) {
                    return true;
                }
                if (5007 == nodeVisualID) {
                    return true;
                }
                if (5008 != nodeVisualID) break;
                return true;
            }
            case 2029: {
                if (4003 != nodeVisualID) break;
                return true;
            }
            case 2030: {
                if (4007 == nodeVisualID) {
                    return true;
                }
                if (5009 == nodeVisualID) {
                    return true;
                }
                if (5010 == nodeVisualID) {
                    return true;
                }
                if (5011 == nodeVisualID) {
                    return true;
                }
                if (5012 != nodeVisualID) break;
                return true;
            }
            case 2031: {
                if (4004 == nodeVisualID) {
                    return true;
                }
                if (5013 == nodeVisualID) {
                    return true;
                }
                if (5014 != nodeVisualID) break;
                return true;
            }
            case 2045: {
                if (4005 == nodeVisualID) {
                    return true;
                }
                if (5015 == nodeVisualID) {
                    return true;
                }
                if (5016 != nodeVisualID) break;
                return true;
            }
            case 2059: {
                if (4006 != nodeVisualID) break;
                return true;
            }
            case 5001: {
                if (2001 != nodeVisualID) break;
                return true;
            }
            case 5002: {
                if (2015 != nodeVisualID) break;
                return true;
            }
            case 5003: {
                if (2029 != nodeVisualID) break;
                return true;
            }
            case 5004: {
                if (2030 != nodeVisualID) break;
                return true;
            }
            case 5005: {
                if (2002 == nodeVisualID) {
                    return true;
                }
                if (2003 == nodeVisualID) {
                    return true;
                }
                if (2004 != nodeVisualID) break;
                return true;
            }
            case 5006: {
                if (2005 == nodeVisualID) {
                    return true;
                }
                if (2006 == nodeVisualID) {
                    return true;
                }
                if (2007 == nodeVisualID) {
                    return true;
                }
                if (2008 == nodeVisualID) {
                    return true;
                }
                if (2009 == nodeVisualID) {
                    return true;
                }
                if (2010 == nodeVisualID) {
                    return true;
                }
                if (2011 == nodeVisualID) {
                    return true;
                }
                if (2012 == nodeVisualID) {
                    return true;
                }
                if (2013 == nodeVisualID) {
                    return true;
                }
                if (2014 != nodeVisualID) break;
                return true;
            }
            case 5007: {
                if (2016 == nodeVisualID) {
                    return true;
                }
                if (2017 == nodeVisualID) {
                    return true;
                }
                if (2018 != nodeVisualID) break;
                return true;
            }
            case 5008: {
                if (2019 == nodeVisualID) {
                    return true;
                }
                if (2020 == nodeVisualID) {
                    return true;
                }
                if (2021 == nodeVisualID) {
                    return true;
                }
                if (2022 == nodeVisualID) {
                    return true;
                }
                if (2023 == nodeVisualID) {
                    return true;
                }
                if (2024 == nodeVisualID) {
                    return true;
                }
                if (2025 == nodeVisualID) {
                    return true;
                }
                if (2026 == nodeVisualID) {
                    return true;
                }
                if (2027 == nodeVisualID) {
                    return true;
                }
                if (2028 != nodeVisualID) break;
                return true;
            }
            case 5009: {
                if (2031 != nodeVisualID) break;
                return true;
            }
            case 5010: {
                if (2060 == nodeVisualID) {
                    return true;
                }
                if (2061 == nodeVisualID) {
                    return true;
                }
                if (2062 == nodeVisualID) {
                    return true;
                }
                if (2063 == nodeVisualID) {
                    return true;
                }
                if (2064 == nodeVisualID) {
                    return true;
                }
                if (2065 == nodeVisualID) {
                    return true;
                }
                if (2066 == nodeVisualID) {
                    return true;
                }
                if (2067 == nodeVisualID) {
                    return true;
                }
                if (2068 != nodeVisualID) break;
                return true;
            }
            case 5011: {
                if (2045 != nodeVisualID) break;
                return true;
            }
            case 5012: {
                if (2059 != nodeVisualID) break;
                return true;
            }
            case 5013: {
                if (2032 == nodeVisualID) {
                    return true;
                }
                if (2033 == nodeVisualID) {
                    return true;
                }
                if (2034 != nodeVisualID) break;
                return true;
            }
            case 5014: {
                if (2035 == nodeVisualID) {
                    return true;
                }
                if (2036 == nodeVisualID) {
                    return true;
                }
                if (2037 == nodeVisualID) {
                    return true;
                }
                if (2038 == nodeVisualID) {
                    return true;
                }
                if (2039 == nodeVisualID) {
                    return true;
                }
                if (2040 == nodeVisualID) {
                    return true;
                }
                if (2041 == nodeVisualID) {
                    return true;
                }
                if (2042 == nodeVisualID) {
                    return true;
                }
                if (2043 == nodeVisualID) {
                    return true;
                }
                if (2044 != nodeVisualID) break;
                return true;
            }
            case 5015: {
                if (2046 == nodeVisualID) {
                    return true;
                }
                if (2047 == nodeVisualID) {
                    return true;
                }
                if (2048 != nodeVisualID) break;
                return true;
            }
            case 5016: {
                if (2049 == nodeVisualID) {
                    return true;
                }
                if (2050 == nodeVisualID) {
                    return true;
                }
                if (2051 == nodeVisualID) {
                    return true;
                }
                if (2052 == nodeVisualID) {
                    return true;
                }
                if (2053 == nodeVisualID) {
                    return true;
                }
                if (2054 == nodeVisualID) {
                    return true;
                }
                if (2055 == nodeVisualID) {
                    return true;
                }
                if (2056 == nodeVisualID) {
                    return true;
                }
                if (2057 == nodeVisualID) {
                    return true;
                }
                if (2058 != nodeVisualID) break;
                return true;
            }
            case 79: {
                if (1001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ScaPackage.eINSTANCE.getWire().isSuperTypeOf(domainElement.eClass())) {
            return 3003;
        }
        return -1;
    }

    private static boolean isDiagram(DocumentRoot element) {
        return true;
    }
}

