/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.stp.sca.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaResourceImpl
extends XMLResourceImpl {
    private static final String PLUGIN_ID = "org.eclipse.stp.sca";

    public ScaResourceImpl(URI uri) {
        super(uri);
    }

    public void load(Map<?, ?> options) throws IOException {
        if (!this.isLoaded) {
            URIConverter uriConverter = this.getURIConverter();
            URL tuscany2ScaURL = FileLocator.toFileURL((URL)new URL("platform:/plugin/org.eclipse.stp.sca/xslt/tuscany2sca.xsl"));
            File tuscany2ScaFile = new File(tuscany2ScaURL.getPath());
            StreamSource xsltSource = new StreamSource(tuscany2ScaFile);
            InputStream inputStream = null;
            File tmpFileDefault = null;
            if (this.isFileEmpty()) {
                try {
                    EcorePlugin.getPlugin().log((Object)new Status(2, PLUGIN_ID, String.valueOf(Messages.ScaResourceImpl_1) + " (" + this.getURI().path() + ")", null));
                    tmpFileDefault = File.createTempFile("DefaultCompositeFile", null);
                    inputStream = this.createDefaultInputStream(tmpFileDefault);
                }
                catch (IOException e1) {
                    EcorePlugin.getPlugin().log((Object)new Status(2, PLUGIN_ID, e1.getMessage(), (Throwable)e1));
                }
            } else {
                inputStream = uriConverter.createInputStream(this.getURI());
            }
            StreamSource inputSource = new StreamSource(inputStream);
            File tmpFile = File.createTempFile("Tuscany2SCA", null);
            URI temporaryFileURI = URI.createFileURI((String)tmpFile.getPath());
            OutputStream temporaryFileOutputStream = uriConverter.createOutputStream(temporaryFileURI);
            StreamResult outputSource = new StreamResult(temporaryFileOutputStream);
            TransformerFactory transFact = TransformerFactory.newInstance();
            try {
                Transformer trans = transFact.newTransformer(xsltSource);
                trans.transform(inputSource, outputSource);
            }
            catch (Exception e) {
                EcorePlugin.getPlugin().log((Object)new Status(2, PLUGIN_ID, e.getMessage(), (Throwable)e));
            }
            inputStream.close();
            temporaryFileOutputStream.close();
            inputStream = uriConverter.createInputStream(temporaryFileURI);
            try {
                this.load(inputStream, options);
            }
            finally {
                inputStream.close();
            }
            tmpFile.delete();
            if (tmpFileDefault != null) {
                tmpFileDefault.delete();
            }
        }
    }

    private InputStream createDefaultInputStream(File tmpFile) {
        InputStream result;
        block12: {
            result = null;
            URI temporaryFileURI = URI.createFileURI((String)tmpFile.getPath());
            OutputStream fileOutput = null;
            try {
                try {
                    fileOutput = this.getURIConverter().createOutputStream(temporaryFileURI);
                    String s = "<?xml version=\"1.0\" encoding=\"ISO-8859-15\"?> \n <sca:composite xmlns:sca=\"http://www.osoa.org/xmlns/sca/1.0\" name=\"";
                    s = String.valueOf(s) + this.getURI().lastSegment().replace(this.getURI().fileExtension(), "").replace(".", "");
                    s = String.valueOf(s) + "\"/>";
                    fileOutput.write(s.getBytes());
                    fileOutput.flush();
                    result = this.getURIConverter().createInputStream(temporaryFileURI);
                }
                catch (IOException e) {
                    EcorePlugin.getPlugin().log((Object)new Status(2, PLUGIN_ID, e.getMessage(), (Throwable)e));
                    if (fileOutput == null) break block12;
                    try {
                        fileOutput.close();
                    }
                    catch (IOException e2) {
                        EcorePlugin.getPlugin().log((Object)new Status(2, PLUGIN_ID, e2.getMessage(), (Throwable)e2));
                    }
                }
            }
            finally {
                if (fileOutput != null) {
                    try {
                        fileOutput.close();
                    }
                    catch (IOException e) {
                        EcorePlugin.getPlugin().log((Object)new Status(2, PLUGIN_ID, e.getMessage(), (Throwable)e));
                    }
                }
            }
        }
        return result;
    }

    private boolean isFileEmpty() {
        boolean isEmpty;
        block12: {
            isEmpty = false;
            InputStream fileInput = null;
            try {
                try {
                    fileInput = this.getURIConverter().createInputStream(this.getURI());
                    isEmpty = fileInput.read() == -1;
                }
                catch (IOException e) {
                    EcorePlugin.getPlugin().log((Object)new Status(2, PLUGIN_ID, e.getMessage(), (Throwable)e));
                    if (fileInput == null) break block12;
                    try {
                        fileInput.close();
                    }
                    catch (IOException e2) {
                        EcorePlugin.getPlugin().log((Object)new Status(2, PLUGIN_ID, e2.getMessage(), (Throwable)e2));
                    }
                }
            }
            finally {
                if (fileInput != null) {
                    try {
                        fileInput.close();
                    }
                    catch (IOException e) {
                        EcorePlugin.getPlugin().log((Object)new Status(2, PLUGIN_ID, e.getMessage(), (Throwable)e));
                    }
                }
            }
        }
        return isEmpty;
    }

    public void save(Map<?, ?> options) throws IOException {
        super.save(options);
        URIConverter uriConverter = this.getURIConverter();
        URL Sca2TuscanyURL = FileLocator.toFileURL((URL)new URL("platform:/plugin/org.eclipse.stp.sca/xslt/sca2tuscany.xsl"));
        File Sca2TuscanyFile = new File(Sca2TuscanyURL.getPath());
        StreamSource xsltSource = new StreamSource(Sca2TuscanyFile);
        InputStream inputStream = uriConverter.createInputStream(this.getURI());
        StreamSource inputSource = new StreamSource(inputStream);
        File tmpFile = File.createTempFile("SCA2Tuscany", null);
        URI temporaryFileURI = URI.createFileURI((String)tmpFile.getPath());
        OutputStream temporaryFileOutputStream = uriConverter.createOutputStream(temporaryFileURI);
        StreamResult outputSource = new StreamResult(temporaryFileOutputStream);
        TransformerFactory transFact = TransformerFactory.newInstance();
        try {
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(inputSource, outputSource);
        }
        catch (Exception e) {
            EcorePlugin.getPlugin().log((Object)new Status(2, PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
        temporaryFileOutputStream.close();
        inputStream.close();
        try {
            temporaryFileURI = URI.createFileURI((String)tmpFile.getPath());
            inputStream = uriConverter.createInputStream(temporaryFileURI);
            OutputStream outputStream = uriConverter.createOutputStream(this.getURI());
            BufferedInputStream inBuffer = new BufferedInputStream(inputStream);
            BufferedOutputStream outBuffer = new BufferedOutputStream(outputStream);
            int theByte = 0;
            while ((theByte = inBuffer.read()) > -1) {
                outBuffer.write(theByte);
            }
            outBuffer.flush();
            outBuffer.close();
            inBuffer.close();
            outputStream.flush();
            outputStream.close();
            inputStream.close();
        }
        catch (Exception e) {
            EcorePlugin.getPlugin().log((Object)new Status(2, PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
        tmpFile.delete();
    }
}

