/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackageExtension;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.IPackageConfiguration;
import org.eclipse.stp.soas.deploy.core.IPackageConfigurationManager;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.core.ui.configuration.ConfigurationDialog;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployFilePackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.ui.TargetMapTreeViewer;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.Dialog;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.IDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.PackageSelectionDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.ServerSelectionDialogPage;
import org.eclipse.stp.soas.internal.deploy.ui.editors.DeployEditorSectionPart;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.help.HelpUtilities;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class TargetMapSection
extends DeployEditorSectionPart {
    public static final String SECTION_TITLE = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.SECTITLE.TargetMap");
    public static final String SECTION_DESC = DeployCorePlugin.getDefault().getResourceString("DeployDefinitionEditor.SECDESC.TargetMap");
    public static final String LABEL_PACKAGES = DeployCorePlugin.getDefault().getResourceString("LABEL.Packages");
    public static final String LABEL_ADD_PACKAGE = DeployCorePlugin.getDefault().getResourceString("BUTTON.AddPackage");
    public static final String LABEL_REMOVE_PACKAGE = DeployCorePlugin.getDefault().getResourceString("BUTTON.RemovePackage");
    public static final String LABEL_ADD_TARGET = DeployCorePlugin.getDefault().getResourceString("BUTTON.AddTarget");
    public static final String LABEL_CHANGE_TARGET = DeployCorePlugin.getDefault().getResourceString("BUTTON.ChangeTarget");
    public static final String LABEL_REMOVE_TARGET = DeployCorePlugin.getDefault().getResourceString("BUTTON.RemoveTarget");
    public static final String LABEL_CONFIGURE = DeployCorePlugin.getDefault().getResourceString("BUTTON.ConfigurePackage");
    public static final String LABEL_VALIDATE = DeployCorePlugin.getDefault().getResourceString("BUTTON.ValidateConfiguration");
    private static final int TYPE_PACKAGE = 2;
    private static final int TYPE_TARGET = 4;
    private static final int TYPE_MIXED = 6;
    private TargetMapTreeViewer mTargetMapViewer;
    private Button mRemoveButton;
    private Button mAddTargetButton;
    private Button mChangeTargetButton;
    private Button mRemoveTargetButton;
    private Button mConfigureButton;

    public TargetMapSection(Composite parent, FormToolkit toolkit, int style) {
        super(parent, toolkit, style);
        this.getSection().setText(SECTION_TITLE);
        this.getSection().setDescription(SECTION_DESC);
    }

    public void createClient(FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)this.getSection());
        GridLayout layout = EnhancedFormEditor.newSectionGridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        Label label = toolkit.createLabel(container, LABEL_PACKAGES);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Tree tree = toolkit.createTree(container, 66304);
        this.mTargetMapViewer = new TargetMapTreeViewer(tree);
        gd = new GridData(1808);
        gd.heightHint = tree.getItemHeight() * 5;
        gd.verticalSpan = 8;
        this.mTargetMapViewer.getViewer().getControl().setLayoutData((Object)gd);
        this.mTargetMapViewer.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TargetMapSection.this.handleTargetMapSelectionChanged(event);
            }
        });
        this.mTargetMapViewer.getViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TargetMapSection.this.handleTargetMapDoubleClick(event);
            }
        });
        Button button = toolkit.createButton(container, LABEL_ADD_PACKAGE, 8);
        gd = new GridData(258);
        button.setLayoutData((Object)gd);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetMapSection.this.handleAddPackage();
            }
        });
        this.mRemoveButton = toolkit.createButton(container, LABEL_REMOVE_PACKAGE, 8);
        gd = new GridData(258);
        this.mRemoveButton.setLayoutData((Object)gd);
        this.mRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetMapSection.this.handleRemovePackage();
            }
        });
        label = toolkit.createSeparator(container, 256);
        gd = new GridData(260);
        label.setLayoutData((Object)gd);
        this.mAddTargetButton = toolkit.createButton(container, LABEL_ADD_TARGET, 8);
        gd = new GridData(258);
        this.mAddTargetButton.setLayoutData((Object)gd);
        this.mAddTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetMapSection.this.handleAddTarget();
            }
        });
        this.mChangeTargetButton = toolkit.createButton(container, LABEL_CHANGE_TARGET, 8);
        gd = new GridData(258);
        this.mChangeTargetButton.setLayoutData((Object)gd);
        this.mChangeTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetMapSection.this.handleChangeTarget();
            }
        });
        this.mRemoveTargetButton = toolkit.createButton(container, LABEL_REMOVE_TARGET, 8);
        gd = new GridData(258);
        this.mRemoveTargetButton.setLayoutData((Object)gd);
        this.mRemoveTargetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetMapSection.this.handleRemoveTarget();
            }
        });
        label = toolkit.createSeparator(container, 256);
        gd = new GridData(260);
        label.setLayoutData((Object)gd);
        this.mConfigureButton = toolkit.createButton(container, LABEL_CONFIGURE, 8);
        gd = new GridData(258);
        this.mConfigureButton.setLayoutData((Object)gd);
        this.mConfigureButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TargetMapSection.this.handleConfigurePackage();
            }
        });
        this.getSection().setClient((Control)container);
        this.updateButtons();
        toolkit.paintBordersFor(container);
    }

    protected void helpActivated(HyperlinkEvent event) {
        HelpUtilities.displayHelp((String)IHelpConstants.CONTEXT_ID_CONFIGURATION_PAGE_TARGET_MAP_SECTION);
    }

    protected void setModelRoot(EObject modelRoot) {
        if (!(modelRoot instanceof Root)) {
            throw new IllegalArgumentException("modelRoot must be of type " + Root.class);
        }
        this.mTargetMapViewer.getViewer().setInput((Object)((Root)modelRoot));
    }

    private IProject getSourceProject() {
        IEditorInput input = this.getEMFFormEditor().getEditorInput();
        IProject project = input instanceof IFileEditorInput ? ((IFileEditorInput)input).getFile().getProject() : null;
        return project;
    }

    private void handleAddPackage() {
        PackageSelectionDialogPage psd = new PackageSelectionDialogPage();
        psd.init(this.getSourceProject(), (Root)this.getResourceEditingContainer().getModelRoot());
        Dialog dialog = new Dialog(this.getSection().getShell(), (IDialogPage)psd);
        if (dialog.open() == 0) {
            IResource[] resources = psd.getSelection();
            Vector<DeployPackage> newPackages = new Vector<DeployPackage>(resources.length);
            int index = 0;
            int count = resources.length;
            while (index < count) {
                newPackages.add(DeployFilePackage.eINSTANCE.getDeployFileFactory().createDeployPackage(resources[index].getFullPath().toString()));
                ++index;
            }
            EditingDomain editingDomain = this.getResourceEditingContainer().getEditingDomain();
            Command command = AddCommand.create((EditingDomain)editingDomain, (Object)this.getResourceEditingContainer().getModelRoot(), (Object)DeployFilePackage.eINSTANCE.getRoot_Package(), newPackages);
            editingDomain.getCommandStack().execute(command);
        }
    }

    private void handleRemovePackage() {
        Vector packages = new Vector(((IStructuredSelection)this.mTargetMapViewer.getViewer().getSelection()).toList());
        Root root = (Root)this.getResourceEditingContainer().getModelRoot();
        Vector danglingServers = new Vector(root.getServer());
        Vector configs = new Vector(danglingServers.size());
        Iterator it = packages.iterator();
        while (it.hasNext()) {
            configs.addAll(((DeployPackage)it.next()).getTargetConfiguration());
        }
        it = danglingServers.iterator();
        while (it.hasNext()) {
            if (configs.containsAll((Collection<?>)((DeployServer)it.next()).getTargetingConfiguration())) continue;
            it.remove();
        }
        packages.addAll(danglingServers);
        packages.addAll(configs);
        EditingDomain editingDomain = this.getEditingDomain();
        Command removeCommand = RemoveCommand.create((EditingDomain)editingDomain, packages);
        editingDomain.getCommandStack().execute(removeCommand);
    }

    private void handleAddTarget() {
        DeployPackage pkg = (DeployPackage)((IStructuredSelection)this.mTargetMapViewer.getViewer().getSelection()).getFirstElement();
        ServerSelectionDialogPage page = new ServerSelectionDialogPage();
        page.init(pkg, null);
        Dialog dialog = new Dialog(this.getSection().getShell(), (IDialogPage)page);
        if (dialog.open() == 0) {
            EditingDomain editingDomain = this.getEditingDomain();
            editingDomain.getCommandStack().execute(Utilities.createAddDeployConfigurationCommand((EditingDomain)editingDomain, (DeployPackage)pkg, (DeployServer)page.getSelectedDeployServer()));
        }
    }

    private void handleChangeTarget() {
        DeployConfiguration config = (DeployConfiguration)((IStructuredSelection)this.mTargetMapViewer.getViewer().getSelection()).getFirstElement();
        DeployServer target = config.getTargetServer();
        ServerSelectionDialogPage page = new ServerSelectionDialogPage();
        page.init(config.getSourcePackage(), target);
        Dialog dialog = new Dialog(this.getSection().getShell(), (IDialogPage)page);
        if (dialog.open() == 0) {
            EditingDomain editingDomain = this.getEditingDomain();
            DeployServer newTarget = page.getSelectedDeployServer();
            if (newTarget.equals(target)) {
                return;
            }
            Vector<Command> commands = new Vector<Command>(3);
            commands.add(SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)DeployFilePackage.eINSTANCE.getDeployConfiguration_TargetServer(), (Object)newTarget));
            if (newTarget.getRoot() == null) {
                commands.add(AddCommand.create((EditingDomain)editingDomain, (Object)((Root)this.getResourceEditingContainer().getModelRoot()), (Object)DeployFilePackage.eINSTANCE.getRoot_Server(), (Object)newTarget));
            }
            if (target.getTargetingConfiguration().size() == 1) {
                commands.add(RemoveCommand.create((EditingDomain)editingDomain, (Object)target));
            }
            editingDomain.getCommandStack().execute((Command)new CompoundCommand(commands));
        }
    }

    private void handleRemoveTarget() {
        Vector configs = new Vector(((IStructuredSelection)this.mTargetMapViewer.getViewer().getSelection()).toList());
        Root root = (Root)this.getResourceEditingContainer().getModelRoot();
        Vector danglingServers = new Vector(root.getServer());
        Iterator it = danglingServers.iterator();
        while (it.hasNext()) {
            if (configs.containsAll((Collection<?>)((DeployServer)it.next()).getTargetingConfiguration())) continue;
            it.remove();
        }
        configs.addAll(danglingServers);
        EditingDomain editingDomain = this.getEditingDomain();
        editingDomain.getCommandStack().execute(RemoveCommand.create((EditingDomain)editingDomain, configs));
    }

    private void handleConfigurePackage() {
        block20: {
            DeployConfiguration config = (DeployConfiguration)((IStructuredSelection)this.mTargetMapViewer.getViewer().getSelection()).getFirstElement();
            IPackageConfiguration packageConfiguration = null;
            try {
                IConfigurablePackage pkg = Utilities.adaptToIConfigurablePackage((EObject)config);
                if (pkg == null) {
                    return;
                }
                IPackageConfigurationManager packageConfigManager = ((IConfigurablePackageExtension)pkg.getExtension()).getPackageConfigurationManager();
                byte[] configBytes = config.getConfigOverride();
                if (configBytes != null) {
                    try {
                        packageConfiguration = packageConfigManager.createPackageConfiguration(pkg, new ByteArrayInputStream(configBytes));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (packageConfiguration == null) {
                    packageConfiguration = packageConfigManager.createPackageConfiguration(pkg);
                }
                ConfigurationDialog dialog = new ConfigurationDialog(this.getSection().getShell(), packageConfiguration);
                dialog.create();
                dialog.getShell().setText(MessageFormat.format(DeployCorePlugin.getDefault().getResourceString("ConfigurationDialog.TITLE"), new Path(config.getSourcePackage().getPackageFile()).lastSegment(), config.getTargetServer().getProfileName()));
                if (dialog.open() != 0) break block20;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    try {
                        packageConfigManager.serializePackageConfiguration(packageConfiguration, baos);
                        EditingDomain editingDomain = this.getEditingDomain();
                        editingDomain.getCommandStack().execute(SetCommand.create((EditingDomain)editingDomain, (Object)config, (Object)DeployFilePackage.eINSTANCE.getDeployConfiguration_ConfigOverride(), (Object)baos.toByteArray()));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            baos.close();
                        }
                        catch (IOException iOException) {}
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        baos.close();
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            finally {
                if (packageConfiguration != null) {
                    packageConfiguration.dispose();
                }
            }
        }
    }

    private void handleTargetMapSelectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
        this.fireSelectionChanged(event.getSelection());
    }

    private void handleTargetMapDoubleClick(DoubleClickEvent event) {
        Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if (element instanceof DeployPackage) {
            this.handleAddTarget();
        } else {
            this.handleConfigurePackage();
        }
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.mTargetMapViewer.getViewer().getSelection();
        if (selection.isEmpty()) {
            this.mRemoveButton.setEnabled(false);
            this.mAddTargetButton.setEnabled(false);
            this.mChangeTargetButton.setEnabled(false);
            this.mRemoveTargetButton.setEnabled(false);
            this.mConfigureButton.setEnabled(false);
        } else if (selection.size() > 1) {
            int selectionType = 0;
            for (Object element : selection) {
                if (element instanceof DeployPackage) {
                    selectionType |= 2;
                    continue;
                }
                selectionType |= 4;
            }
            this.mRemoveButton.setEnabled(selectionType == 2);
            this.mAddTargetButton.setEnabled(false);
            this.mChangeTargetButton.setEnabled(false);
            this.mRemoveTargetButton.setEnabled(selectionType == 4);
            this.mConfigureButton.setEnabled(false);
        } else {
            Object element = selection.getFirstElement();
            this.mRemoveButton.setEnabled(element instanceof DeployPackage);
            this.mAddTargetButton.setEnabled(element instanceof DeployPackage);
            this.mChangeTargetButton.setEnabled(element instanceof DeployConfiguration);
            this.mRemoveTargetButton.setEnabled(element instanceof DeployConfiguration);
            this.mConfigureButton.setEnabled(element instanceof DeployConfiguration && Utilities.adaptToIConfigurablePackage((EObject)element) != null);
        }
    }

    private EditingDomain getEditingDomain() {
        return this.getResourceEditingContainer().getEditingDomain();
    }

    public boolean setFormInput(Object input) {
        boolean retVal;
        StructuredSelection selection = null;
        if (input instanceof DeployPackage || input instanceof DeployConfiguration) {
            selection = new StructuredSelection(input);
        } else if (input instanceof Collection) {
            selection = new StructuredSelection(((Collection)input).toArray());
        }
        if (selection != null) {
            this.mTargetMapViewer.getViewer().setSelection((ISelection)selection);
            this.mTargetMapViewer.getViewer().getTree().setFocus();
            retVal = true;
        } else {
            retVal = false;
        }
        return retVal;
    }

    private class TargetMapDropListener
    extends ViewerDropAdapter {
        public TargetMapDropListener(Viewer viewer) {
            super(viewer);
        }

        public void dragOver(DropTargetEvent event) {
            if ((event.operations & 4) == 4) {
                event.detail = 4;
            }
            super.dragOver(event);
        }

        public void drop(DropTargetEvent event) {
            super.drop(event);
            event.detail = 4;
        }

        public boolean performDrop(Object data) {
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            if (transferType != null && (LocalSelectionTransfer.getInstance().isSupportedType(transferType) || ResourceTransfer.getInstance().isSupportedType(transferType))) {
                return this.validateSource();
            }
            return false;
        }

        private boolean validateSource() {
            return false;
        }
    }
}

