/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.deploy.runtime.tuscany.core.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.stp.soas.deploy.runtime.tuscany.TuscanyRuntimePlugin;
import org.eclipse.stp.soas.deploy.runtime.tuscany.core.internal.ITuscanyVersionHandler;
import org.eclipse.stp.soas.deploy.runtime.tuscany.core.internal.RuntimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tuscany1XVersionHandler
implements ITuscanyVersionHandler {
    private static String LIB_DIR_NAME = "lib";
    private static String FACADED_JAR_NAME = "tuscany-sca-manifest.jar";
    private static final FilenameFilter SCA_JAR = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            return name.startsWith("tuscany-sca-all-1.") && name.endsWith("-incubating.jar");
        }
    };

    @Override
    public List<IRuntimeClasspathEntry> getRuntimeClasspath(IPath installPath) {
        String[] jars;
        ArrayList<IRuntimeClasspathEntry> cp = new ArrayList<IRuntimeClasspathEntry>();
        String libPath = installPath.append(LIB_DIR_NAME).makeAbsolute().toOSString();
        String filePath = String.valueOf(libPath) + File.separator + FACADED_JAR_NAME;
        String[] stringArray = jars = RuntimeUtils.getLibEntryInManifest(filePath);
        int n = jars.length;
        int n2 = 0;
        while (n2 < n) {
            String libName = stringArray[n2];
            IPath path = installPath.append(LIB_DIR_NAME).append(libName);
            cp.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
            ++n2;
        }
        return cp;
    }

    @Override
    public boolean verifyInstallPath(IPath installPath) {
        File[] files;
        if (installPath == null) {
            return false;
        }
        if (!TuscanyRuntimePlugin.verifyInstallPath(installPath)) {
            return false;
        }
        String dir = installPath.toOSString();
        if (!dir.endsWith(File.separator)) {
            dir = String.valueOf(dir) + File.separator;
        }
        return (files = new File(String.valueOf(dir) + "lib").listFiles(SCA_JAR)) != null && files.length != 0;
    }
}

