/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.stp.xef.IXMLProvider;
import org.eclipse.stp.xef.XMLUtil;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiXMLProvider
implements IXMLProvider {
    private final List<IXMLProvider> providers;
    private final SAXBuilder builder = new SAXBuilder();
    private final Map<IXMLProvider, String> originalXMLs = new HashMap<IXMLProvider, String>();
    private String selection;

    public MultiXMLProvider(List<IXMLProvider> ps) {
        this.providers = ps;
        if (ps == null) {
            throw new NullPointerException();
        }
        if (ps.size() == 0) {
            throw new IllegalArgumentException("Must have at least one provider");
        }
    }

    @Override
    public String getRootElementQName() {
        return this.providers.get(0).getRootElementQName();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized String getXML() {
        this.originalXMLs.clear();
        try {
            Element rootElement = null;
            LinkedList<String> commonElements = new LinkedList<String>();
            boolean first = true;
            for (IXMLProvider provider : this.providers) {
                Element root;
                String orgXML = provider.getXML();
                this.originalXMLs.put(provider, orgXML);
                Document d = this.builder.build((InputStream)new ByteArrayInputStream(orgXML.getBytes()));
                if (first) {
                    root = d.getRootElement();
                    rootElement = new Element(root.getName(), root.getNamespace());
                    for (Element el : root.getChildren()) {
                        commonElements.add(XMLUtil.canonicalize(el));
                    }
                    first = false;
                    continue;
                }
                root = d.getRootElement();
                if (!rootElement.getName().equals(root.getName()) || !rootElement.getNamespace().getURI().equals(root.getNamespace().getURI())) {
                    return "";
                }
                ArrayList copy = new ArrayList(commonElements);
                for (Object el : root.getChildren()) {
                    copy.remove(XMLUtil.canonicalize(el));
                }
                for (Object el : copy) {
                    commonElements.remove(el);
                }
            }
            StringBuilder sb = new StringBuilder();
            String canonicalRoot = XMLUtil.canonicalize(rootElement);
            int idx = canonicalRoot.indexOf("</");
            if (idx < 0) {
                return null;
            }
            sb.append(canonicalRoot.substring(0, idx));
            for (String el : commonElements) {
                sb.append(el);
            }
            sb.append(canonicalRoot.substring(idx));
            this.selection = sb.toString();
            return this.selection;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setXML(String xml) {
        for (IXMLProvider provider : this.providers) {
            try {
                provider.setXML(XMLUtil.mergeXMLBack(this.originalXMLs.get(provider), this.selection, xml));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

