/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.xef;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.ui.xef.XefPlugin;
import org.eclipse.stp.ui.xef.schema.SchemaElement;
import org.eclipse.stp.ui.xef.schema.SchemaRegistry;
import org.eclipse.stp.xef.ExtSchemaProviderDelegate;
import org.eclipse.stp.xef.ISchemaProvider;
import org.eclipse.stp.xef.ISchemaProviderExt;
import org.eclipse.stp.xef.IShadowProvider;
import org.eclipse.stp.xef.QNameComparator;
import org.eclipse.stp.xef.XMLInstanceElement;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaProviderFilterWrapper
implements ISchemaProviderExt {
    private Map<String, Set<String>> allowedElements = null;
    private Map<QName, DisallowedInfo> disallowedElements = null;
    private Set<String> allowedSnippets = null;
    private Map<String, DisallowedInfo> disallowedSnippets = null;
    private final ISchemaProviderExt delegate;
    private final List<QName> alreadyApplied;
    private final IShadowProvider shadowProvider;
    private final boolean uniqueDefault;

    public SchemaProviderFilterWrapper(ISchemaProvider schemaProvider, List<XMLInstanceElement> filteredElements, boolean unique) {
        this.delegate = schemaProvider instanceof ISchemaProviderExt ? (ISchemaProviderExt)schemaProvider : new ExtSchemaProviderDelegate(schemaProvider);
        this.alreadyApplied = new ArrayList<QName>(filteredElements.size());
        for (XMLInstanceElement el : filteredElements) {
            Element jdomEl = el.getJDOMElement();
            this.alreadyApplied.add(new QName(jdomEl.getNamespaceURI(), jdomEl.getName(), jdomEl.getNamespacePrefix()));
        }
        this.shadowProvider = new ShadowProvider();
        this.uniqueDefault = unique;
    }

    public IShadowProvider getShadowProvider() {
        return this.shadowProvider;
    }

    public String getSchema(String namespace) {
        return this.delegate.getSchema(namespace);
    }

    public String getSnippet(String name) {
        this.initializeSnippets();
        if (this.allowedSnippets.contains(name)) {
            return this.delegate.getSnippet(name);
        }
        return null;
    }

    public Collection<String> listSchemaNamespaces(String filter) {
        return this.delegate.listSchemaNamespaces(filter);
    }

    public Collection<String> listElements(String namespace) {
        this.initializeSchemas();
        Set<String> elements = this.allowedElements.get(namespace);
        if (elements != null) {
            return elements;
        }
        return Collections.emptySet();
    }

    public Collection<String> listSnippets(String filter) {
        this.initializeSnippets();
        return this.allowedSnippets;
    }

    private synchronized void initializeSchemas() {
        if (this.allowedElements != null) {
            return;
        }
        this.allowedElements = new HashMap<String, Set<String>>();
        this.disallowedElements = new HashMap<QName, DisallowedInfo>();
        SchemaRegistry sr = XefPlugin.getDefault().getSchemaRegistry();
        HashMap<String, ArrayList<QName>> disallowedQualifiers = new HashMap<String, ArrayList<QName>>();
        ArrayList<QName> l = new ArrayList<QName>();
        for (String ns : this.delegate.listSchemaNamespaces(null)) {
            for (String name : this.delegate.listElements(ns)) {
                l.add(new QName(ns, name));
            }
        }
        for (QName appl : this.alreadyApplied) {
            SchemaElement se = sr.getSchemaElement(appl.getNamespaceURI(), appl.getLocalPart(), true, new ISchemaProvider[]{this.delegate});
            if (se == null) continue;
            if (this.isUnique(se)) {
                l.remove(appl);
                this.disallowedElements.put(appl, DisallowedInfo.alreadyApplied(new QName[]{appl}));
            }
            for (Map.Entry entry : se.getQualifiers().entrySet()) {
                if (((Boolean)entry.getValue()).booleanValue()) continue;
                ArrayList<QName> reasons = (ArrayList<QName>)disallowedQualifiers.get(entry.getKey());
                if (reasons == null) {
                    reasons = new ArrayList<QName>();
                    disallowedQualifiers.put((String)entry.getKey(), reasons);
                }
                reasons.add(appl);
            }
        }
        Iterator it = l.iterator();
        while (it.hasNext()) {
            DisallowedInfo disallowedInfo;
            QName qn = (QName)it.next();
            SchemaElement el = sr.getSchemaElement(qn.getNamespaceURI(), qn.getLocalPart(), true, new ISchemaProvider[]{this.delegate});
            for (String string : el.getQualifiers().keySet()) {
                if (!disallowedQualifiers.containsKey(string)) continue;
                it.remove();
                this.disallowedElements.put(qn, DisallowedInfo.alreadyApplied((Collection)disallowedQualifiers.get(string)));
                break;
            }
            if (el.getRequires().size() == 0 || (disallowedInfo = SchemaProviderFilterWrapper.requirementsSatisfied(el, this.alreadyApplied)) == null) continue;
            it.remove();
            this.disallowedElements.put(qn, disallowedInfo);
        }
        for (QName qn : l) {
            Set<String> elements = this.allowedElements.get(qn.getNamespaceURI());
            if (elements == null) {
                elements = new HashSet<String>();
                this.allowedElements.put(qn.getNamespaceURI(), elements);
            }
            elements.add(qn.getLocalPart());
        }
    }

    private boolean isUnique(SchemaElement el) {
        Boolean unique = el.getUnique();
        if (unique != null) {
            return unique;
        }
        return this.uniqueDefault;
    }

    private static DisallowedInfo requirementsSatisfied(SchemaElement el, Collection<QName> applied) {
        List<List<String>> requirements = el.getRequires();
        if (requirements.size() == 0) {
            return null;
        }
        for (List<String> required : requirements) {
            if (!SchemaProviderFilterWrapper.requirementSatisfied(required, applied)) continue;
            return null;
        }
        Collection<QName> causedBy = SchemaProviderFilterWrapper.flatten(requirements);
        causedBy.removeAll(applied);
        return DisallowedInfo.required(causedBy);
    }

    private static boolean requirementSatisfied(List<String> required, Collection<QName> applied) {
        for (String r : required) {
            QName qn = QName.valueOf(r);
            if (applied.contains(qn)) continue;
            return false;
        }
        return true;
    }

    private static Collection<QName> flatten(List<List<String>> requires) {
        ArrayList<QName> result = new ArrayList<QName>();
        for (List<String> l : requires) {
            for (String s : l) {
                result.add(QName.valueOf(s));
            }
        }
        return result;
    }

    private synchronized void initializeSnippets() {
        if (this.allowedSnippets != null) {
            return;
        }
        this.initializeSchemas();
        this.allowedSnippets = new HashSet<String>();
        this.disallowedSnippets = new HashMap<String, DisallowedInfo>();
        SchemaRegistry sr = XefPlugin.getDefault().getSchemaRegistry();
        SAXBuilder builder = new SAXBuilder();
        for (String name : this.delegate.listSnippets(null)) {
            String snippet = this.delegate.getSnippet(name);
            String xml = "<root>" + snippet + "</root>";
            try {
                ArrayList<DisallowedInfo> disallowReasons = new ArrayList<DisallowedInfo>();
                Document doc = builder.build((InputStream)new ByteArrayInputStream(xml.getBytes()));
                for (Object child : doc.getRootElement().getChildren()) {
                    Element el;
                    QName childQName;
                    if (!(child instanceof Element) || !this.disallowedElements.containsKey(childQName = new QName((el = (Element)child).getNamespaceURI(), el.getName()))) continue;
                    DisallowedInfo info = this.disallowedElements.get(childQName);
                    if (info.reason == DisallowanceReason.ALREADY_APPLIED) {
                        disallowReasons.add(info);
                        continue;
                    }
                    List<QName> allNS = SchemaProviderFilterWrapper.getQNames(doc.getRootElement().getChildren());
                    allNS.remove(childQName);
                    allNS.addAll(this.alreadyApplied);
                    SchemaElement se = sr.getSchemaElement(el.getNamespaceURI(), el.getName(), true, new ISchemaProvider[]{this.delegate});
                    DisallowedInfo newInfo = SchemaProviderFilterWrapper.requirementsSatisfied(se, allNS);
                    if (newInfo == null) continue;
                    disallowReasons.add(newInfo);
                }
                if (disallowReasons.size() == 0) {
                    this.allowedSnippets.add(name);
                    continue;
                }
                this.disallowedSnippets.put(name, this.formatReasons(disallowReasons));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private DisallowedInfo formatReasons(List<DisallowedInfo> disallowReasons) {
        boolean containsAlreadyApplied = false;
        for (DisallowedInfo i : disallowReasons) {
            if (i.reason != DisallowanceReason.ALREADY_APPLIED) continue;
            containsAlreadyApplied = true;
            break;
        }
        if (containsAlreadyApplied) {
            Iterator<DisallowedInfo> it = disallowReasons.iterator();
            while (it.hasNext()) {
                DisallowedInfo i = it.next();
                if (i.reason != DisallowanceReason.REQUIRES) continue;
                it.remove();
            }
        }
        DisallowedInfo info = new DisallowedInfo();
        for (DisallowedInfo i : disallowReasons) {
            info.causes.addAll(i.causes);
            info.reason = i.reason;
        }
        return info;
    }

    private static List<QName> getQNames(List<?> children) {
        ArrayList<QName> l = new ArrayList<QName>();
        for (Object o : children) {
            if (!(o instanceof Element)) continue;
            Element el = (Element)o;
            l.add(new QName(el.getNamespaceURI(), el.getName()));
        }
        return l;
    }

    public boolean getUniqueDefault() {
        return this.uniqueDefault;
    }

    public synchronized void refresh() {
        this.delegate.refresh();
        this.allowedSnippets = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DisallowanceReason {
        ALREADY_APPLIED{

            public String toString() {
                return "already applied";
            }
        }
        ,
        REQUIRES{

            public String toString() {
                return "required";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DisallowedInfo {
        final Collection<QName> causes = new TreeSet<QName>(new QNameComparator());
        DisallowanceReason reason;

        private DisallowedInfo() {
        }

        private static DisallowedInfo alreadyApplied(QName ... appl) {
            return DisallowedInfo.alreadyApplied((Collection<QName>)Arrays.asList(appl));
        }

        private static DisallowedInfo alreadyApplied(Collection<QName> appl) {
            DisallowedInfo info = new DisallowedInfo();
            info.causes.addAll(appl);
            info.reason = DisallowanceReason.ALREADY_APPLIED;
            return info;
        }

        public static DisallowedInfo required(Collection<QName> req) {
            DisallowedInfo info = new DisallowedInfo();
            info.causes.addAll(req);
            info.reason = DisallowanceReason.REQUIRES;
            return info;
        }
    }

    private class ShadowProvider
    implements IShadowProvider {
        Map<String, List<Object>> shadowed = new HashMap<String, List<Object>>();
        Map<Object, String> reasons = new HashMap<Object, String>();
        boolean initialized = false;
        boolean snippetsInitialized = false;

        private ShadowProvider() {
        }

        private synchronized void initialize() {
            if (this.initialized) {
                return;
            }
            SchemaProviderFilterWrapper.this.initializeSchemas();
            SchemaRegistry sr = XefPlugin.getDefault().getSchemaRegistry();
            for (QName filter : SchemaProviderFilterWrapper.this.disallowedElements.keySet()) {
                try {
                    List<Object> l;
                    SchemaElement se = sr.getSchemaElement(filter.getNamespaceURI(), filter.getLocalPart(), true, new ISchemaProvider[]{SchemaProviderFilterWrapper.this.delegate});
                    String cat = se.getCategory();
                    if (cat == null) {
                        cat = "Uncategorized";
                    }
                    if ((l = this.shadowed.get(cat)) == null) {
                        l = new ArrayList<Object>();
                        this.shadowed.put(cat, l);
                    }
                    l.add(se);
                    DisallowedInfo info = (DisallowedInfo)SchemaProviderFilterWrapper.this.disallowedElements.get(filter);
                    this.reasons.put(se, this.formatDisallowedInfo(filter, info));
                }
                catch (Exception e) {
                    Status status = new Status(4, "org.eclipse.stp.xef", 0, "Problem handling schema", (Throwable)e);
                    XefPlugin.getDefault().getLog().log((IStatus)status);
                }
            }
            this.initialized = true;
        }

        private synchronized void initializeSnippetCategory() {
            if (this.snippetsInitialized) {
                return;
            }
            SchemaProviderFilterWrapper.this.initializeSnippets();
            List<Object> l = this.shadowed.get("Composite Policies");
            if (l == null) {
                l = new ArrayList<Object>();
                this.shadowed.put("Composite Policies", l);
            }
            for (Map.Entry disallowed : SchemaProviderFilterWrapper.this.disallowedSnippets.entrySet()) {
                l.add(disallowed.getKey());
                this.reasons.put(disallowed.getKey(), this.formatDisallowedInfo(disallowed.getKey(), (DisallowedInfo)disallowed.getValue()));
            }
            this.snippetsInitialized = true;
        }

        private String formatDisallowedInfo(Object context, DisallowedInfo info) {
            int idx;
            if (info.causes.size() == 1 && info.reason == DisallowanceReason.ALREADY_APPLIED && info.causes.iterator().next().equals(context)) {
                return info.reason.toString();
            }
            String sep = ", ";
            SchemaRegistry sr = XefPlugin.getDefault().getSchemaRegistry();
            StringBuilder sb = new StringBuilder();
            for (QName qname : info.causes) {
                SchemaElement se = sr.getSchemaElement(qname.getNamespaceURI(), qname.getLocalPart(), true, new ISchemaProvider[]{SchemaProviderFilterWrapper.this.delegate});
                if (se == null) continue;
                sb.append(se.getDisplayName());
                sb.append(sep);
            }
            if (sb.length() > 2) {
                sb.setLength(sb.length() - 2);
                sb.append(' ');
            }
            if (info.reason == DisallowanceReason.REQUIRES && (idx = sb.lastIndexOf(sep)) != -1) {
                sb.replace(idx, idx + sep.length(), " and/or ");
            }
            return String.valueOf(sb.toString()) + info.reason.toString();
        }

        public String getReason(Object shadowed) {
            this.initialize();
            return this.reasons.get(shadowed);
        }

        public String[] getShadowCategories() {
            this.initialize();
            Set<String> s = this.shadowed.keySet();
            return s.toArray(new String[s.size()]);
        }

        public Object[] getShadowed(String category) {
            if ("Composite Policies".equals(category)) {
                this.initializeSnippetCategory();
            } else {
                this.initialize();
            }
            List<Object> l = this.shadowed.get(category);
            if (l != null) {
                return l.toArray(new Object[l.size()]);
            }
            return null;
        }
    }
}

