/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.edit.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutAnimator;
import org.eclipse.draw2d.LayoutListener;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGeometry;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramDragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderItemsAwareFreeFormLayer;
import org.eclipse.gmf.runtime.diagram.ui.figures.CanonicalShapeCompartmentLayout;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.Pool;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnEditPartFactory;
import org.eclipse.stp.bpmn.diagram.edit.policies.BpmnDiagramCanonicalEditPolicy;
import org.eclipse.stp.bpmn.diagram.edit.policies.BpmnDiagramItemSemanticEditPolicy;
import org.eclipse.stp.bpmn.figures.GroupFigure;
import org.eclipse.stp.bpmn.policies.BpmnDiagramXYLayoutEditPolicy;
import org.eclipse.stp.bpmn.policies.BpmnDragDropEditPolicy;
import org.eclipse.stp.bpmn.policies.PopupBarEditPolicyEx;

public class BpmnDiagramEditPart
extends DiagramEditPart {
    public static String MODEL_ID = "Bpmn";
    public static final int VISUAL_ID = 79;

    public BpmnDiagramEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPoliciesGen() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new BpmnDiagramItemSemanticEditPolicy());
        this.installEditPolicy("Canonical", (EditPolicy)new BpmnDiagramCanonicalEditPolicy());
    }

    protected void createDefaultEditPolicies() {
        this.createDefaultEditPoliciesGen();
        this.installEditPolicy("PopupBarEditPolicy", (EditPolicy)new PopupBarEditPolicyEx());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DiagramDragDropEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new BpmnDragDropEditPolicy((IGraphicalEditPart)this));
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new BpmnDiagramXYLayoutEditPolicy());
    }

    protected IFigure createFigure() {
        BorderItemsAwareFreeFormLayer f = new BorderItemsAwareFreeFormLayer(){
            private Point PRIVATE_POINT = new Point();

            public boolean containsPoint(int x, int y) {
                return this.getBounds().contains(x, y);
            }

            public IFigure findFigureAt(int x, int y, TreeSearch search) {
                if (!this.isEnabled()) {
                    return null;
                }
                if (!this.containsPoint(x, y)) {
                    return null;
                }
                if (search.prune((IFigure)this)) {
                    return null;
                }
                IFigure child = this.findDescendantAtExcluding(x, y, search);
                if (child != null) {
                    return child;
                }
                if (search.accept((IFigure)this)) {
                    return this;
                }
                return null;
            }

            public void validate() {
                super.validate();
            }

            protected IFigure findMouseEventTargetInDescendantsAt(int x, int y) {
                this.PRIVATE_POINT.setLocation(x, y);
                this.translateFromParent((Translatable)this.PRIVATE_POINT);
                if (!this.getClientArea(Rectangle.SINGLETON).contains(this.PRIVATE_POINT)) {
                    return null;
                }
                int i = this.getChildren().size();
                while (i > 0) {
                    IFigure fig = (IFigure)this.getChildren().get(--i);
                    if (!fig.isVisible() || !fig.isEnabled() || !fig.containsPoint(this.PRIVATE_POINT.x, this.PRIVATE_POINT.y) || (fig = fig.findMouseEventTargetAt(this.PRIVATE_POINT.x, this.PRIVATE_POINT.y)) instanceof GroupFigure || fig != null && fig.getParent() instanceof GroupFigure) continue;
                    return fig;
                }
                return null;
            }
        };
        f.setLayoutManager((LayoutManager)new CanonicalShapeCompartmentLayout(Collections.emptyMap()));
        f.addLayoutListener((LayoutListener)LayoutAnimator.getDefault());
        f.addLayoutListener((LayoutListener)new PageBreaksLayoutListener());
        f.setBorder((Border)new MarginBorder(new Insets(16, 16, 80, 16)));
        return f;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == SnapToHelper.class) {
            ArrayList<Object> snapStrategies = new ArrayList<Object>();
            Boolean val = (Boolean)this.getViewer().getProperty("ruler$visibility");
            if (val != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGuides((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGeometry.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGeometry((GraphicalEditPart)this));
            }
            if ((val = (Boolean)this.getViewer().getProperty("SnapToGrid.isEnabled")) != null && val.booleanValue()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.size() == 0) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return snapStrategies.get(0);
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            int i = 0;
            while (i < snapStrategies.size()) {
                ss[i] = (SnapToHelper)snapStrategies.get(i);
                ++i;
            }
            return new CompoundSnapToHelper(ss);
        }
        return super.getAdapter(adapter);
    }

    protected void handleNotificationEvent(Notification event) {
        Object obj;
        super.handleNotificationEvent(event);
        if (event.getEventType() == 4) {
            Object obj2 = event.getOldValue();
            if (obj2 instanceof Pool) {
                ChangeBoundsRequest req = new ChangeBoundsRequest((Object)"move children");
                req.setEditParts(Collections.EMPTY_LIST);
                Command command = this.getCommand((Request)req);
                if (command != null) {
                    command.execute();
                }
            }
        } else if (event.getEventType() == 3 && (obj = event.getOldValue()) instanceof Pool) {
            this.handleMajorSemanticChange();
        }
    }

    public void setParent(EditPart parent) {
        if (parent != null) {
            DiagramRootEditPart root;
            Object object = root = parent instanceof DiagramRootEditPart ? (DiagramRootEditPart)parent : parent.getRoot();
            if (root != null && root instanceof DiagramRootEditPart) {
                BpmnEditPartFactory.setupConnectionLayerExEx(root);
            }
        }
        super.setParent(parent);
    }

    protected List getModelChildren() {
        Object model = this.getModel();
        if (model != null && model instanceof View) {
            EList list = ((View)model).getVisibleChildren();
            ArrayList res = new ArrayList();
            ArrayList artifacts = new ArrayList();
            for (Object object : list) {
                Node node = (Node)object;
                if (node.getType().equals(Integer.toString(1004)) || node.getType().equals(Integer.toString(1003)) || node.getType().equals(Integer.toString(1002))) {
                    artifacts.add(object);
                    continue;
                }
                res.add(object);
            }
            res.addAll(artifacts);
            return res;
        }
        return Collections.EMPTY_LIST;
    }

    private class PageBreaksLayoutListener
    extends LayoutListener.Stub {
        private PageBreaksLayoutListener() {
        }

        public void postLayout(IFigure container) {
            super.postLayout(container);
            BpmnDiagramEditPart.this.updatePageBreaksLocation();
        }
    }
}

