/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.runtime;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.im.runtime.IRuntime;
import org.eclipse.stp.im.util.ImLogger;

public class RuntimeDescriptorProxy {
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_CLASS = "class";
    private static final String ATT_IS_RUNTIME_EXTENSION = "isRuntimeExtension";
    private static final String ATT_ID_EXTENDED_RUNTIME = "idExtendedRuntime";
    private final IConfigurationElement configElement;
    private final String id;
    private final String name;
    private final String isRuntimeExtension;
    private final String idExtendedRuntime;

    public RuntimeDescriptorProxy(IConfigurationElement configElement) {
        this.configElement = configElement;
        this.id = RuntimeDescriptorProxy.getAttribute(configElement, ATT_ID, null);
        this.name = RuntimeDescriptorProxy.getAttribute(configElement, ATT_NAME, this.id);
        this.isRuntimeExtension = RuntimeDescriptorProxy.getAttribute(configElement, ATT_IS_RUNTIME_EXTENSION, "false");
        this.idExtendedRuntime = RuntimeDescriptorProxy.getAttribute(configElement, ATT_ID_EXTENDED_RUNTIME, "none");
        RuntimeDescriptorProxy.getAttribute(configElement, ATT_CLASS, null);
    }

    private static String getAttribute(IConfigurationElement configElem, String name, String defaultValue) {
        String value = configElem.getAttribute(name);
        if (value != null) {
            return value;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new IllegalArgumentException("Missing " + name + " attribute");
    }

    public IRuntime getRuntime() {
        try {
            IRuntime runtime = (IRuntime)this.configElement.createExecutableExtension(ATT_CLASS);
            return runtime;
        }
        catch (Exception e) {
            ImLogger.error((String)"org.eclipse.stp.im.runtime", (String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIsRuntimeExtension() {
        return this.isRuntimeExtension;
    }

    public String getIdExtendedRuntime() {
        return this.idExtendedRuntime;
    }
}

