/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.validation.popup.actions;

import java.io.File;
import javax.wsdl.Definition;
import org.eclipse.core.resources.IFile;
import org.eclipse.stp.common.validator.core.IValidationContext;
import org.eclipse.stp.common.validator.core.IValidator;
import org.eclipse.stp.common.validator.core.ValidationObjectTypeEnum;
import org.eclipse.stp.common.validator.core.ValidatorTypeEnum;
import org.eclipse.stp.common.validator.core.impl.ValidatorFactoryDefImpl;
import org.eclipse.stp.common.validator.core.impl.service.ConsistencyValidator;
import org.eclipse.stp.common.validator.exception.ConfigurationException;
import org.eclipse.stp.common.validator.exception.ContextInitializationException;
import org.eclipse.stp.common.validator.exception.SOPValidationException;
import org.eclipse.stp.policy.wtp.validation.popup.actions.CommonValidationAction;
import org.w3c.dom.Document;

public class ImportCheckAction
extends CommonValidationAction {
    private Document sdxDocument = null;
    private Document spdxDocument = null;

    public ImportCheckAction(IFile file, Document sdxdoc, Document spdxdoc) {
        super(file);
        this.sdxDocument = sdxdoc;
        this.spdxDocument = spdxdoc;
    }

    public ImportCheckAction(File file, Document sdxdoc, Document spdxdoc) {
        super(file);
        this.sdxDocument = sdxdoc;
        this.spdxDocument = spdxdoc;
    }

    private boolean validate(Document doc, ValidationObjectTypeEnum type) throws SOPValidationException {
        boolean result = false;
        try {
            IValidationContext context = this.getValidationContext(doc, type);
            if (context != null) {
                IValidator msvValidator = ValidatorFactoryDefImpl.getInstance().getValidator(ValidatorTypeEnum.MULTISCHEMA_VALIDATOR);
                msvValidator.validate(context, this.getReporter());
                if (this.getErrorsCount() == 0) {
                    IValidator genericValidator = ValidatorFactoryDefImpl.getInstance().getValidator(ValidatorTypeEnum.GENERIC_VALIDATOR);
                    genericValidator.validate(context, this.getReporter());
                    if (this.getErrorsCount() == 0) {
                        result = true;
                    }
                }
            }
        }
        catch (ConfigurationException e) {
            throw new SOPValidationException(e.getMessage(), (Exception)((Object)e));
        }
        catch (ContextInitializationException e) {
            throw new SOPValidationException(e.getMessage(), (Exception)((Object)e));
        }
        return result;
    }

    private void validateConsistency() throws SOPValidationException {
        ConsistencyValidator consistencyValidator = new ConsistencyValidator();
        Definition sdxDefinition = consistencyValidator.openWSDLDefinition(this.sdxDocument);
        Definition spdxDefinition = consistencyValidator.openWSDLDefinition(this.spdxDocument);
        consistencyValidator.checkServiceConsistency(spdxDefinition, sdxDefinition, this.getReporter());
    }

    public void validate() throws SOPValidationException {
        super.validate();
        if (this.validate(this.sdxDocument, ValidationObjectTypeEnum.SDX_TYPE) && this.validate(this.spdxDocument, ValidationObjectTypeEnum.SPDX_TYPE)) {
            this.validateConsistency();
        }
    }
}

