/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.java.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.sca.common.java.Messages;
import org.eclipse.stp.sca.common.java.composite2java.CompositeToJavaModel;
import org.eclipse.stp.sca.common.java.composite2java.GenerationSelectionDialog;
import org.eclipse.stp.sca.common.java.composite2java.JComposite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class GenerateJavaSkeletonAction
implements IObjectActionDelegate {
    private IFile compositeFile;
    private IWorkbenchPart part;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public void run(IAction action) {
        try {
            JComposite jComposite = CompositeToJavaModel.getJavaModelFromComposite(this.compositeFile);
            if (jComposite == null) {
                throw new Exception();
            }
            final GenerationSelectionDialog dlg = new GenerationSelectionDialog(this.part.getSite().getShell(), this.compositeFile, jComposite);
            if (dlg.open() != 0) {
                return;
            }
            final IPackageFragmentRoot fRoot = dlg.getPackageFragmentRoot();
            JavaCore.run((IWorkspaceRunnable)new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    for (GenerationSelectionDialog.JavaFile jf : dlg.getSelectedFiles()) {
                        try {
                            IPackageFragment fragment = fRoot.getPackageFragment(jf.getPck().getName());
                            if (!fragment.exists()) {
                                fragment = fRoot.createPackageFragment(jf.getPck().getName(), true, monitor);
                            }
                            fragment.createCompilationUnit(String.valueOf(jf.getName()) + ".java", jf.getJInterface().getJavaCode(GenerateJavaSkeletonAction.this.compositeFile), true, monitor);
                        }
                        catch (JavaModelException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.GenerateJavaSkeletonAction_1, (String)Messages.GenerateJavaSkeletonAction_2);
        }
        catch (Exception e) {
            e.printStackTrace();
            MessageDialog.openError((Shell)this.part.getSite().getShell(), (String)Messages.GenerateJavaSkeletonAction_3, (String)Messages.GenerateJavaSkeletonAction_4);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object o;
        if (selection instanceof StructuredSelection && (o = ((StructuredSelection)selection).getFirstElement()) instanceof IFile) {
            this.compositeFile = (IFile)o;
        }
    }
}

