/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.provisional.filters;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.stp.sca.common.utils.ResourceFilterUtils;
import org.eclipse.stp.sca.common.utils.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScaAbstractResourcesFilter<T> {
    protected ResourceFilterUtils<IFolder> folderFilterUtils = new ResourceFilterUtils();

    public abstract T getProject(IProject var1);

    public abstract Set<IFolder> getFoldersToSkip(T var1);

    public Set<IFolder> getFoldersToSkip(IProject project) {
        T tProject = this.getProject(project);
        if (tProject == null) {
            return Collections.emptySet();
        }
        return this.getFoldersToSkip(tProject);
    }

    public boolean isFolderToSkip(IFolder folder) {
        IProject iProject = folder.getProject();
        T tProject = this.getProject(iProject);
        if (tProject == null) {
            return false;
        }
        Set<IFolder> binaryFolders = this.getFoldersToSkip(tProject);
        return binaryFolders.contains(folder);
    }

    public Collection<IFolder> getValidFolders(IProject project) {
        List<IFolder> foldersToFilter = ResourceUtils.getFolders((IContainer)project);
        T tProject = this.getProject(project);
        if (tProject == null) {
            return foldersToFilter;
        }
        Set<IFolder> foldersToSkip = this.getFoldersToSkip(tProject);
        return this.folderFilterUtils.filterAllowedResources(foldersToFilter, foldersToSkip);
    }
}

